/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.event.controller;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.rescue.event.manager.BizRescueInfoManager;
import com.artfess.rescue.event.model.BizRescueInfo;
import com.artfess.rescue.event.vo.CountRescueByRoadVO;
import com.artfess.rescue.event.vo.CountRescueByUserVO;
import com.artfess.rescue.event.vo.RescueLedgerVO;
import com.artfess.rescue.monitor.aop.WebSocketNotify;
import com.artfess.rescue.monitor.eunms.RefreshType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/event/bizRescueInfo/v1/"})
@Api(tags={"\u6551\u63f4\u4fe1\u606f\u5355"})
@ApiGroup(group={"group_biz_rescue"})
public class BizRescueInfoController
extends BaseController<BizRescueInfoManager, BizRescueInfo> {
    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    @WebSocketNotify(topic=RefreshType.DLYXJC, operateType="ADD")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizRescueInfo t) {
        boolean res = ((BizRescueInfoManager)this.baseService).saveInfo(t);
        return new CommonResult(res ? "\u6dfb\u52a0\u6210\u529f" : "\u6dfb\u52a0\u5931\u8d25");
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    @WebSocketNotify(topic=RefreshType.DLYXJC, operateType="DELETE")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((BizRescueInfoManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    @WebSocketNotify(topic=RefreshType.DLYXJC, operateType="UPDATE")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={UpdateGroup.class}) @RequestBody BizRescueInfo t) {
        boolean res = ((BizRescueInfoManager)this.baseService).updateInfo(t);
        if (!res) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult("\u66f4\u65b0\u5b9e\u4f53\u6210\u529f");
    }

    @RequestMapping(value={"/appoint"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6551\u63f4\u59d4\u6d3e", httpMethod="POST", notes="\u6551\u63f4\u59d4\u6d3e")
    @WebSocketNotify(topic=RefreshType.DLYXJC, operateType="ADD")
    public CommonResult<String> appoint(@RequestBody BizRescueInfo entity) {
        boolean res;
        return new CommonResult(res, (res = ((BizRescueInfoManager)this.baseService).appoint(entity)) ? "\u59d4\u6d3e\u6210\u529f" : "\u59d4\u6d3e\u5931\u8d25");
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e8b\u4ef6\u64a4\u9500", httpMethod="POST", notes="\u4e8b\u4ef6\u64a4\u9500")
    public CommonResult<String> cancel(@RequestParam(value="id") String id) {
        boolean res;
        return new CommonResult(res, (res = ((BizRescueInfoManager)this.baseService).cancel(id)) ? "\u64a4\u9500\u6210\u529f" : "\u64a4\u9500\u5931\u8d25");
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public BizRescueInfo getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((BizRescueInfoManager)this.baseService).getDetailById(id);
    }

    @RequestMapping(value={"/event/{eventId}"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4e8b\u4ef6id\u67e5\u8be2\u4e8b\u4ef6")
    public List<BizRescueInfo> getByEventId(@ApiParam(name="eventId", value="\u4e8b\u4ef6id") @PathVariable String eventId) {
        return ((BizRescueInfoManager)this.baseService).getDetailByEventId(eventId);
    }

    @RequestMapping(value={"/query"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", httpMethod="POST", notes="\u5206\u9875\u67e5\u8be2")
    public PageList<BizRescueInfo> query(@RequestBody QueryFilter<BizRescueInfo> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        return ((BizRescueInfoManager)this.baseService).query(queryFilter);
    }

    @RequestMapping(value={"/queryByPower"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5e26\u6743\u9650\u5206\u9875\u67e5\u8be2", httpMethod="POST", notes="\u5e26\u6743\u9650\u5206\u9875\u67e5\u8be2")
    public PageList<BizRescueInfo> queryByPower(@RequestBody QueryFilter<BizRescueInfo> queryFilter) {
        return ((BizRescueInfoManager)this.baseService).queryByPower(queryFilter);
    }

    @RequestMapping(value={"/queryByAppraise"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6551\u63f4\u56de\u8bbf\u67e5\u8be2", httpMethod="POST", notes="\u6551\u63f4\u56de\u8bbf\u67e5\u8be2")
    public PageList<BizRescueInfo> queryByAppraise(@RequestBody QueryFilter<BizRescueInfo> queryFilter) {
        return ((BizRescueInfoManager)this.baseService).queryByAppraise(queryFilter);
    }

    @RequestMapping(value={"/count/user"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6551\u63f4\u7edf\u8ba1-\u62d6\u8f66\u4eba\u5458\u6c47\u603b\u7edf\u8ba1", httpMethod="POST", notes="\u62d6\u8f66\u4eba\u5458\u6c47\u603b\u7edf\u8ba1")
    public CommonResult<List<CountRescueByUserVO>> countByUser(@RequestBody QueryFilter<BizRescueInfo> queryFilter) {
        return ((BizRescueInfoManager)this.baseService).countByUser(queryFilter);
    }

    @RequestMapping(value={"/count/road"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6551\u63f4\u7edf\u8ba1-\u62d6\u8f66\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1", httpMethod="POST", notes="\u62d6\u8f66\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1")
    public CommonResult<JSONObject> countByRoad(@RequestBody QueryFilter<BizRescueInfo> queryFilter) {
        return ((BizRescueInfoManager)this.baseService).countByRoad(queryFilter);
    }

    @PostMapping(value={"/export/road"})
    @ApiOperation(value="excel\u5bfc\u51fa-\u62d6\u8f66\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1", httpMethod="POST", notes="\u5de1\u68c0\u7edf\u8ba1-\u5de1\u67e5\u90e8\u95e8\u6c47\u603b\u7edf\u8ba1")
    public void exportByContent(HttpServletResponse response, @RequestBody QueryFilter<BizRescueInfo> queryFilter) throws Exception {
        CommonResult<JSONObject> result = ((BizRescueInfoManager)this.baseService).countByRoad(queryFilter);
        JSONObject object = (JSONObject)result.getValue();
        List voList = (List)object.get((Object)"data");
        ArrayList<Map> list = new ArrayList<Map>();
        if (voList != null && voList.size() > 0) {
            int i = 1;
            for (CountRescueByRoadVO vo : voList) {
                String jsonStr = JsonUtil.toJson((Object)vo);
                Map map = JsonUtil.toMap((String)jsonStr);
                map.put("sn", i);
                ++i;
                list.add(map);
            }
        }
        String tempName = "\u62d6\u8f66\u8def\u6bb5\u6c47\u603b\u7edf\u8ba1";
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("sn", "\u5e8f\u53f7");
        exportMaps.put("roadName", "\u8def\u6bb5\u540d\u79f0");
        exportMaps.put("reachSum", "30\u5206\u949f\u5230\u8fbe\u6b21\u6570(\u6b21)");
        exportMaps.put("trailersMileage", "\u62d6\u8f66\u91cc\u7a0b(km)");
        exportMaps.put("averageResponseTime", "\u5e73\u5747\u54cd\u5e94\u65f6\u95f4(\u5206)");
        exportMaps.put("averageAttendanceTime", "\u5e73\u5747\u51fa\u52e4\u65f6\u95f4(\u5206)");
        exportMaps.put("averageReachTime", "\u5e73\u5747\u5230\u8fbe\u65f6\u95f4(\u5206)");
        exportMaps.put("averageWorkTime", "\u5e73\u5747\u4f5c\u4e1a\u65f6\u95f4(\u5206)");
        exportMaps.put("averageHandlingTime", "\u5e73\u5747\u5904\u7f6e\u65f6\u95f4(\u5206)");
        exportMaps.put("trailersAmount", "\u62d6\u8f66\u603b\u91d1\u989d(\u5143)");
        HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, list);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
    }

    @PostMapping(value={"/ledger/export"})
    @ApiOperation(value="\u53f0\u8d26\u5bfc\u51fa", httpMethod="POST", notes="\u53f0\u8d26\u5bfc\u51fa")
    public ResponseEntity<?> exportToBrowser(@RequestBody QueryFilter<BizRescueInfo> queryFilter) {
        return ((BizRescueInfoManager)this.baseService).exportLedger(queryFilter);
    }

    @PostMapping(value={"/ledger"})
    @ApiOperation(value="\u53f0\u8d26\u8be6\u60c5", httpMethod="POST", notes="\u53f0\u8d26\u8be6\u60c5")
    public RescueLedgerVO getEventTaskLedger(@RequestBody QueryFilter<BizRescueInfo> queryFilter) {
        return ((BizRescueInfoManager)this.baseService).getTaskLedger(queryFilter);
    }

    @PostMapping(value={"/ledger/excelExport"})
    @ApiOperation(value="\u53f0\u8d26\u8be6\u60c5", httpMethod="POST", notes="\u53f0\u8d26\u8be6\u60c5\u5bfc\u51fa")
    public void getEventTaskLedger(HttpServletResponse response, @RequestBody QueryFilter<BizRescueInfo> queryFilter) {
        ((BizRescueInfoManager)this.baseService).ledgerExport(response, queryFilter);
    }
}

