/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.cloud.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.entity.BizDelModel;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.DateUtils;
import com.artfess.rescue.accessory.manager.AccessoryManager;
import com.artfess.rescue.accessory.model.Accessory;
import com.artfess.rescue.cloud.dao.BizCloudApplyApprovalRecordDao;
import com.artfess.rescue.cloud.dto.CloudApplyApprovalRecordDTO;
import com.artfess.rescue.cloud.enums.CloudApplyStatusEnum;
import com.artfess.rescue.cloud.manager.BizCloudApplyApprovalRecordManager;
import com.artfess.rescue.cloud.manager.BizCloudApplyManager;
import com.artfess.rescue.cloud.model.BizCloudApplyApprovalRecord;
import com.artfess.rescue.cloud.vo.ApprovalRecordVO;
import com.artfess.rescue.context.UserContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizCloudApplyApprovalRecordManagerImpl
extends BaseManagerImpl<BizCloudApplyApprovalRecordDao, BizCloudApplyApprovalRecord>
implements BizCloudApplyApprovalRecordManager {
    @Resource
    private BaseContext baseContext;
    @Resource
    private UserContextUtil userContextUtil;
    @Resource
    private BizCloudApplyManager cloudApplyManager;
    @Resource
    private AccessoryManager accessoryManager;
    private static final String FILE_CODE = "cloudApplyRecord";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(BizCloudApplyApprovalRecord cloudApplyApprovalRecord) {
        boolean saveResult = this.save((Object)cloudApplyApprovalRecord);
        if (CollectionUtils.isNotEmpty(cloudApplyApprovalRecord.getApplyRecordFile())) {
            String sourceId = cloudApplyApprovalRecord.getId();
            List<Accessory> list = cloudApplyApprovalRecord.getApplyRecordFile();
            list.forEach(e -> {
                e.setSourceId(sourceId);
                e.setGroup(FILE_CODE);
            });
            this.accessoryManager.saveBatch(list);
        }
        return saveResult;
    }

    @Override
    public boolean updateInfo(BizCloudApplyApprovalRecord cloudApplyApprovalRecord) {
        boolean result = this.updateById((Object)cloudApplyApprovalRecord);
        this.accessoryManager.delAccessoryBySourceId(cloudApplyApprovalRecord.getId());
        if (CollectionUtils.isNotEmpty(cloudApplyApprovalRecord.getApplyRecordFile())) {
            String sourceId = cloudApplyApprovalRecord.getId();
            List<Accessory> list = cloudApplyApprovalRecord.getApplyRecordFile();
            list.forEach(e -> {
                e.setSourceId(sourceId);
                e.setGroup(FILE_CODE);
            });
            this.accessoryManager.saveBatch(list);
        }
        return result;
    }

    @Override
    public PageList<BizCloudApplyApprovalRecord> queryInfoPage(QueryFilter<BizCloudApplyApprovalRecord> queryFilter) {
        List cloudApplyApprovalRecordList;
        List<String> sourceIds;
        List<Accessory> accessoryList;
        PageList query = this.query(queryFilter);
        if (CollectionUtils.isNotEmpty((Collection)query.getRows()) && CollectionUtils.isNotEmpty(accessoryList = this.accessoryManager.getAccessoryBySourceIds(sourceIds = (cloudApplyApprovalRecordList = query.getRows()).stream().map(BizCloudApplyApprovalRecord::getId).collect(Collectors.toList())))) {
            Map<String, List<Accessory>> collect = accessoryList.stream().collect(Collectors.groupingBy(Accessory::getSourceId));
            cloudApplyApprovalRecordList.forEach(e -> {
                if (collect.containsKey(e.getId())) {
                    List accessories = (List)collect.get(e.getId());
                    e.setApplyRecordFile(accessories);
                }
            });
            query.setRows(cloudApplyApprovalRecordList);
        }
        return query;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void applyStart(CloudApplyApprovalRecordDTO dto) {
        Assert.hasText((String)dto.getPrivateCloudApplyId(), (String)"\u4e91\u8d44\u6e90\u7533\u8bf7ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizCloudApplyApprovalRecord::getPrivateCloudApplyId, (Object)dto.getPrivateCloudApplyId());
        queryWrapper.eq(BizDelModel::getIsDele, (Object)"0");
        Integer version = ((BizCloudApplyApprovalRecordDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        BizCloudApplyApprovalRecord applyStart = new BizCloudApplyApprovalRecord();
        BeanUtils.copyProperties((Object)dto, (Object)((Object)applyStart));
        applyStart.setApprovalUserId(this.baseContext.getCurrentUserId());
        applyStart.setApprovalUserName(this.baseContext.getCurrentUserName());
        applyStart.setApprovalUserAccount(this.baseContext.getCurrentUserAccout());
        applyStart.setApprovalNode("\u63d0\u4ea4\u7533\u8bf7");
        applyStart.setApprovalOrgId(this.baseContext.getCurrentOrgId());
        applyStart.setApprovalOrgName(this.baseContext.getCurrentOrgName());
        applyStart.setApprovalCompanyId(this.baseContext.getCurrentOrgName());
        applyStart.setApprovalCompanyName(this.baseContext.getCurrentDeptId());
        applyStart.setApprovalDate(LocalDateTime.now());
        applyStart.setProcessingTime(0L);
        applyStart.setApprovalResult(3);
        applyStart.setNetworkPort(CloudApplyStatusEnum.DRAFT.getStatus());
        applyStart.setPortPurpose(CloudApplyStatusEnum.TODO.getStatus());
        applyStart.setVersion(Long.valueOf(version + 1));
        this.saveInfo(applyStart);
        BizCloudApplyApprovalRecord applyAgreeRecord = new BizCloudApplyApprovalRecord();
        BeanUtils.copyProperties((Object)dto, (Object)((Object)applyAgreeRecord));
        String approvalUserId = applyAgreeRecord.getApprovalUserId();
        applyAgreeRecord.setApprovalNode("\u4e3b\u7ba1\u5355\u4f4d\u5ba1\u6838");
        applyAgreeRecord.setApprovalOrgId(this.userContextUtil.getCurrentOrgIdByUserId(approvalUserId));
        applyAgreeRecord.setApprovalOrgName(this.userContextUtil.getCurrentOrgNameByUserId(approvalUserId));
        applyAgreeRecord.setApprovalCompanyId(this.userContextUtil.getCurrentDeptIdByUserId(approvalUserId));
        applyAgreeRecord.setApprovalCompanyName(this.userContextUtil.getCurrentDeptNameByUserId(approvalUserId));
        applyAgreeRecord.setApprovalDate(null);
        applyAgreeRecord.setProcessingTime(null);
        applyAgreeRecord.setApprovalResult(-1);
        applyAgreeRecord.setNetworkPort(CloudApplyStatusEnum.TODO.getStatus());
        applyAgreeRecord.setPortPurpose(null);
        applyAgreeRecord.setVersion(Long.valueOf(version + 2));
        this.saveInfo(applyAgreeRecord);
        String opinion = this.baseContext.getCurrentUserName() + "<br/>" + DateUtils.now();
        this.cloudApplyManager.updateStatus(dto.getPrivateCloudApplyId(), CloudApplyStatusEnum.TODO.getStatus(), opinion);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void applyAgree(CloudApplyApprovalRecordDTO dto) {
        Long version = this.setProcess(dto);
        BizCloudApplyApprovalRecord applyAgreeRecord = new BizCloudApplyApprovalRecord();
        BeanUtils.copyProperties((Object)dto, (Object)((Object)applyAgreeRecord));
        String approvalUserId = applyAgreeRecord.getApprovalUserId();
        applyAgreeRecord.setApprovalNode("\u8fd0\u7ef4\u5355\u4f4d\u6267\u884c");
        applyAgreeRecord.setApprovalOrgId(this.userContextUtil.getCurrentOrgIdByUserId(approvalUserId));
        applyAgreeRecord.setApprovalOrgName(this.userContextUtil.getCurrentOrgNameByUserId(approvalUserId));
        applyAgreeRecord.setApprovalCompanyId(this.userContextUtil.getCurrentDeptIdByUserId(approvalUserId));
        applyAgreeRecord.setApprovalCompanyName(this.userContextUtil.getCurrentDeptNameByUserId(approvalUserId));
        applyAgreeRecord.setApplyRecordFile(null);
        applyAgreeRecord.setApprovalDate(null);
        applyAgreeRecord.setProcessingTime(null);
        applyAgreeRecord.setIntranetPort(null);
        applyAgreeRecord.setApprovalResult(-1);
        applyAgreeRecord.setNetworkPort(CloudApplyStatusEnum.TO_BE_EXECUTE.getStatus());
        applyAgreeRecord.setPortPurpose(CloudApplyStatusEnum.EXECUTE.getStatus());
        applyAgreeRecord.setVersion(version + 1L);
        this.saveInfo(applyAgreeRecord);
        String opinion = dto.getIntranetPort() + "<br/>" + this.baseContext.getCurrentUserName() + "<br/>" + DateUtils.now();
        this.cloudApplyManager.updateStatus(dto.getPrivateCloudApplyId(), CloudApplyStatusEnum.TO_BE_EXECUTE.getStatus(), opinion);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void applyReject(CloudApplyApprovalRecordDTO dto) {
        this.setProcess(dto);
        String opinion = dto.getIntranetPort() + "<br/>" + this.baseContext.getCurrentUserName() + "<br/>" + DateUtils.now();
        this.cloudApplyManager.updateStatus(dto.getPrivateCloudApplyId(), CloudApplyStatusEnum.FAIL_AUDIT.getStatus(), opinion);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void applyComplete(CloudApplyApprovalRecordDTO dto) {
        this.setProcess(dto);
        this.cloudApplyManager.updateStatus(dto.getPrivateCloudApplyId(), CloudApplyStatusEnum.EXECUTE.getStatus(), null);
    }

    @Override
    public List<String> getApplyIdByApprovalUserId(String userId, String node) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizCloudApplyApprovalRecord::getApprovalUserId, (Object)userId);
        wrapper.eq(BizCloudApplyApprovalRecord::getApprovalResult, (Object)-1);
        wrapper.eq(BizCloudApplyApprovalRecord::getApprovalNode, (Object)node);
        wrapper.eq(BizDelModel::getIsDele, (Object)"0");
        List list = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<String>();
        }
        return list.stream().map(BizCloudApplyApprovalRecord::getPrivateCloudApplyId).collect(Collectors.toList());
    }

    @Override
    @Transactional(readOnly=true)
    public CommonResult<List<ApprovalRecordVO>> getRecord(String privateCloudApplyId) {
        Assert.hasText((String)privateCloudApplyId, (String)"\u4e91\u8d44\u6e90\u7533\u8bf7ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ArrayList vo = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizCloudApplyApprovalRecord::getPrivateCloudApplyId, (Object)privateCloudApplyId);
        queryWrapper.eq(BizDelModel::getIsDele, (Object)"0");
        queryWrapper.orderByAsc(BizCloudApplyApprovalRecord::getVersion);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(e -> {
                ApprovalRecordVO applyRecordVo = new ApprovalRecordVO();
                BeanUtils.copyProperties((Object)e, (Object)applyRecordVo);
                vo.add(applyRecordVo);
            });
            List<String> sourceIds = list.stream().map(BizCloudApplyApprovalRecord::getId).collect(Collectors.toList());
            List<Accessory> accessoryList = this.accessoryManager.getAccessoryBySourceIds(sourceIds);
            if (CollectionUtils.isNotEmpty(accessoryList)) {
                Map<String, List<Accessory>> collect = accessoryList.stream().collect(Collectors.groupingBy(Accessory::getSourceId));
                vo.forEach(e -> {
                    List accessories;
                    if (collect.containsKey(e.getId()) && (accessories = (List)collect.get(e.getId())) != null) {
                        e.setApplyRecordFile(accessories);
                    }
                });
            }
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", vo);
    }

    private Long setProcess(CloudApplyApprovalRecordDTO dto) {
        Long version = null;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BizCloudApplyApprovalRecord::getPrivateCloudApplyId, (Object)dto.getPrivateCloudApplyId());
        wrapper.eq(BizCloudApplyApprovalRecord::getApprovalResult, (Object)-1);
        wrapper.eq(BizDelModel::getIsDele, (Object)"0");
        List list = this.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (BizCloudApplyApprovalRecord e : list) {
                version = e.getVersion();
                e.setApprovalResult(dto.getApprovalResult());
                e.setIntranetPort(dto.getIntranetPort());
                e.setApplyRecordFile(dto.getApplyRecordFile());
                e.setApprovalDate(LocalDateTime.now());
                long processingTime = DateUtils.localDateTimeToLong((LocalDateTime)e.getApprovalDate()) - DateUtils.localDateTimeToLong((LocalDateTime)e.getCreateTime());
                e.setProcessingTime(processingTime);
                e.setNetworkPort(10);
                e.setPortPurpose(dto.getApprovalResult() == 0 ? 20 : (dto.getApprovalResult() == 1 ? 30 : 40));
                this.updateInfo(e);
            }
        }
        return version;
    }
}

