/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.rescue.base.dao.RescueFeeStandardDao;
import com.artfess.rescue.base.manager.RescueFeeStandardDetailsAdditionalManager;
import com.artfess.rescue.base.manager.RescueFeeStandardDetailsBenchmarkManager;
import com.artfess.rescue.base.manager.RescueFeeStandardManager;
import com.artfess.rescue.base.model.RescueFeeStandard;
import com.artfess.rescue.file.manager.BizRescueFileCommonManager;
import com.artfess.rescue.file.model.BizRescueFileCommon;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RescueFeeStandardManagerImpl
extends BaseManagerImpl<RescueFeeStandardDao, RescueFeeStandard>
implements RescueFeeStandardManager {
    @Resource
    private RescueFeeStandardDetailsAdditionalManager rescueFeeStandardDetailsAdditionalManager;
    @Resource
    private RescueFeeStandardDetailsBenchmarkManager rescueFeeStandardDetailsBenchmarkManager;
    @Resource
    private BizRescueFileCommonManager fileCommonManager;
    @Resource
    private SysIdentityManager sysIdentityManager;
    private static final String FILE_TYPE = "RescueFeeStandard";

    public RescueFeeStandard get(Serializable id) {
        return this.getById(id);
    }

    public RescueFeeStandard getById(Serializable id) {
        RescueFeeStandard rescueFeeStandard = (RescueFeeStandard)((Object)((RescueFeeStandardDao)this.getBaseMapper()).selectById(id));
        if (null != rescueFeeStandard) {
            rescueFeeStandard.setRescueFeeStandardDetailsBenchmarkList(this.rescueFeeStandardDetailsBenchmarkManager.queryListByRescueFeeStandardId(rescueFeeStandard.getId()));
            rescueFeeStandard.setRescueFeeStandardDetailsAdditionalList(this.rescueFeeStandardDetailsAdditionalManager.queryListByRescueFeeStandardId(rescueFeeStandard.getId()));
            rescueFeeStandard.setFileInfo(this.fileCommonManager.getFileByCommonId(rescueFeeStandard.getId()));
        }
        return rescueFeeStandard;
    }

    @Transactional
    public boolean save(RescueFeeStandard t) {
        HashMap<String, String> map;
        t.setSn(this.getNextSequence(null));
        t.setCode(this.sysIdentityManager.nextId("RescueFeeStandardNo"));
        t.setStatus(0);
        Integer result = ((RescueFeeStandardDao)this.getBaseMapper()).insert((Object)t);
        if (t.getRescueFeeStandardDetailsBenchmarkList() != null && t.getRescueFeeStandardDetailsBenchmarkList().size() > 0) {
            map = new HashMap<String, String>(1);
            map.put("RESCUE_FEE_STANDARD_ID_", t.getId());
            t.getRescueFeeStandardDetailsBenchmarkList().forEach(e -> {
                e.setRescueFeeStandardId(t.getId());
                e.setSn(this.rescueFeeStandardDetailsBenchmarkManager.getNextSequence(map));
            });
            this.rescueFeeStandardDetailsBenchmarkManager.removeByRescueFeeStandardId(t.getId());
            this.rescueFeeStandardDetailsBenchmarkManager.saveBatch(t.getRescueFeeStandardDetailsBenchmarkList());
        }
        if (t.getRescueFeeStandardDetailsAdditionalList() != null && t.getRescueFeeStandardDetailsAdditionalList().size() > 0) {
            map = new HashMap(1);
            map.put("RESCUE_FEE_STANDARD_ID_", t.getId());
            t.getRescueFeeStandardDetailsAdditionalList().forEach(e -> {
                e.setRescueFeeStandardId(t.getId());
                if (null == e.getUpperLimit()) {
                    e.setUpperLimit(t.getUpperLimit());
                }
                e.setSn(this.rescueFeeStandardDetailsAdditionalManager.getNextSequence(map));
            });
            this.rescueFeeStandardDetailsAdditionalManager.removeByRescueFeeStandardId(t.getId());
            this.rescueFeeStandardDetailsAdditionalManager.saveBatch(t.getRescueFeeStandardDetailsAdditionalList());
        }
        List<BizRescueFileCommon> fileCommons = t.getFileInfo();
        return null != result && result >= 1;
    }

    @Transactional
    public void create(RescueFeeStandard t) {
        this.save(t);
    }

    @Transactional
    public void update(RescueFeeStandard t) {
        this.updateById(t);
    }

    @Transactional
    public boolean updateById(RescueFeeStandard t) {
        HashMap<String, String> map;
        Integer result = ((RescueFeeStandardDao)this.getBaseMapper()).updateById((Object)t);
        if (t.getRescueFeeStandardDetailsBenchmarkList() != null && t.getRescueFeeStandardDetailsBenchmarkList().size() > 0) {
            map = new HashMap<String, String>(1);
            map.put("RESCUE_FEE_STANDARD_ID_", t.getId());
            t.getRescueFeeStandardDetailsBenchmarkList().forEach(e -> {
                e.setRescueFeeStandardId(t.getId());
                e.setSn(this.rescueFeeStandardDetailsBenchmarkManager.getNextSequence(map));
            });
            this.rescueFeeStandardDetailsBenchmarkManager.removeByRescueFeeStandardId(t.getId());
            this.rescueFeeStandardDetailsBenchmarkManager.saveBatch(t.getRescueFeeStandardDetailsBenchmarkList());
        }
        if (t.getRescueFeeStandardDetailsAdditionalList() != null && t.getRescueFeeStandardDetailsAdditionalList().size() > 0) {
            map = new HashMap(1);
            map.put("RESCUE_FEE_STANDARD_ID_", t.getId());
            t.getRescueFeeStandardDetailsAdditionalList().forEach(e -> {
                e.setRescueFeeStandardId(t.getId());
                if (null == e.getUpperLimit()) {
                    e.setUpperLimit(t.getUpperLimit());
                }
                e.setSn(this.rescueFeeStandardDetailsAdditionalManager.getNextSequence(map));
            });
            this.rescueFeeStandardDetailsAdditionalManager.removeByRescueFeeStandardId(t.getId());
            this.rescueFeeStandardDetailsAdditionalManager.saveBatch(t.getRescueFeeStandardDetailsAdditionalList());
        }
        List<BizRescueFileCommon> fileCommons = t.getFileInfo();
        return null != result && result >= 1;
    }

    @Transactional
    public void remove(Serializable id) {
        this.removeById(id);
    }

    @Transactional
    public boolean removeById(Serializable id) {
        Integer result = ((RescueFeeStandardDao)this.getBaseMapper()).deleteById(id);
        this.rescueFeeStandardDetailsBenchmarkManager.removeByRescueFeeStandardId(id.toString());
        this.rescueFeeStandardDetailsAdditionalManager.removeByRescueFeeStandardId(id.toString());
        return null != result && result >= 1;
    }

    @Transactional
    public void removeByIds(String ... ids) {
        List<String> idList = Arrays.asList(ids);
        this.removeByIds(idList);
    }

    @Override
    @Transactional
    public boolean removeByIds(List<String> idList) {
        Integer result = ((RescueFeeStandardDao)this.getBaseMapper()).deleteBatchIds(idList);
        this.rescueFeeStandardDetailsBenchmarkManager.removeByRescueFeeStandardIds(idList);
        this.rescueFeeStandardDetailsAdditionalManager.removeByRescueFeeStandardIds(idList);
        return null != result && result >= 1;
    }

    @Override
    @Transactional
    public void updateFlag(String ids, Integer status) {
        List<String> idsList = Arrays.asList(ids.split(","));
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.set((Object)"STATUS_", (Object)status)).in((Object)"ID_", idsList);
        this.update((Wrapper)updateWrapper);
    }
}

