/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.base.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.base.context.BaseContext;
import com.artfess.base.entity.BizDelModel;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.vo.TreeVo;
import com.artfess.rescue.base.dao.BizBasePatrolDao;
import com.artfess.rescue.base.manager.BizBasePatrolManager;
import com.artfess.rescue.base.model.BizBasePatrol;
import com.artfess.sysConfig.vo.DictionaryDetailVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BizBasePatrolManagerImpl
extends BaseManagerImpl<BizBasePatrolDao, BizBasePatrol>
implements BizBasePatrolManager {
    @Resource
    BaseContext baseContext;
    private static final CacheSetting cacheSetting = CacheSetting.buildDefault((String)"\u5b57\u5178\u7f13\u5b58");
    private static final Logger logger = LoggerFactory.getLogger(BizBasePatrolManagerImpl.class);

    @Override
    public List<TreeVo> tree(BizBasePatrol t) {
        Assert.notNull((Object)t.getRoadId(), (String)"\u9700\u8981\u67e5\u8be2\u7684\u8def\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList treeVos = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizDelModel::getIsDele, (Object)DelStatusEnum.N.getType());
        queryWrapper.eq(BeanUtils.isNotEmpty((Object)t.getInspectionCycle()), BizBasePatrol::getInspectionCycle, (Object)t.getInspectionCycle());
        queryWrapper.eq(BeanUtils.isNotEmpty((Object)t.getPointLevel()), BizBasePatrol::getPointLevel, (Object)t.getPointLevel());
        queryWrapper.in(BizBasePatrol::getRoadId, Arrays.asList(t.getRoadId().split(",")));
        List patrolList = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)patrolList)) {
            return BeanUtils.listToTree(treeVos);
        }
        CacheManager cacheManager = (CacheManager)AppUtil.getBean(CacheManager.class);
        ICache cache = cacheManager.getCache("", cacheSetting);
        String tenantId = this.baseContext.getCurrentTenantId();
        String jsonKey = "sys:dict:all:new:" + tenantId;
        Object cacheObject = cache.get((Object)jsonKey);
        if (cacheObject == null) {
            return Collections.emptyList();
        }
        JSONObject jsonValue = JSON.parseObject((String)cacheObject.toString());
        List<DictionaryDetailVo> xsfxDetails = this.convertToList(jsonValue, "xsfx");
        if (xsfxDetails == null) {
            return Collections.emptyList();
        }
        Map<String, Map<String, List<BizBasePatrol>>> patrolMap = patrolList.stream().collect(Collectors.groupingBy(BizBasePatrol::getType, Collectors.groupingBy(BizBasePatrol::getContent)));
        List<DictionaryDetailVo> xcdwlxDetails = this.convertToList(jsonValue, "xcdwlx").stream().filter(dict -> patrolMap.get(dict.getValue()) != null).collect(Collectors.toList());
        if (xcdwlxDetails == null || xcdwlxDetails.isEmpty()) {
            return Collections.emptyList();
        }
        xcdwlxDetails.forEach(detail -> {
            TreeVo treeVo = this.createTreeVo(detail.getId(), detail.getValue(), detail.getName(), "1", "0");
            treeVos.add(treeVo);
            Map lowerDic = detail.getLowerDic();
            if (lowerDic == null || lowerDic.get("xcdwnr") == null) {
                return;
            }
            List xcdwnrDetails = JSON.parseArray((String)lowerDic.get("xcdwnr").toString(), DictionaryDetailVo.class);
            Map typeMap = (Map)patrolMap.get(detail.getValue());
            List<DictionaryDetailVo> filteredContents = xcdwnrDetails.stream().filter(content -> typeMap.get(content.getValue()) != null).collect(Collectors.toList());
            filteredContents.forEach(childDetail -> {
                TreeVo childTree = this.createTreeVo(childDetail.getId(), childDetail.getValue(), childDetail.getName(), "2", detail.getId());
                treeVos.add(childTree);
                xsfxDetails.forEach(xsfxDetail -> {
                    TreeVo xsfxChildTree = this.createTreeVo(UniqueIdUtil.getSuid(), xsfxDetail.getValue(), xsfxDetail.getName(), "3", childDetail.getId());
                    xsfxChildTree.setParentCode(childDetail.getValue());
                    xsfxChildTree.setOrgKind(detail.getValue());
                    treeVos.add(xsfxChildTree);
                });
            });
        });
        if (StringUtil.isEmpty((String)t.getRoadId())) {
            return BeanUtils.listToTree(treeVos);
        }
        Map<String, List<BizBasePatrol>> directionMap = patrolList.stream().filter(item -> item.getDirection() != null).collect(Collectors.groupingBy(BizBasePatrol::getDirection));
        Map<String, List<TreeVo>> treeMap = treeVos.stream().collect(Collectors.groupingBy(TreeVo::getLevel));
        Optional.ofNullable(treeMap.get("3")).ifPresent(level3Nodes -> level3Nodes.forEach(treeVo -> Optional.ofNullable(directionMap.get(treeVo.getCode())).ifPresent(directions -> directions.forEach(patrol -> {
            if (this.isValidPatrol((BizBasePatrol)((Object)((Object)((Object)((Object)patrol)))), (TreeVo)treeVo)) {
                TreeVo patrolChildTree = this.createPatrolTreeVo((BizBasePatrol)((Object)((Object)((Object)((Object)patrol)))), (TreeVo)treeVo);
                treeVos.add(patrolChildTree);
            }
        }))));
        return BeanUtils.listToTree(treeVos);
    }

    private TreeVo createTreeVo(String id, String code, String name, String level, String parentId) {
        TreeVo treeVo = new TreeVo();
        treeVo.setId(id);
        treeVo.setCode(code);
        treeVo.setName(name);
        treeVo.setLevel(level);
        treeVo.setParentId(parentId);
        return treeVo;
    }

    private boolean isValidPatrol(BizBasePatrol patrol, TreeVo treeVo) {
        return StringUtil.isNotEmpty((String)patrol.getContent()) && patrol.getContent().equals(treeVo.getParentCode()) && patrol.getType().equals(treeVo.getOrgKind());
    }

    private TreeVo createPatrolTreeVo(BizBasePatrol patrol, TreeVo treeVo) {
        TreeVo patrolChildTree = new TreeVo();
        patrolChildTree.setId(patrol.getId());
        patrolChildTree.setCode(patrol.getId());
        patrolChildTree.setName(patrol.getName());
        patrolChildTree.setCategory(patrol.getCategory());
        patrolChildTree.setType(patrol.getType());
        patrolChildTree.setPointLevel(patrol.getPointLevel());
        patrolChildTree.setInspectionCycle(patrol.getInspectionCycle());
        patrolChildTree.setContent(patrol.getContent());
        patrolChildTree.setPeg(patrol.getPeg());
        patrolChildTree.setPegAdd(patrol.getPegAdd());
        patrolChildTree.setPegVal(patrol.getPegVal());
        patrolChildTree.setDirection(patrol.getDirection());
        patrolChildTree.setDirectionValue(patrol.getDirectionValue());
        patrolChildTree.setLng(patrol.getLng());
        patrolChildTree.setLat(patrol.getLat());
        patrolChildTree.setParentId(treeVo.getId());
        patrolChildTree.setLevel("4");
        patrolChildTree.setExpandInfo(JSON.toJSONString((Object)((Object)patrol)));
        return patrolChildTree;
    }

    public List<DictionaryDetailVo> convertToList(JSONObject jsonObject, String key) {
        JSONArray array = jsonObject.getJSONArray(key);
        return array.toJavaList(DictionaryDetailVo.class);
    }

    @Override
    public List<BizBasePatrol> pointDraw(double lng, double lat) {
        List list = this.list();
        return list.stream().filter(p -> p.getLat() != null && p.getLng() != null).filter(t -> BizBasePatrolManagerImpl.distance(lat, lng, t.getLat(), t.getLng()) <= 100.0).collect(Collectors.toList());
    }

    @Override
    public List<BizBasePatrol> listByRoadId(String taskId) {
        return ((BizBasePatrolDao)this.baseMapper).getPatrolByTaskId(taskId);
    }

    public static double distance(double longitude1, double latitude1, double longitude2, double latitude2) {
        double EQUATOR_RADIUS = 6378137.0;
        double lat1 = Math.toRadians(latitude1);
        double lat2 = Math.toRadians(latitude2);
        double lon1 = Math.toRadians(longitude1);
        double lon2 = Math.toRadians(longitude2);
        double a = lat1 - lat2;
        double b = lon1 - lon2;
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        return s *= 6378137.0;
    }

    @Transactional(readOnly=true)
    public PageList<BizBasePatrol> query(QueryFilter<BizBasePatrol> queryFilter) {
        BizBasePatrolDao mapper = (BizBasePatrolDao)super.getBaseMapper();
        PageBean pageBean = queryFilter.getPageBean();
        IPage result = mapper.selectPage(this.convert2IPage(pageBean), (Wrapper)this.convert2Wrapper(queryFilter, BizBasePatrol.class));
        return new PageList(result);
    }
}

