/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.job.persistence.manager.SchedulerService;
import com.artfess.rescue.patrol.dao.BizInspectionPlanDao;
import com.artfess.rescue.patrol.manager.BizInspectionPlanDetailsManager;
import com.artfess.rescue.patrol.manager.BizInspectionPlanManager;
import com.artfess.rescue.patrol.model.BizInspectionPlan;
import com.artfess.rescue.patrol.vo.PlanPatrolVO;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BizInspectionPlanManagerImpl
extends BaseManagerImpl<BizInspectionPlanDao, BizInspectionPlan>
implements BizInspectionPlanManager {
    @Autowired
    SchedulerService schedulerService;
    @Autowired
    Scheduler scheduler;
    @Resource
    BaseContext baseContext;
    @Resource
    SysIdentityManager sysIdentityManager;
    @Autowired
    private BizInspectionPlanDetailsManager planDetailsManager;

    public static String generateCronExpression(int days, int hours, int minutes, LocalDate startDate, LocalDate endDate) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM-dd");
        String start = startDate.format(formatter);
        String end = endDate.format(formatter);
        return minutes + "" + hours + " */" + days + " " + start + "-" + end + " *";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateInfo(BizInspectionPlan plan) throws SchedulerException {
        String jobName;
        if (StringUtil.isEmpty((String)plan.getId())) {
            plan.setId(UniqueIdUtil.getSuid());
            String planCode = this.sysIdentityManager.nextId("planCode");
            plan.setPlanNo(planCode);
        } else {
            jobName = plan.getPlanNo() + ":" + this.scheduler.getSchedulerName();
            TriggerKey key = new TriggerKey(jobName, this.baseContext.getCurrentTenantId());
            Trigger.TriggerState state = this.scheduler.getTriggerState(key);
            if (state == Trigger.TriggerState.NORMAL) {
                throw new BaseException("\u8fd0\u884c\u4e2d\u7684\u5de1\u68c0\u4efb\u52a1\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91\uff0c\u8bf7\u6682\u505c\u540e\u8fdb\u884c\u7f16\u8f91\uff01");
            }
        }
        if (this.checkSameCode(plan.getPlanNo(), plan.getId())) {
            throw new RequiredException("\u6dfb\u52a0\u5de1\u68c0\u4efb\u52a1\u5931\u8d25\uff0c\u8be5\u914d\u7f6e\u3010" + plan.getPlanNo() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        jobName = plan.getPlanNo() + ":" + this.scheduler.getSchedulerName();
        boolean jobExists = this.schedulerService.isJobExists(jobName);
        boolean isSuccess = true;
        if (!jobExists) {
            String className = plan.getPlanClass();
            HashMap parameter = Maps.newHashMap();
            parameter.put("planId", plan.getId());
            CommonResult result = this.schedulerService.addJob(jobName, className, (Map)parameter, null);
            isSuccess = result.getState();
        }
        if (isSuccess) {
            boolean b = this.saveOrUpdate((Object)plan);
            if (b) {
                this.processPlanDetails(plan);
            }
            return b;
        }
        return isSuccess;
    }

    private void processPlanDetails(BizInspectionPlan plan) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"PLAN_ID_", (Object)plan.getId());
        this.planDetailsManager.remove((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(plan.getPlanDetails())) {
            return;
        }
        plan.getPlanDetails().forEach(details -> details.setPlanId(plan.getId()));
        this.planDetailsManager.saveBatch(plan.getPlanDetails());
    }

    private boolean checkSameCode(String code, String id) {
        Assert.hasText((String)code, (String)"\u8ba1\u5212\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"PLAN_NO_", (Object)code);
        queryWrapper.ne(StringUtil.isNotEmpty((String)id), (Object)"ID_", (Object)id);
        int num = ((BizInspectionPlanDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num != 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(String id) throws SchedulerException {
        boolean isExist;
        if (null == this.scheduler) {
            return false;
        }
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5de1\u68c0\u4efb\u52a1");
        BizInspectionPlan plan = (BizInspectionPlan)((Object)((BizInspectionPlanDao)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)plan), (String)"\u5de1\u68c0\u4efb\u52a1\u4e0d\u5b58\u5728");
        boolean deleteStatus = this.removeById((Serializable)((Object)id));
        if (!deleteStatus) {
            return deleteStatus;
        }
        String jobName = plan.getPlanNo() + ":" + this.scheduler.getSchedulerName();
        boolean rtn = this.schedulerService.isTriggerExists(jobName);
        if (rtn) {
            this.schedulerService.delTrigger(jobName);
        }
        if (isExist = this.schedulerService.isJobExists(jobName)) {
            this.schedulerService.delJob(jobName);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"PLAN_ID_", (Object)plan.getId());
            this.planDetailsManager.remove((Wrapper)queryWrapper);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean toggleTriggerRun(String id) throws Exception {
        if (null == this.scheduler) {
            return false;
        }
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5de1\u68c0\u4efb\u52a1");
        BizInspectionPlan trainTaskConf = (BizInspectionPlan)((Object)((BizInspectionPlanDao)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)trainTaskConf), (String)"\u5de1\u68c0\u4efb\u52a1\u4e0d\u5b58\u5728");
        String jobName = trainTaskConf.getPlanNo() + ":" + this.scheduler.getSchedulerName();
        TriggerKey key = new TriggerKey(jobName, this.baseContext.getCurrentTenantId());
        Trigger.TriggerState state = this.scheduler.getTriggerState(key);
        boolean rtn = this.schedulerService.isTriggerExists(jobName);
        if (!rtn) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)trainTaskConf.getFrequency());
            jsonObject.put("timeInterval", (Object)trainTaskConf.getPlanInterval());
            this.schedulerService.addTrigger(jobName, jobName, JSON.toJSONString((Object)jsonObject));
        } else if (state == Trigger.TriggerState.PAUSED) {
            this.scheduler.resumeTrigger(key);
        } else if (state == Trigger.TriggerState.NORMAL) {
            this.scheduler.pauseTrigger(key);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean executeJob(List<String> ids) throws SchedulerException {
        if (null == this.scheduler) {
            return false;
        }
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5de1\u68c0\u4efb\u52a1");
        for (String id : ids) {
            BizInspectionPlan trainTaskConf = (BizInspectionPlan)((Object)((BizInspectionPlanDao)this.baseMapper).selectById((Serializable)((Object)id)));
            String jobName = trainTaskConf.getPlanNo() + ":" + this.scheduler.getSchedulerName();
            JobKey key = new JobKey(jobName, this.baseContext.getCurrentTenantId());
            this.scheduler.triggerJob(key);
            trainTaskConf.setPushStatus("1");
            this.updateById((Object)trainTaskConf);
        }
        return true;
    }

    @Override
    public BizInspectionPlan findById(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u5de1\u68c0\u4efb\u52a1");
        BizInspectionPlan plan = (BizInspectionPlan)((Object)((BizInspectionPlanDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (BeanUtils.isNotEmpty((Object)((Object)plan))) {
            try {
                String jobName = plan.getPlanNo() + ":" + this.scheduler.getSchedulerName();
                TriggerKey key = new TriggerKey(jobName, this.baseContext.getCurrentTenantId());
                Trigger.TriggerState state = this.scheduler.getTriggerState(key);
                plan.setTaskStatus(state.name());
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
            List<PlanPatrolVO> planDetails = this.planDetailsManager.findByPlanId(plan.getId());
            plan.setPlanPatrolDetails(planDetails);
        }
        return plan;
    }

    @Override
    public PageList<BizInspectionPlan> findByPage(QueryFilter<BizInspectionPlan> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Class currentModelClass = this.currentModelClass();
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        IPage<BizInspectionPlan> result = ((BizInspectionPlanDao)this.baseMapper).queryByPage((IPage<BizInspectionPlan>)this.convert2IPage(pageBean), (QueryWrapper<BizInspectionPlan>)this.convert2Wrapper(queryFilter, currentModelClass));
        result.getRecords().forEach(taskConf -> {
            try {
                String jobName = taskConf.getPlanNo() + ":" + this.scheduler.getSchedulerName();
                TriggerKey key = new TriggerKey(jobName, this.baseContext.getCurrentTenantId());
                Trigger.TriggerState state = this.scheduler.getTriggerState(key);
                taskConf.setTaskStatus(state.name());
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
        });
        return new PageList(result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean push(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u67e5\u770b\u7684\u4efb\u52a1ID");
        BizInspectionPlan trainTaskConf = this.findById(id);
        Assert.notNull((Object)((Object)trainTaskConf), (String)"\u57f9\u8bad\u4fe1\u606f\u4e0d\u5b58\u5728");
        trainTaskConf.setPushStatus("1");
        this.updateById((Object)trainTaskConf);
        return true;
    }
}

