import {dictionaryEscape} from '@/utils/dictionary'
import moment from 'moment'

const startOfMonth = moment().startOf('month').format('YYYY-MM-DD')
const endOfMonth = moment().endOf('month').format('YYYY-MM-DD')

// 巡查
export function classifyDataInJs() {
  const classifyData = [
    {name: '巡查路段汇总统计', type: 'InspectionDept', hasPagination: false, customPagination: false},
    {name: '巡查人员汇总统计', type: 'InspectionUser', hasPagination: true, customPagination: true},
    {name: '巡查内容汇总统计', type: 'InspectionContent', hasPagination: false, customPagination: false},
    {name: '巡查任务完成情况统计', type: 'InspectionTaskCompletion', hasPagination: true, customPagination: true}
    // { name: '巡查人员内容统计', type: 'InspectionUserContent', hasPagination: true, customPagination: true },
    // { name: '每日巡查考核统计', type: '5' },
    // { name: '专项巡查次数统计报表', type: '6' },
    // { name: '巡查单考核统计', type: '7' },
    // { name: '巡查点汇总统计', type: '8' },
    // { name: '专项巡查次数统计报表', type: '9' },
    // { name: '巡查点异常明细报表', type: '10' },
  ]
  return classifyData
}

// 查询参数
export function paramsListInJs(key) {
  const defaultParams = {
    pageBean: {pageSize: -1, page: 1, total: 0},
    querys: [
      {operation: 'BETWEEN', property: 't.task_date_', value: [startOfMonth, endOfMonth]},
      {operation: 'IN', property: 't.road_id_'}
      // {operation: 'EQUAL', property: 't.plan_type_'}
    ]
  }
  const paramsObj = {
    InspectionDept: defaultParams,
    InspectionUser: {pageBeanShow: {pageSize: 20, page: 1, total: 0}, ...defaultParams},
    InspectionContent: defaultParams,
    InspectionTaskCompletion: {pageBeanShow: {pageSize: 20, page: 1, total: 0}, ...defaultParams},
    InspectionUserContent: defaultParams

  }
  return paramsObj[key] || {}
}

// 搜索条件
export function optionListInJs(key) {
  const defaultOption = [
    // { title: '路段名称', prop: 't.road_name_', type: 'input', default: true },
    {
      title: '所属路段',
      prop: 't.road_id_',
      type: 'select',
      option: [],
      default: true
    }
    // {
    //   title: '巡检类型',
    //   prop: 't.plan_type_',
    //   type: 'select',
    //   option: getDictionaryByCode('xjlx-xjrw'),
    //   multiple: false
    // }
  ]

  const optionsObj = {
    InspectionDept: defaultOption,
    InspectionUser: defaultOption,
    InspectionContent: defaultOption,
    InspectionTaskCompletion: [{
      title: '所属路段',
      prop: 't.road_id_',
      type: 'select',
      option: [],
      default: true
    }],
    InspectionUserContent: defaultOption
  }
  return optionsObj[key] || []
}

// 表格列 
// prop：字段名，label：显示名称，minWidth：最小宽度，formatter：自定义格式化, children：子列
// formatter 示例：({ value }) => value ? value.toFixed(2) : '-'

export function tableColumnInJs(type) {
  const tableColumnData = {
    InspectionDept: [
      {label: '路段名称', minWidth: '100', prop: 'roadName'},
      {label: '巡检队伍', minWidth: '140', prop: 'teamName'},
      {label: '巡检里程\n（km）', minWidth: '100', prop: 'taskMileage'},
      {label: '巡检时间\n（时）', minWidth: '100', prop: 'taskTime'},
      {label: '巡检次数\n（次）', minWidth: '100', prop: 'taskNum'},
      {label: '异常点数\n（个）', minWidth: '100', prop: 'outlierPoint'},
      {
        label: '异常点上报（个）', minWidth: '240', prop: '',
        children: [
          {label: '上报总数', minWidth: '80', prop: 'handleAll'},
          {label: '上报中心数', minWidth: '80', prop: 'handleCenter'},
          {label: '现场处置数', minWidth: '80', prop: 'handleScene'}
        ]
      }
    ],
    InspectionUser: [
      {label: '巡检人员', minWidth: '120', prop: 'userName'},
      {label: '路段名称', minWidth: '100', prop: 'roadName'},
      {label: '巡检队伍', minWidth: '140', prop: 'teamName'},
      {label: '巡检里程\n（km）', minWidth: '100', prop: 'taskMileage'},
      {label: '巡检时间\n（时）', minWidth: '100', prop: 'taskTime'},
      {label: '巡检次数\n（次）', minWidth: '100', prop: 'taskNum'},
      {label: '异常点数\n（个）', minWidth: '100', prop: 'outlierPoint'},
      {
        label: '异常点上报（个）', minWidth: '240', prop: 'handle',
        children: [
          {label: '上报总数', minWidth: '80', prop: 'handleAll'},
          {label: '上报中心数', minWidth: '80', prop: 'handleCenter'},
          {label: '现场处置数', minWidth: '80', prop: 'handleScene'}
        ]
      }
    ],
    InspectionContent: [
      {label: '点位类型', minWidth: '100', prop: 'type', formatter: ({type}) => dictionaryEscape('xcdwlx', type)},
      {label: '巡查次数', minWidth: '100', prop: 'taskNum'},
      {label: '异常点数（个）', minWidth: '100', prop: 'outlierPoint'},
      {label: '异常点上报总数（个）', minWidth: '160', prop: 'handleAll'},
      {label: '现场处置总数（个）', minWidth: '160', prop: 'disposalAll'}
    ],
    InspectionTaskCompletion: [
      {label: '路段名称', minWidth: '100', prop: 'roadName'},
      {label: '任务总数量', minWidth: '100', prop: 'taskNum'},
      {label: '任务完成数量', minWidth: '100', prop: 'taskFinishNum'},
      {
        label: '任务完成率',
        minWidth: '100',
        prop: 'taskFinishRate',
        formatter: ({taskFinishRate}) => taskFinishRate || taskFinishRate === 0 ? taskFinishRate + ' %' : '-'
      },
      {label: '计划打卡点数量', minWidth: '100', prop: 'pointNum'},
      {label: '完成打卡点数量', minWidth: '100', prop: 'pointFinishNum'},
      {
        label: '打卡点完成率',
        minWidth: '100',
        prop: 'pointFinishRate',
        formatter: ({pointFinishRate}) => pointFinishRate || pointFinishRate === 0 ? pointFinishRate + ' %' : '-'
      }
    ],
    'InspectionUserContent': [
      {label: '巡检人员', minWidth: '100', prop: 'userName'},
      {label: '巡检路段', minWidth: '100', prop: 'roadName'},
      {label: '点位类型', minWidth: '100', prop: 'type'},
      {label: '具体内容', minWidth: '100', prop: 'typeContent'},
      {label: '点位类型目录', minWidth: '100', prop: 'category'},
      {label: '异常点数\n（个）', minWidth: '100', prop: 'outlierPoint'},
      {label: '异常点上报总数\n（个）', minWidth: '130', prop: 'handleAll'}
    ],
    '5': [
      {label: '部门名称', minWidth: '80', prop: 'code'},
      {label: '日期', minWidth: '80', prop: 'name'},
      {label: '白班巡查点数', minWidth: '80', prop: 'routeName'},
      {label: '夜班巡查点数', minWidth: '80', prop: 'companyName'}
    ],
    '6': [
      {label: '部门名称', minWidth: '80', prop: 'code'},
      {label: '日期', minWidth: '80', prop: 'name'},
      {label: '当日巡查次数', minWidth: '80', prop: 'routeName'},
      {label: '当日巡查里程(Km)', minWidth: '80', prop: 'companyName'},
      {label: '管辖路段里程(Km)', minWidth: '80', prop: 'companyName'},
      {label: '发现异常点数', minWidth: '80', prop: 'companyName'},
      {label: '养护巡查覆盖率(%) ', minWidth: '80', prop: 'companyName'}
    ],
    '7': [
      {label: '部门名称', minWidth: '80', prop: 'code'},
      {label: '日期', minWidth: '80', prop: 'name'},
      {label: '工单号', minWidth: '80', prop: 'routeName'},
      {label: '班次', minWidth: '80', prop: 'companyName'},
      {label: '开始巡查日期', minWidth: '100', prop: 'companyName'},
      {label: '开始里程', minWidth: '80', prop: 'companyName'},
      {label: '结束巡查日期', minWidth: '100', prop: 'companyName'},
      {label: '结束里程', minWidth: '80', prop: 'companyName'},
      {label: '巡查设定固定点数', minWidth: '120', prop: 'companyName'},
      {label: '已巡查固定点数量', minWidth: '120', prop: 'companyName'},
      {label: '已巡查临时点数量', minWidth: '120', prop: 'companyName'},
      {label: '异常点位', minWidth: '80', prop: 'companyName'}
    ],
    '8': [
      {label: '路段', minWidth: '80', prop: 'code'},
      {label: '方向', minWidth: '80', prop: 'name'},
      {label: '名称', minWidth: '80', prop: 'routeName'},
      {label: '桩号', minWidth: '80', prop: 'companyName'},
      {label: '类型', minWidth: '80', prop: 'companyName'},
      {label: '内容', minWidth: '80', prop: 'companyName'},
      {label: '类别', minWidth: '80', prop: 'companyName'},
      {label: '巡查次数', minWidth: '80', prop: 'companyName'},
      {label: '正常次数', minWidth: '80', prop: 'companyName'},
      {
        label: '异常次数', minWidth: '80', prop: 'terminalPoint',
        children: [
          {label: '合计', minWidth: '80', prop: 'terminalPoint'},
          {label: '已处理', minWidth: '80', prop: 'terminalPoint'},
          {label: '已上报', minWidth: '80', prop: 'terminalPoint'}
        ]
      }
    ],
    '9': [
      {label: '部门名称', minWidth: '80', prop: 'code'},
      {label: '次数', minWidth: '80', prop: 'name'}
    ],
    '10': [
      {label: '路段编号', minWidth: '80', prop: 'code'},
      {label: '路段名称', minWidth: '80', prop: 'name'},
      {label: '桩号', minWidth: '80', prop: 'routeName'},
      {label: '巡查时间', minWidth: '80', prop: 'companyName'},
      {label: '所属公司', minWidth: '80', prop: 'companyName'},
      {label: '巡查点内容', minWidth: '80', prop: 'companyName'},
      {label: '巡查点名称', minWidth: '80', prop: 'companyName'}
    ]
  }
  return tableColumnData[type]
}



