import moment from 'moment'

const startOfMonth = moment().startOf('month').format('YYYY-MM-DD')
const endOfMonth = moment().endOf('month').format('YYYY-MM-DD')

export function classifyDataInJs() {
  const classifyData = [
    {name: '路网运行信息统计日报', type: 'theRoadNetworkIsOperatingDay', hasPagination: true, customPagination: true},
    {name: '路网运行信息统计月报', type: 'theRoadNetworkIsOperatingMonth', hasPagination: true, customPagination: true}
  ]
  return classifyData
}

// // 查询参数
export function paramsListInJs(key) {
  const defaultParams = {
    pageBean: {pageSize: -1, page: 1, total: 0},
    querys: [
      {operation: 'BETWEEN', property: 'rescueTime', value: [startOfMonth, endOfMonth]},
      {operation: 'IN', property: 'road_id_'}
    ]
  }
  const paramsObj = {
    theRoadNetworkIsOperatingDay: {pageBeanShow: {pageSize: 20, page: 1, total: 0}, ...defaultParams},
    theRoadNetworkIsOperatingMonth: {pageBeanShow: {pageSize: 20, page: 1, total: 0}, ...defaultParams}
  }
  return paramsObj[key] || {}
}

// 搜索条件
export function optionListInJs(key) {
  const defaultOption = [
    {
      title: '所属路段',
      prop: 'road_id_',
      type: 'select',
      option: [],
      default: true
    }
  ]
  const optionsObj = {
    theRoadNetworkIsOperatingDay: defaultOption,
    theRoadNetworkIsOperatingMonth: defaultOption
  }
  return optionsObj[key] || []
}

export function tableColumnInJs(type) {
  const tableColumnData = {
    theRoadNetworkIsOperatingDay: [
      {label: '公司', minWidth: '80', prop: 'roadName'},
      {label: '国高网', minWidth: '80', prop: 'reachSum'},
      {label: '路段', minWidth: '100', prop: 'trailersMileage'},
      {label: '开始时间', xminWidth: '100', prop: 'averageResponseTime'},
      {label: '结束时间', xminWidth: '100', prop: 'averageResponseTime'},
      {label: '时间小计(分钟)', xminWidth: '140', prop: 'averageResponseTime'},
      {label: '起止桩号、站名、方向', xminWidth: '160', prop: 'averageResponseTime'},
      {
        label: '突发性事件', minWidth: '240', prop: '',
        children: [
          {
            label: '灾害天气', minWidth: '80', prop: '',
            children: [
              {label: '雾', minWidth: '80', prop: 'handleCenter'},
              {label: '雨', minWidth: '80', prop: 'handleCenter'},
              {label: '雪', minWidth: '80', prop: 'handleCenter'},
              {label: '路面结冰', minWidth: '100', prop: 'handleCenter'}
            ]
          },
          {
            label: '交通事故', minWidth: '80', prop: '',
            children: [
              {label: '隧道内(次)', minWidth: '110', prop: 'handleCenter'},
              {label: '处置时间(分钟)', minWidth: '80', prop: 'handleCenter'},
              {label: '隧道外(次)', minWidth: '80', prop: 'handleCenter'},
              {label: '处置时间(分钟)', minWidth: '100', prop: 'handleCenter'},
              {label: '特殊结构物', minWidth: '100', prop: 'handleCenter'}
            ]
          }
        ]
      }
    ],
    theRoadNetworkIsOperatingMonth: [
      {label: '人员姓名', minWidth: '100', prop: 'userName'},
      {label: '路段名称', minWidth: '100', prop: 'roadName'},
      {label: '拖车数量\n（辆）', minWidth: '80', prop: 'trailersNum'},
      {label: '拖车里程\n（km）', minWidth: '100', prop: 'trailersMileage'},
      {label: '拖车总金额\n（元）', minWidth: '140', prop: 'trailersAmount'},
      {label: '平均出勤时间\n（分）', minWidth: '140', prop: 'averageAttendanceTime'},
      {label: '平均处置时间\n（分）', minWidth: '140', prop: 'averageHandlingTime'},
      {label: '平均到达时间\n（分）', minWidth: '140', prop: 'averageReachTime'},
      {label: '平均响应时间\n（分）', minWidth: '140', prop: 'averageResponseTime'}
    ]
  }
  return tableColumnData[type]
}
