import moment from 'moment'

const startOfMonth = moment().startOf('month').format('YYYY-MM-DD HH:mm:ss')
const endOfMonth = moment().endOf('month').format('YYYY-MM-DD HH:mm:ss')

export function classifyDataInJs() {
  const classifyData = [
    {name: '路段事件统计分类表', type: 'EventDept', hasPagination: false, customPagination: false}
    // { name: '事件处置时间统计表', type: 'EventHandleTime', hasPagination: false, customPagination: false }
  ]
  return classifyData
}

// 查询参数
export function paramsListInJs(key) {
  const defaultParams = {
    pageBean: {pageSize: -1, page: 1, total: 0},
    querys: [
      {operation: 'BETWEEN', property: 'eventTime', value: [startOfMonth, endOfMonth]},
      {operation: 'IN', property: 'road_id_'}
    ]
  }
  const paramsObj = {
    EventDept: defaultParams,
    EventHandleTime: defaultParams
  }
  return paramsObj[key] || {}
}

// 搜索条件
export function optionListInJs(key) {
  const defaultOption = [
    {
      title: '所属路段',
      prop: 'road_id_',
      type: 'select',
      option: [],
      default: true
    }
  ]
  const optionsObj = {
    EventDept: defaultOption,
    EventHandleTime: defaultOption
  }
  return optionsObj[key] || []
}

// 表格列 
// prop：字段名，label：显示名称，minWidth：最小宽度，formatter：自定义格式化, children：子列
// formatter 示例：({ value }) => value ? value.toFixed(2) : '-'

export function tableColumnInJs(type) {
  const tableColumnData = {
    EventDept: [
      {label: '路段名称', minWidth: '120', prop: 'roadName'},
      {label: '路产损失\n（元）', minWidth: '40', prop: 'roadAssetLoss'},
      {label: '事故灾难\n（件） ', minWidth: '40', prop: 'accidentDisaster'},
      {label: '养护施工\n（件）', minWidth: '40', prop: 'constructEvent'},
      {label: '地质灾害\n（件）', minWidth: '40', prop: 'geologicalDisaster'},
      {label: '气象灾害\n（件）', minWidth: '40', prop: 'meteorologicalDisaster'},
      {label: '社会安全事件\n（件）', minWidth: '40', prop: 'socialSecurityEvent'},
      {label: '其他事件\n（件）', minWidth: '40', prop: 'otherEvent'}
    ],
    EventHandleTime: [
      {label: '路段名称', minWidth: '120', prop: 'roadName'},
      {label: '事件平均处置\n时间（分）', minWidth: '120', prop: 'roadName'},
      {
        label: '各类型事件平均处置时间（分）', minWidth: '240', prop: 'handle',
        children: [
          {label: '事故灾难', minWidth: '80', prop: 'handleAll'},
          {label: '火灾事故', minWidth: '80', prop: 'handleScene'},
          {label: '地质灾害', minWidth: '80', prop: 'handleScene'},
          {label: '气象灾害', minWidth: '80', prop: 'handleScene'},
          {label: '社会安全事件', minWidth: '80', prop: 'handleScene'}
        ]
      }
    ]
  }
  return tableColumnData[type]
}



