/*
* ✨文件工具类函数✨
* */

import axios from 'axios'

// 获取本都File文件
export async function getLocalFile(url) {
  try {
    const {data: blob} = await axios({
      url,
      responseType: 'blob'
    })
    return new File([blob], '文件名', {
      type: 'application/json',
      lastModified: Date.now()
    })
  } catch (e) {
    return ''
  }
}

// 获取本都FBlob文件
export async function getLocalBLob(url) {
  try {
    const {data: blob} = await axios({
      url,
      responseType: 'blob'
    })
    return blob
  } catch (e) {
    return ''
  }
}

// 打开或下载文件
