import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/patrol/bizInspectionVideoTask/v1/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 表格详情
export function taskDetail(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/patrol/bizInspectionVideoTask/v1/${id}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格修改
export function taskUpdate(data) {
    return new Promise((resolve, reject) => {
        req.put(portal + `/patrol/bizInspectionVideoTask/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格详情
export function previewURLs(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizVideoMonitorPointInfo/v1/previewURLs`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格删除
export function taskDelete(ids) {
    return new Promise((resolve, reject) => {
        req.remove(portal + `/patrol/bizInspectionVideoTask/v1/?ids=${ids}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 保存巡检结果
export function saveResultBatch(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/patrol/bizInspectionVideo/v1/saveBatch`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 异常上报
export function uploadErrVideo(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/patrol/bizInspectionVideo/v1/inspect/error`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 异常查询
export function getVideoErrData(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/patrol/bizInspectionVideo/v1/` + id)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}
