import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionPlan/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/patrol/bizInspectionPlan/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增/修改
export function tableAddEdit(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionPlan/v1/saveOrUpdate`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/patrol/bizInspectionPlan/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 启用或停止巡检计划
export function toggleTriggerRun(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionPlan/v1/toggleTriggerRun?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 执行巡检计划
export function executeJob(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionPlan/v1/executeJob?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取组织架构
export function getTree() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/uc/org/roadTree`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}