import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueInfo/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 事件新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueInfo/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 事件修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/event/bizRescueInfo/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 委派
export function appoint(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueInfo/v1/appoint`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 撤回
export function revocation(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueInfo/v1/cancel?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 事件删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/event/bizRescueInfo/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/event/bizRescueInfo/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

export function exportDataFile(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueInfo/v1/ledger/export`, data, 'blob')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 预览
export function filePreview(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueInfo/v1/ledger`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

export function exportDataFileUser(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueInfo/v1/ledger/excelExport`, data, 'blob')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}