import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBaseTeamMember/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizBaseTeamMember/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizBaseTeamMember/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/bizBaseTeamMember/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/bizBaseTeamMember/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取组织架构
export function getTree() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/uc/org/roadTree`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}
