import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableDataa(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/rescueFeeStandard/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/rescueFeeStandard/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/rescueFeeStandard/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// // 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/rescueFeeStandard/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// // 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/rescueFeeStandard/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 启用禁用改变
// export function statuschange(data) {
//   console.log(data, 'sssss')
//   return new Promise((resolve, reject) => {
//     req.post(portal + `/rescueFeeStandard/v1/updateFlag`, data)
//       .then(res => resolve(res?.data || []))
//       .catch(err => reject(err))
//   })
// }

export function statuschange(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/rescueFeeStandard/v1/updateFlag`, data, {
      headers: {
        'Content-Type': 'multipart/form-data' // 设置请求头
      }
    })
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// // 获得单位树
// export function orgTree() {
//   return new Promise((resolve, reject) => {
//     req.get(portal + `/uc/org/orgTree`)
//       .then(res => resolve(res.data || []))
//       .catch(err => reject(err))
//   })
// }
