import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventInfo/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 事件新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventInfo/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 事件修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/event/bizEventInfo/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 委派
export function eventAppoint(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventInfo/v1/appoint`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 撤回
export function eventRevocation(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventInfo/v1/cancel?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 事件删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/event/bizEventInfo/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/event/bizEventInfo/v1/full/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格详情
export function personAndCarInfo(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizBaseTeam/v1/getTeamData?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 事件完结
export function eventCompleted(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventHandle/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

export function getTree() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/uc/org/roadTree`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 管制解除
export function deregulation(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/event/bizTrafficControl/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 新增事件环节
export function addEventStep(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventHandle/v1/pc`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 批量完结事件
export function tableFinish(ids) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventHandle/v1/finish?` + ids)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

export function exportDataFile(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventInfo/v1/ledger/export`, data, 'blob')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 预览
export function filePreview(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventInfo/v1/ledger`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

export function exportDataFileUser(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventInfo/v1/ledger/excelExport`, data, 'blob')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取事件报告
export function getEventReport(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizEventReport/v1/by-event/${id}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 保存事件报告
export function saveEventReport(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/bizEventReport/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 更新事件报告
export function updateEventReport(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizEventReport/v1/update/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 审核事件报告
export function auditEventReport(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizEventReport/v1/audit`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 批量导出数据
export function exportDataFileBatch(ids) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizEventReport/v1/export?${ids}`, {}, 'blob')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}