import req from '@/request'

const portal = window.context.portal

// 获取快捷菜单数据
export function messageReceiver(data = {}) {
  return req.post(portal + `/msg/messageReceiver/v1/list`, data)
}

// 删除消息
export function removeMessage(ids) {
  return req.remove(portal + `/msg/messageReceiver/v1/remove?ids=${ids}`)
}

// 标记已读
export function markMessage(ids) {
  return req.get(portal + `/msg/messageReceiver/v1/mark?ids=${ids}`)
}

// 更改排序
export function detailData(id) {
  return req.get(portal + `/msg/messageReceiver/v1/get?id=${id}`)
}

// 附件预览
export function attachment(companyId) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizRescueFileCommon/v1/viewQrCode/${companyId}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

//附件上传
export function unloads(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizRescueFileCommon/v1/qrCodeSaveOrUpdate`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}


