/**
 * 弹窗
 * @apiName dd.alert
 *
 * @param message string 是  弹窗内容
 * @param title  string 否  弹窗标题
 * @param button  string 否  弹窗按钮
 *
 * @support
 *  - IOS v1.3.2
 *  - Android v1.3.2
 *
 * @example
 * ```typescript
 *   alert({
 *      message: 'hello, world!'
 *   }).then(res => {
 *      console.log(res)
 *   }).catch(err => {
 *      console.error(err)
 *   })
 * ```
 */
export interface AlertParams {
    message?: string;
    title?: string;
    button?: string;
}
declare function alert(params: AlertParams): Promise<void>;
declare namespace alert {
    var version: {
        android: string;
        ios: string;
    };
}
export default alert;
