/**
 * 公共混入方法 
 * 处理组件公共请求参数的截取等
 * */
import moment from 'moment'
export const QueryMixin = {
    data() {
        return {
            loading: false,
            query: {
                "roadIds": [],
                "startTime": "",  //"2024-01-01 00:00:00",
                "endTime": "" //"2026-01-01 00:00:00",
            },
        }
    },
    computed: {
        getAppDate() {
            console.log(this.$store.state.appDate)
            return (
                moment(this.$store.state.appDate).format("YYYY-MM-01")
            );
        },
        selectRoad() {
            return this.$store.state.roadART;
        },
    },
    watch: {
        getAppDate(newVal) {
            this.query.month = newVal;
            this.getData();
        },
        selectRoad(newVal) {
            this.query.roadIds = this.$store.state.roadART;
            this.getData();
        },
    },
    mounted() {
        this.getData();
    },
    methods: {
        filterDictTextByKey(dictData, key) {
            if (!key || dictData.length == 0) {
                return;
            }
            let item = dictData.filter(t => t["value"] == key)
            if (item && item.length > 0) {
                return item[0].name
            } else {
                return ''
            }
        }
    }
}