export const colorConfig = {
  success: '#67c23a',
  error: '#c23a3a'
}
export const getColor = (status: boolean) => {
  const color = status ? colorConfig.success : colorConfig.error
  return color
}
// 视频
export const video_tableColums =[
  {
    name: '组织区域',
    code: 'orgName',
    class: 'text-blue-200',
  },
  {
    name: '正常数量',
    code: 'normalCount',
  },
  {
    name: '总数量',
    code: 'totalCount',
  },
  {
    name: '正常率',
    code: 'normalPercent',
    render: (row:any) => {
      return row.normalPercent + '%'
    }
  },
]
interface Toll {
  flowUploadCount: number,
  stationLoadCount: number,
  gantryUploadCount: number
}
// // 收费
const handleData = (val:number) => {
  const status = val > 0 ? true : false
  const text = status ? `正常(${val})` : '异常'
  return <span style={`color:${getColor(status)}`}>{text}</span>
}
export const toll_tableColums = [
  {
    name: '组织区域',
    code: 'orgName',
    class: 'text-blue-200',
  },
  {
    name: '门架传输状态',
    code: 'gantryUploadCount',
    render: (row: Toll) => {
      return handleData(row.gantryUploadCount)
    }
  },
  {
    name: '收费站数据',
    code: 'stationLoadCount',
    render: (row: Toll) => {
      return handleData(row.stationLoadCount)
    }
  },
  {
    name: '实时车流数据',
    code: 'flowUploadCount',
    render: (row: Toll) => {
      return handleData(row.flowUploadCount)
    }
  },
]
interface Elec {
  finePercent: number,
  connectCount: number
}
// 机电
export const elec_tableColums = [
  {
    name: '组织区域',
    code: 'orgName',
    class: 'text-blue-200',
  },
  {
    name: '状态',
    code: 'connectCount',
    render: (row:Elec) => {
      const status = row.connectCount > 0 ? true : false
      const text = status ? '正常' : '异常'
      return <span style={`color:${getColor(status)}`}>{text}</span>
    }
  },
  {
    name: '完好率',
    code: 'finePercent',
    render: (row:Elec) => {
      return row.finePercent + '%'
    }
  },
  {
    name: '故障率',
    render: (row:Elec) => {
      const num = 100 - row.finePercent
      return ((num % 1 === 0) ? num : num.toFixed(2)) + '%'
    }
  },
]