
import axios from '@/utils/axiosCrossDomain';

const baseUrl = '/bizapi2/http-server-base/publish/cockpit/quota-v1';

// cpu用量
export function getCloudCpuUsage() {
  return axios.get(
      `${baseUrl}/cloudCpuUsage`
  );
}
// 内存
export function getCloudMemoryUsage() {
  return axios.get(
      `${baseUrl}/cloudMemoryUsage`
  );
}
// 获取存储使用率
export function getCloudStorageUsage() {
  return axios.get(
      `${baseUrl}/cloudStorageUsage`
  );
}
// 获取物理机数据
export function getCloudphostCount() {
  return axios.get(
      `${baseUrl}/cloudphostCount`
  );
}
// 获取云主机数据
export function getCloudVhostCount() {
  return axios.get(
      `${baseUrl}/cloudVhostCount`
  );
}
// cpu负载
export function getCpuLoad(minute) {
  return axios.get(
      `${baseUrl}/cloudPhostCpuLoad?offMinute=${minute}`
  );
}
// 内存负载
export function getMemoryLoad(minute) {
  return axios.get(
      `${baseUrl}/cloudPhostMemoryLoad?offMinute=${minute}`
  );
}
// 网络接受量
export function getNetworkIn(minute) {
  return axios.get(
      `${baseUrl}/cloudPhostNetworkIn?offMinute=${minute}`
  );
}
// 网络发送量
export function getNetworkOut(minute) {
  return axios.get(
      `${baseUrl}/cloudPhostNetworkOut?offMinute=${minute}`
  );
}
// 磁盘写入量
export function getDiskWrite(minute) {
  return axios.get(
      `${baseUrl}/cloudPhostDiskWrite?offMinute=${minute}`
  );
}
// 磁盘读取量
export function getDiskRead(minute) {
  return axios.get(
      `${baseUrl}/cloudPhostDiskRead?offMinute=${minute}`
  );
}

// 视频数据监测
export function getVideoStatusCount(params) {
  return axios.get(
      `${baseUrl}/videoIdStatusCount`,
      {params}
  );
}
// 收费数据监测
export function getTollDataMonitor(params) {
  return axios.get(
      `${baseUrl}/tollDataMonitor`,
      {params}
  );
}
// 机电数据监测
export function getElecDataMonitor(params) {
  return axios.get(
      `${baseUrl}/elecDataMonitor`,
      {params}
  );
}
// 数据连通性监测
export function getDataApiMonitor() {
  return axios.get(
      `${baseUrl}/dataApiMonitor`
  );
}