//  token 未设置
// import axios from '@/utils/axios';
import axios from "@/utils/axiosCrossDomain";

const baseUrl = "/http-server-base/publish/quota-v1";
const baseUrljw = "/http-server-base/publish/base-v1";
const api = `/bizapi1${baseUrl}`;
const apijw = `/bizapi1${baseUrljw}`;

// 需要暂时屏蔽掉未开通的省份
// 安徽、湖南、新疆、河北、江西
const ignoreOrgCodes = ["AH", "HN", "XJ", "HB", "JX"];

export function staffCount(params) {
    return axios.get(`${api}/staffCountNew`, {
        params,
    });
}
/**
 * 养护管理 公司人员子统计
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function staffCountChildNew(params) {
    return axios.get(`${api}/staffCountChildNew`, {
        params,
    });
}
export function staffStatisticsMaintain(params) {
    return axios.get(`${api}/staffStatisticsMaintain`, {
        params,
    })
        .then((res) => {
            res.msgContent = res.msgContent.filter(
                (item) => !ignoreOrgCodes.includes(item.orgCode)
            );
            return res;
        });
}
/**
 * 涵洞数量
 * @param {string|Number} level 组织级别 0-集团,1-公司,2-路段
 * @param {string|Number} type 是否加类别统计 0-否,1-是
 */
export function getCulvertCount(level, type, dimension) {
    return axios.get(
        `${api}/culvertCount?level=${level}&type=${type}&dimension=${dimension}`
    );
}

/**
 * 涵洞数量-子查询
 * @param {string|Number} level 组织级别 0-集团,1-公司,2-路段
 * @param {string|Number} type 是否加类别统计 0-否,1-是
 */
export function culvertCountChild(level, type, dimension) {
    return axios.get(
        `${api}/culvertCountChild?level=${level}&type=${type}&dimension=${dimension}`
    );
}

/**
 * 沿线设施数量
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function getRoadsideCount(level, dimension) {
    return axios.get(`${api}/roadsideCount`, {
        params: { level, dimension },
    });
}
/**
 * 边坡数量
 * @param {string|Number} level 组织级别 0-集团,1-公司,2-路段
 * @param {string|Number} riskType 是否加类别统计 0-否,1-是
 */
export function getSideslopeCount(level, type, dimension) {
    return axios.get(
        `${api}/sideslopeCount?level=${level}&riskType=${type}&dimension=${dimension}`
    );
}

/**
 * 边坡数量子查询
 * @param {string|Number} level 组织级别 0-集团,1-公司,2-路段
 * @param {string|Number} riskType 是否加类别统计 0-否,1-是
 */
export function sideslopeCountChild(level, type, dimension) {
    return axios.get(
        `${api}/sideslopeCountChild?level=${level}&riskType=${type}&dimension=${dimension}`
    )
        .then((res) => {
            res.msgContent = res.msgContent.filter(
                (item) => !ignoreOrgCodes.includes(item.orgCode)
            );
            return res;
        });
}

/**
 * 沿线设施信息
 */
export function getRoadsideInfo(params) {
    return axios.get(`${api}/roadsideInfo`, { params });
}

/**
 * 涵洞信息
 */
export function getCulvertInfo(params) {
    return axios.get(`${api}/culvertInfo`, { params });
}

/**
 * 边坡信息
 */
export function getSideslopeInfo(params) {
    return axios.get(`${api}/sideslopeInfo`, { params });
}

/**
 * 服务区信息
 */
export function getServiceareaInfo(params) {
    return axios.get(`${api}/serviceareaInfo`, { params });
}

/**
 * 互通信息
 */
export function getHutongInfo(params) {
    return axios.get(`${api}/hutongInfo`, { params });
}
/**
 * 收费站
 */
export function getTollstationInfo(params) {
    return axios.get(`${api}/tollstationInfo`, { params });
}

/**
 * 桥梁信息
 */
export function getBridgeInfo(params) {
    return axios.get(`${api}/bridgeInfo`, { params });
}

/**
 * 隧道信息
 */
export function getTunnelInfo(params) {
    return axios.get(`${api}/tunnelInfo`, { params });
}

/**
 * 路段数量
 */
export function getSectionNum(params) {
    return axios.get(`${api}/sectionCountlevel`, {
        params,
    });
}

/**
 * 路段数量-子列表
 */
export function sectionCountlevelChild(params) {
    return axios.get(`${api}/sectionCountlevelChild`, {
        params,
    });
}
/**
 * 路段信息
 */
export function getSectionInfo(params) {
    return axios.get(`${api}/sectionInfo`, { params });
}

// 路段信息(视频监控页面)
export function getSectionVideoRegion(sectionId) {
    return axios.get(`${api}/sectionVideoRegion`, {
        params: {
            sectionId,
        },
    });
}
/**
 * 养护设施&人员
 */
export function getMaintainStaffInfo() {
    return axios.get(`${api}/maintainStaffInfo`);
}

/**
 * 养护车辆统计
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function getVehicleCount(level, dimension) {
    return axios.get(`${api}/vehicleCount`, {
        params: { level, dimension },
    });
}

// 组织架构
export function getOrg() {
    return axios.get(`${api}/organizationTree`);
}
// 养护工区
export function mtWorkAreaInfo(params) {
    return axios.get(`${api}/mtWorkAreaInfo`, { params });
}
// 应急物资
export function emergencySupplyInfo(params) {
    return axios.get(`${api}/emergencySupplyInfo`, { params });
}
// 救援点
export function rescuePointInfo(params) {
    return axios.get(`${api}/rescuePointInfo`, { params });
}
// 沿路设施
export function roadsideInfo(params) {
    return axios.get(`${api}/roadsideInfo`, { params });
}
// 收费站
export function tollstationInfo(params) {
    return axios.get(`${api}/tollstationInfo`, { params });
}
// 服务区
export function serviceareaInfo(params) {
    return axios.get(`${api}/serviceareaInfo`, { params });
}
// 互通
export function hutongInfo(params) {
    return axios.get(`${api}/hutongInfo`, { params });
}
// 边坡
export function sideslopeInfo(params) {
    return axios.get(`${api}/sideslopeInfo`, { params });
}
// 桥梁
export function bridgeInfo(params) {
    return axios.get(`${api}/bridgeInfo`, { params });
}
// 隧道
export function tunnelInfo(params) {
    return axios.get(`${api}/tunnelInfo`, { params });
}
// 涵洞
export function culvertInfo(params) {
    return axios.get(`${api}/culvertInfo`, { params });
}

// 养护站统计
export function getSectionStationCount(params) {
    return axios.get(`${api}/sectionStationCount`, {
        params,
    });
}

//  养护工区统计
export function workareaNext(params) {
    return axios.get(`${api}/workareaNext`, {
        params,
    })
        .then((res) => {
            res.msgContent = res.msgContent.filter(
                (item) => !ignoreOrgCodes.includes(item.orgCode)
            );
            return res;
        });
}

// 根据路段id获取路段经纬度
export function getLonLatByAllRoads(params) {
    return axios.get(`${apijw}/sectionPoints`, { params });
}

// 获取路况
export function getTrackDriving(params) {
    // return axios.get(`/bizapi1/proxy-traffic-server/traffic/track/driving`, { params });
    return axios.get(`/bizapi1/proxy-traffic-server/traffic/track/cache/driving`, { params });
}


//  养护工区点位图文详情
export function workareaBaseInfo(params) {
    return axios.get(`${api}/workareaBaseInfo`, {
        params,
    });
}