// import axios from '@/utils/axios';
import axios from "@/utils/axiosCrossDomain";

// 需要暂时屏蔽掉未开通的省份
// 安徽、湖南、新疆、河北、江西
const ignoreOrgCodes = ["AH", "HN", "XJ", "HB", "JX"];

const baseUrl = "/http-server-base/publish/quota-v1";
const api = `/bizapi1${baseUrl}`;

/**
 * 养护业务主数据
 */
export function budgetMoneyYear(params) {
    return axios.get(`${api}/budgetMoneyYear`, { params });
}

/**
 *  日常/专项养护
 */
export function specialConserveCount(params) {
    return axios.get(`${api}/specialConserveCount`, { params });
}
/**
 * 日常巡检个数
 */
export function dailyInspectCount(params) {
    return axios.get(`${api}/dailyInspectCount`, { params })
        .then((res) => {
            res.msgContent = res.msgContent.filter(
                (item) => !ignoreOrgCodes.includes(item.orgCode)
            );
            return res;
        });
}
/**
 * 定期/经常检查个数
 */
export function regularInspectCount(params) {
    return axios.get(`${api}/faciInspectCount`, { params });
}
/**
 * 病害数量
 */
export function diseaseCount(params) {
    return axios.get(`${api}/diseaseCount`, { params });
}
/**
 * 病害类型比较
 */
export function diseaseCountType(params) {
    return axios.get(`${api}/diseaseCountType`, { params });
}
/**
 * 养护工单数量
 */
export function worktableCount(params) {
    return axios.get(`${api}/worktableCount`, { params });
}
/**
 * 工单任务执行情况
 */
export function taskStatusCount(params) {
    return axios.get(`${api}/taskStatusCount`, { params });
}



/**
 * 病害平均处理天数
 */
export function diseaseHandle(params) {
    return axios.get(`${api}/diseaseHandle`, { params });
}

/**
 * 养护支付金额
 * @param {string|Number} level 级别
 */
export function payedAmount(params) {
    return axios.get(`${api}/payedAmount`, { params });
}
/**
 * 集团-养护预算
 */
export function budgetEu(params) {
    return axios.get(`${api}/budgetEu`, { params });
}

/**
 * 单公里养护费用
 */
export function mileageAmountAver(params) {
    return axios.get(`${api}/mileageAmountAver`, { params });
}

/**
 * 里程排行 公里
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function sectionInfo(params) {
    return axios.get(`${api}/sectionInfo`, {
        params,
    });
}

/**
 * 养护车辆类型统计
 * @param {string|Number} level 组织级别 0-集团,1-省份,2-公司,3-路段
 * @param {string|Number} dimension 维度id
 */
export function getMtVehicleTypeCount(params) {
    return axios.get(`${api}/mtVehicleTypeCount`, {
        params,
    });
}
