'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var ElButton = require('../el-button');
var ElPopper = require('../el-popper');
var hooks = require('../hooks');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var ElButton__default = /*#__PURE__*/_interopDefaultLegacy(ElButton);
var ElPopper__default = /*#__PURE__*/_interopDefaultLegacy(ElPopper);

var script = vue.defineComponent({
  name: "ElPopconfirm",
  components: {
    ElButton: ElButton__default['default'],
    ElPopper: ElPopper__default['default']
  },
  props: {
    title: {
      type: String
    },
    confirmButtonText: {
      type: String
    },
    cancelButtonText: {
      type: String
    },
    confirmButtonType: {
      type: String,
      default: "primary"
    },
    cancelButtonType: {
      type: String,
      default: "text"
    },
    icon: {
      type: String,
      default: "el-icon-question"
    },
    iconColor: {
      type: String,
      default: "#f90"
    },
    hideIcon: {
      type: Boolean,
      default: false
    }
  },
  emits: ["confirm", "cancel"],
  setup(props, { emit }) {
    const { t } = hooks.useLocaleInject();
    const visible = vue.ref(false);
    const confirm = () => {
      visible.value = false;
      emit("confirm");
    };
    const cancel = () => {
      visible.value = false;
      emit("cancel");
    };
    const confirmButtonText_ = vue.computed(() => {
      return props.confirmButtonText || t("el.popconfirm.confirmButtonText");
    });
    const cancelButtonText_ = vue.computed(() => {
      return props.cancelButtonText || t("el.popconfirm.cancelButtonText");
    });
    return {
      visible,
      confirm,
      cancel,
      confirmButtonText_,
      cancelButtonText_
    };
  }
});

const _hoisted_1 = { class: "el-popconfirm" };
const _hoisted_2 = { class: "el-popconfirm__main" };
const _hoisted_3 = { class: "el-popconfirm__action" };
function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_button = vue.resolveComponent("el-button");
  const _component_el_popper = vue.resolveComponent("el-popper");
  return vue.openBlock(), vue.createBlock(_component_el_popper, {
    visible: _ctx.visible,
    "onUpdate:visible": _cache[1] || (_cache[1] = ($event) => _ctx.visible = $event),
    trigger: "click",
    effect: "light",
    "popper-class": "el-popover",
    "append-to-body": "",
    "fallback-placements": ["bottom", "top", "right", "left"]
  }, {
    trigger: vue.withCtx(() => [
      vue.renderSlot(_ctx.$slots, "reference")
    ]),
    default: vue.withCtx(() => [
      vue.createVNode("div", _hoisted_1, [
        vue.createVNode("p", _hoisted_2, [
          !_ctx.hideIcon ? (vue.openBlock(), vue.createBlock("i", {
            key: 0,
            class: [_ctx.icon, "el-popconfirm__icon"],
            style: { color: _ctx.iconColor }
          }, null, 6)) : vue.createCommentVNode("v-if", true),
          vue.createTextVNode(" " + vue.toDisplayString(_ctx.title), 1)
        ]),
        vue.createVNode("div", _hoisted_3, [
          vue.createVNode(_component_el_button, {
            size: "mini",
            type: _ctx.cancelButtonType,
            onClick: _ctx.cancel
          }, {
            default: vue.withCtx(() => [
              vue.createTextVNode(vue.toDisplayString(_ctx.cancelButtonText_), 1)
            ]),
            _: 1
          }, 8, ["type", "onClick"]),
          vue.createVNode(_component_el_button, {
            size: "mini",
            type: _ctx.confirmButtonType,
            onClick: _ctx.confirm
          }, {
            default: vue.withCtx(() => [
              vue.createTextVNode(vue.toDisplayString(_ctx.confirmButtonText_), 1)
            ]),
            _: 1
          }, 8, ["type", "onClick"])
        ])
      ])
    ]),
    _: 1
  }, 8, ["visible"]);
}

script.render = render;
script.__file = "packages/popconfirm/src/index.vue";

script.install = (app) => {
  app.component(script.name, script);
};
const _Popconfirm = script;

exports.default = _Popconfirm;
