'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var dayjs = require('dayjs');
var timePicker = require('../el-time-picker');
var hooks = require('../hooks');
var ElInput = require('../el-input');
var directives = require('../directives');
var aria = require('../utils/aria');
var ElButton = require('../el-button');
var validators = require('../utils/validators');
var util = require('../utils/util');
var dom = require('../utils/dom');
var customParseFormat = require('dayjs/plugin/customParseFormat');
var advancedFormat = require('dayjs/plugin/advancedFormat');
var localeData = require('dayjs/plugin/localeData');
var weekOfYear = require('dayjs/plugin/weekOfYear');
var weekYear = require('dayjs/plugin/weekYear');
var dayOfYear = require('dayjs/plugin/dayOfYear');
var isSameOrAfter = require('dayjs/plugin/isSameOrAfter');
var isSameOrBefore = require('dayjs/plugin/isSameOrBefore');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var dayjs__default = /*#__PURE__*/_interopDefaultLegacy(dayjs);
var ElInput__default = /*#__PURE__*/_interopDefaultLegacy(ElInput);
var ElButton__default = /*#__PURE__*/_interopDefaultLegacy(ElButton);
var customParseFormat__default = /*#__PURE__*/_interopDefaultLegacy(customParseFormat);
var advancedFormat__default = /*#__PURE__*/_interopDefaultLegacy(advancedFormat);
var localeData__default = /*#__PURE__*/_interopDefaultLegacy(localeData);
var weekOfYear__default = /*#__PURE__*/_interopDefaultLegacy(weekOfYear);
var weekYear__default = /*#__PURE__*/_interopDefaultLegacy(weekYear);
var dayOfYear__default = /*#__PURE__*/_interopDefaultLegacy(dayOfYear);
var isSameOrAfter__default = /*#__PURE__*/_interopDefaultLegacy(isSameOrAfter);
var isSameOrBefore__default = /*#__PURE__*/_interopDefaultLegacy(isSameOrBefore);

var script = vue.defineComponent({
  props: {
    date: {
      type: Object
    },
    minDate: {
      type: Object
    },
    maxDate: {
      type: Object
    },
    parsedValue: {
      type: [Object, Array]
    },
    selectionMode: {
      type: String,
      default: "day"
    },
    showWeekNumber: {
      type: Boolean,
      default: false
    },
    disabledDate: {
      type: Function
    },
    cellClassName: {
      type: Function
    },
    rangeState: {
      type: Object,
      default: () => ({
        endDate: null,
        selecting: false
      })
    }
  },
  emits: ["changerange", "pick", "select"],
  setup(props, ctx) {
    const { t, lang } = hooks.useLocaleInject();
    const lastRow = vue.ref(null);
    const lastColumn = vue.ref(null);
    const tableRows = vue.ref([[], [], [], [], [], []]);
    const firstDayOfWeek = props.date.$locale().weekStart || 7;
    const WEEKS_CONSTANT = props.date.locale("en").localeData().weekdaysShort().map((_) => _.toLowerCase());
    const offsetDay = vue.computed(() => {
      return firstDayOfWeek > 3 ? 7 - firstDayOfWeek : -firstDayOfWeek;
    });
    const startDate = vue.computed(() => {
      const startDayOfMonth = props.date.startOf("month");
      return startDayOfMonth.subtract(startDayOfMonth.day() || 7, "day");
    });
    const WEEKS = vue.computed(() => {
      return WEEKS_CONSTANT.concat(WEEKS_CONSTANT).slice(firstDayOfWeek, firstDayOfWeek + 7);
    });
    const rows = vue.computed(() => {
      var _a;
      const startOfMonth = props.date.startOf("month");
      const startOfMonthDay = startOfMonth.day() || 7;
      const dateCountOfMonth = startOfMonth.daysInMonth();
      const dateCountOfLastMonth = startOfMonth.subtract(1, "month").daysInMonth();
      const offset = offsetDay.value;
      const rows_ = tableRows.value;
      let count = 1;
      const selectedDate = props.selectionMode === "dates" ? util.coerceTruthyValueToArray(props.parsedValue) : [];
      const calNow = dayjs__default['default']().locale(lang.value).startOf("day");
      for (let i = 0; i < 6; i++) {
        const row = rows_[i];
        if (props.showWeekNumber) {
          if (!row[0]) {
            row[0] = {
              type: "week",
              text: startDate.value.add(i * 7 + 1, "day").week()
            };
          }
        }
        for (let j = 0; j < 7; j++) {
          let cell = row[props.showWeekNumber ? j + 1 : j];
          if (!cell) {
            cell = {
              row: i,
              column: j,
              type: "normal",
              inRange: false,
              start: false,
              end: false
            };
          }
          const index = i * 7 + j;
          const calTime = startDate.value.add(index - offset, "day");
          cell.type = "normal";
          const calEndDate = props.rangeState.endDate || props.maxDate || props.rangeState.selecting && props.minDate;
          cell.inRange = props.minDate && calTime.isSameOrAfter(props.minDate, "day") && (calEndDate && calTime.isSameOrBefore(calEndDate, "day")) || props.minDate && calTime.isSameOrBefore(props.minDate, "day") && (calEndDate && calTime.isSameOrAfter(calEndDate, "day"));
          if ((_a = props.minDate) == null ? void 0 : _a.isSameOrAfter(calEndDate)) {
            cell.start = calEndDate && calTime.isSame(calEndDate, "day");
            cell.end = props.minDate && calTime.isSame(props.minDate, "day");
          } else {
            cell.start = props.minDate && calTime.isSame(props.minDate, "day");
            cell.end = calEndDate && calTime.isSame(calEndDate, "day");
          }
          const isToday = calTime.isSame(calNow, "day");
          if (isToday) {
            cell.type = "today";
          }
          if (i >= 0 && i <= 1) {
            const numberOfDaysFromPreviousMonth = startOfMonthDay + offset < 0 ? 7 + startOfMonthDay + offset : startOfMonthDay + offset;
            if (j + i * 7 >= numberOfDaysFromPreviousMonth) {
              cell.text = count++;
            } else {
              cell.text = dateCountOfLastMonth - (numberOfDaysFromPreviousMonth - j % 7) + 1 + i * 7;
              cell.type = "prev-month";
            }
          } else {
            if (count <= dateCountOfMonth) {
              cell.text = count++;
            } else {
              cell.text = count++ - dateCountOfMonth;
              cell.type = "next-month";
            }
          }
          const cellDate = calTime.toDate();
          cell.selected = selectedDate.find((_) => _.valueOf() === calTime.valueOf());
          cell.disabled = props.disabledDate && props.disabledDate(cellDate);
          cell.customClass = props.cellClassName && props.cellClassName(cellDate);
          row[props.showWeekNumber ? j + 1 : j] = cell;
        }
        if (props.selectionMode === "week") {
          const start = props.showWeekNumber ? 1 : 0;
          const end = props.showWeekNumber ? 7 : 6;
          const isActive = isWeekActive(row[start + 1]);
          row[start].inRange = isActive;
          row[start].start = isActive;
          row[end].inRange = isActive;
          row[end].end = isActive;
        }
      }
      return rows_;
    });
    const cellMatchesDate = (cell, date) => {
      if (!date)
        return false;
      return dayjs__default['default'](date).locale(lang.value).isSame(props.date.date(Number(cell.text)), "day");
    };
    const getCellClasses = (cell) => {
      let classes = [];
      if ((cell.type === "normal" || cell.type === "today") && !cell.disabled) {
        classes.push("available");
        if (cell.type === "today") {
          classes.push("today");
        }
      } else {
        classes.push(cell.type);
      }
      if (props.selectionMode === "day" && (cell.type === "normal" || cell.type === "today") && cellMatchesDate(cell, props.parsedValue)) {
        classes.push("current");
      }
      if (cell.inRange && (cell.type === "normal" || cell.type === "today" || props.selectionMode === "week")) {
        classes.push("in-range");
        if (cell.start) {
          classes.push("start-date");
        }
        if (cell.end) {
          classes.push("end-date");
        }
      }
      if (cell.disabled) {
        classes.push("disabled");
      }
      if (cell.selected) {
        classes.push("selected");
      }
      if (cell.customClass) {
        classes.push(cell.customClass);
      }
      return classes.join(" ");
    };
    const getDateOfCell = (row, column) => {
      const offsetFromStart = row * 7 + (column - (props.showWeekNumber ? 1 : 0)) - offsetDay.value;
      return startDate.value.add(offsetFromStart, "day");
    };
    const handleMouseMove = (event) => {
      if (!props.rangeState.selecting)
        return;
      let target = event.target;
      if (target.tagName === "SPAN") {
        target = target.parentNode.parentNode;
      }
      if (target.tagName === "DIV") {
        target = target.parentNode;
      }
      if (target.tagName !== "TD")
        return;
      const row = target.parentNode.rowIndex - 1;
      const column = target.cellIndex;
      if (rows.value[row][column].disabled)
        return;
      if (row !== lastRow.value || column !== lastColumn.value) {
        lastRow.value = row;
        lastColumn.value = column;
        ctx.emit("changerange", {
          selecting: true,
          endDate: getDateOfCell(row, column)
        });
      }
    };
    const handleClick = (event) => {
      let target = event.target;
      if (target.tagName === "SPAN") {
        target = target.parentNode.parentNode;
      }
      if (target.tagName === "DIV") {
        target = target.parentNode;
      }
      if (target.tagName !== "TD")
        return;
      const row = target.parentNode.rowIndex - 1;
      const column = target.cellIndex;
      const cell = rows.value[row][column];
      if (cell.disabled || cell.type === "week")
        return;
      const newDate = getDateOfCell(row, column);
      if (props.selectionMode === "range") {
        if (!props.rangeState.selecting) {
          ctx.emit("pick", { minDate: newDate, maxDate: null });
          ctx.emit("select", true);
        } else {
          if (newDate >= props.minDate) {
            ctx.emit("pick", { minDate: props.minDate, maxDate: newDate });
          } else {
            ctx.emit("pick", { minDate: newDate, maxDate: props.minDate });
          }
          ctx.emit("select", false);
        }
      } else if (props.selectionMode === "day") {
        ctx.emit("pick", newDate);
      } else if (props.selectionMode === "week") {
        const weekNumber = newDate.week();
        const value = newDate.year() + "w" + weekNumber;
        ctx.emit("pick", {
          year: newDate.year(),
          week: weekNumber,
          value,
          date: newDate.startOf("week")
        });
      } else if (props.selectionMode === "dates") {
        const newValue = cell.selected ? util.coerceTruthyValueToArray(props.parsedValue).filter((_) => _.valueOf() !== newDate.valueOf()) : util.coerceTruthyValueToArray(props.parsedValue).concat([newDate]);
        ctx.emit("pick", newValue);
      }
    };
    const isWeekActive = (cell) => {
      if (props.selectionMode !== "week")
        return false;
      let newDate = props.date.startOf("day");
      if (cell.type === "prev-month") {
        newDate = newDate.subtract(1, "month");
      }
      if (cell.type === "next-month") {
        newDate = newDate.add(1, "month");
      }
      newDate = newDate.date(parseInt(cell.text, 10));
      if (props.parsedValue && !Array.isArray(props.parsedValue)) {
        const dayOffset = (props.parsedValue.day() - firstDayOfWeek + 7) % 7 - 1;
        const weekDate = props.parsedValue.subtract(dayOffset, "day");
        return weekDate.isSame(newDate, "day");
      }
      return false;
    };
    return {
      handleMouseMove,
      t,
      rows,
      isWeekActive,
      getCellClasses,
      WEEKS,
      handleClick
    };
  }
});

const _hoisted_1 = { key: 0 };
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return vue.openBlock(), vue.createBlock("table", {
    cellspacing: "0",
    cellpadding: "0",
    class: ["el-date-table", { "is-week-mode": _ctx.selectionMode === "week" }],
    onClick: _cache[1] || (_cache[1] = (...args) => _ctx.handleClick && _ctx.handleClick(...args)),
    onMousemove: _cache[2] || (_cache[2] = (...args) => _ctx.handleMouseMove && _ctx.handleMouseMove(...args))
  }, [
    vue.createVNode("tbody", null, [
      vue.createVNode("tr", null, [
        _ctx.showWeekNumber ? (vue.openBlock(), vue.createBlock("th", _hoisted_1, vue.toDisplayString(_ctx.t("el.datepicker.week")), 1)) : vue.createCommentVNode("v-if", true),
        (vue.openBlock(true), vue.createBlock(vue.Fragment, null, vue.renderList(_ctx.WEEKS, (week, key) => {
          return vue.openBlock(), vue.createBlock("th", { key }, vue.toDisplayString(_ctx.t("el.datepicker.weeks." + week)), 1);
        }), 128))
      ]),
      (vue.openBlock(true), vue.createBlock(vue.Fragment, null, vue.renderList(_ctx.rows, (row, key) => {
        return vue.openBlock(), vue.createBlock("tr", {
          key,
          class: ["el-date-table__row", { current: _ctx.isWeekActive(row[1]) }]
        }, [
          (vue.openBlock(true), vue.createBlock(vue.Fragment, null, vue.renderList(row, (cell, key_) => {
            return vue.openBlock(), vue.createBlock("td", {
              key: key_,
              class: _ctx.getCellClasses(cell)
            }, [
              vue.createVNode("div", null, [
                vue.createVNode("span", null, vue.toDisplayString(cell.text), 1)
              ])
            ], 2);
          }), 128))
        ], 2);
      }), 128))
    ])
  ], 34);
}

script.render = render;
script.__file = "packages/date-picker/src/date-picker-com/basic-date-table.vue";

const datesInMonth = (year, month, lang) => {
  const firstDay = dayjs__default['default']().locale(lang).startOf("month").month(month).year(year);
  const numOfDays = firstDay.daysInMonth();
  return timePicker.rangeArr(numOfDays).map((n) => firstDay.add(n, "day").toDate());
};
var script$1 = vue.defineComponent({
  props: {
    disabledDate: {
      type: Function
    },
    selectionMode: {
      type: String,
      default: "month"
    },
    minDate: {
      type: Object
    },
    maxDate: {
      type: Object
    },
    date: {
      type: Object
    },
    parsedValue: {
      type: Object
    },
    rangeState: {
      type: Object,
      default: () => ({
        endDate: null,
        selecting: false
      })
    }
  },
  emits: ["changerange", "pick", "select"],
  setup(props, ctx) {
    const { t, lang } = hooks.useLocaleInject();
    const months = vue.ref(props.date.locale("en").localeData().monthsShort().map((_) => _.toLowerCase()));
    const tableRows = vue.ref([[], [], []]);
    const lastRow = vue.ref(null);
    const lastColumn = vue.ref(null);
    const rows = vue.computed(() => {
      var _a;
      const rows2 = tableRows.value;
      const now = dayjs__default['default']().locale(lang.value).startOf("month");
      for (let i = 0; i < 3; i++) {
        const row = rows2[i];
        for (let j = 0; j < 4; j++) {
          let cell = row[j];
          if (!cell) {
            cell = {
              row: i,
              column: j,
              type: "normal",
              inRange: false,
              start: false,
              end: false
            };
          }
          cell.type = "normal";
          const index = i * 4 + j;
          const calTime = props.date.startOf("year").month(index);
          const calEndDate = props.rangeState.endDate || props.maxDate || props.rangeState.selecting && props.minDate;
          cell.inRange = props.minDate && calTime.isSameOrAfter(props.minDate, "month") && (calEndDate && calTime.isSameOrBefore(calEndDate, "month")) || props.minDate && calTime.isSameOrBefore(props.minDate, "month") && (calEndDate && calTime.isSameOrAfter(calEndDate, "month"));
          if ((_a = props.minDate) == null ? void 0 : _a.isSameOrAfter(calEndDate)) {
            cell.start = calEndDate && calTime.isSame(calEndDate, "month");
            cell.end = props.minDate && calTime.isSame(props.minDate, "month");
          } else {
            cell.start = props.minDate && calTime.isSame(props.minDate, "month");
            cell.end = calEndDate && calTime.isSame(calEndDate, "month");
          }
          const isToday = now.isSame(calTime);
          if (isToday) {
            cell.type = "today";
          }
          cell.text = index;
          let cellDate = calTime.toDate();
          cell.disabled = props.disabledDate && props.disabledDate(cellDate);
          row[j] = cell;
        }
      }
      return rows2;
    });
    const getCellStyle = (cell) => {
      const style = {};
      const year = props.date.year();
      const today = new Date();
      const month = cell.text;
      style.disabled = props.disabledDate ? datesInMonth(year, month, lang.value).every(props.disabledDate) : false;
      style.current = util.coerceTruthyValueToArray(props.parsedValue).findIndex((date) => date.year() === year && date.month() === month) >= 0;
      style.today = today.getFullYear() === year && today.getMonth() === month;
      if (cell.inRange) {
        style["in-range"] = true;
        if (cell.start) {
          style["start-date"] = true;
        }
        if (cell.end) {
          style["end-date"] = true;
        }
      }
      return style;
    };
    const handleMouseMove = (event) => {
      if (!props.rangeState.selecting)
        return;
      let target = event.target;
      if (target.tagName === "A") {
        target = target.parentNode.parentNode;
      }
      if (target.tagName === "DIV") {
        target = target.parentNode;
      }
      if (target.tagName !== "TD")
        return;
      const row = target.parentNode.rowIndex;
      const column = target.cellIndex;
      if (rows.value[row][column].disabled)
        return;
      if (row !== lastRow.value || column !== lastColumn.value) {
        lastRow.value = row;
        lastColumn.value = column;
        ctx.emit("changerange", {
          selecting: true,
          endDate: props.date.startOf("year").month(row * 4 + column)
        });
      }
    };
    const handleMonthTableClick = (event) => {
      let target = event.target;
      if (target.tagName === "A") {
        target = target.parentNode.parentNode;
      }
      if (target.tagName === "DIV") {
        target = target.parentNode;
      }
      if (target.tagName !== "TD")
        return;
      if (dom.hasClass(target, "disabled"))
        return;
      const column = target.cellIndex;
      const row = target.parentNode.rowIndex;
      const month = row * 4 + column;
      const newDate = props.date.startOf("year").month(month);
      if (props.selectionMode === "range") {
        if (!props.rangeState.selecting) {
          ctx.emit("pick", { minDate: newDate, maxDate: null });
          ctx.emit("select", true);
        } else {
          if (newDate >= props.minDate) {
            ctx.emit("pick", { minDate: props.minDate, maxDate: newDate });
          } else {
            ctx.emit("pick", { minDate: newDate, maxDate: props.minDate });
          }
          ctx.emit("select", false);
        }
      } else {
        ctx.emit("pick", month);
      }
    };
    return {
      handleMouseMove,
      handleMonthTableClick,
      rows,
      getCellStyle,
      t,
      months
    };
  }
});

const _hoisted_1$1 = { class: "cell" };
function render$1(_ctx, _cache, $props, $setup, $data, $options) {
  return vue.openBlock(), vue.createBlock("table", {
    class: "el-month-table",
    onClick: _cache[1] || (_cache[1] = (...args) => _ctx.handleMonthTableClick && _ctx.handleMonthTableClick(...args)),
    onMousemove: _cache[2] || (_cache[2] = (...args) => _ctx.handleMouseMove && _ctx.handleMouseMove(...args))
  }, [
    vue.createVNode("tbody", null, [
      (vue.openBlock(true), vue.createBlock(vue.Fragment, null, vue.renderList(_ctx.rows, (row, key) => {
        return vue.openBlock(), vue.createBlock("tr", { key }, [
          (vue.openBlock(true), vue.createBlock(vue.Fragment, null, vue.renderList(row, (cell, key_) => {
            return vue.openBlock(), vue.createBlock("td", {
              key: key_,
              class: _ctx.getCellStyle(cell)
            }, [
              vue.createVNode("div", null, [
                vue.createVNode("a", _hoisted_1$1, vue.toDisplayString(_ctx.t("el.datepicker.months." + _ctx.months[cell.text])), 1)
              ])
            ], 2);
          }), 128))
        ]);
      }), 128))
    ])
  ], 32);
}

script$1.render = render$1;
script$1.__file = "packages/date-picker/src/date-picker-com/basic-month-table.vue";

const datesInYear = (year, lang) => {
  const firstDay = dayjs__default['default'](String(year)).locale(lang).startOf("year");
  const lastDay = firstDay.endOf("year");
  const numOfDays = lastDay.dayOfYear();
  return timePicker.rangeArr(numOfDays).map((n) => firstDay.add(n, "day").toDate());
};
var script$2 = vue.defineComponent({
  props: {
    disabledDate: {
      type: Function
    },
    parsedValue: {
      type: Object
    },
    date: {
      type: Object
    }
  },
  emits: ["pick"],
  setup(props, ctx) {
    const { lang } = hooks.useLocaleInject();
    const startYear = vue.computed(() => {
      return Math.floor(props.date.year() / 10) * 10;
    });
    const getCellStyle = (year) => {
      const style = {};
      const today = dayjs__default['default']().locale(lang.value);
      style.disabled = props.disabledDate ? datesInYear(year, lang.value).every(props.disabledDate) : false;
      style.current = util.coerceTruthyValueToArray(props.parsedValue).findIndex((_) => _.year() === year) >= 0;
      style.today = today.year() === year;
      return style;
    };
    const handleYearTableClick = (event) => {
      const target = event.target;
      if (target.tagName === "A") {
        if (dom.hasClass(target.parentNode, "disabled"))
          return;
        const year = target.textContent || target.innerText;
        ctx.emit("pick", Number(year));
      }
    };
    return {
      startYear,
      getCellStyle,
      handleYearTableClick
    };
  }
});

const _hoisted_1$2 = { class: "cell" };
const _hoisted_2 = { class: "cell" };
const _hoisted_3 = { class: "cell" };
const _hoisted_4 = { class: "cell" };
const _hoisted_5 = { class: "cell" };
const _hoisted_6 = { class: "cell" };
const _hoisted_7 = { class: "cell" };
const _hoisted_8 = { class: "cell" };
const _hoisted_9 = { class: "cell" };
const _hoisted_10 = { class: "cell" };
const _hoisted_11 = /* @__PURE__ */ vue.createVNode("td", null, null, -1);
const _hoisted_12 = /* @__PURE__ */ vue.createVNode("td", null, null, -1);
function render$2(_ctx, _cache, $props, $setup, $data, $options) {
  return vue.openBlock(), vue.createBlock("table", {
    class: "el-year-table",
    onClick: _cache[1] || (_cache[1] = (...args) => _ctx.handleYearTableClick && _ctx.handleYearTableClick(...args))
  }, [
    vue.createVNode("tbody", null, [
      vue.createVNode("tr", null, [
        vue.createVNode("td", {
          class: ["available", _ctx.getCellStyle(_ctx.startYear + 0)]
        }, [
          vue.createVNode("a", _hoisted_1$2, vue.toDisplayString(_ctx.startYear), 1)
        ], 2),
        vue.createVNode("td", {
          class: ["available", _ctx.getCellStyle(_ctx.startYear + 1)]
        }, [
          vue.createVNode("a", _hoisted_2, vue.toDisplayString(_ctx.startYear + 1), 1)
        ], 2),
        vue.createVNode("td", {
          class: ["available", _ctx.getCellStyle(_ctx.startYear + 2)]
        }, [
          vue.createVNode("a", _hoisted_3, vue.toDisplayString(_ctx.startYear + 2), 1)
        ], 2),
        vue.createVNode("td", {
          class: ["available", _ctx.getCellStyle(_ctx.startYear + 3)]
        }, [
          vue.createVNode("a", _hoisted_4, vue.toDisplayString(_ctx.startYear + 3), 1)
        ], 2)
      ]),
      vue.createVNode("tr", null, [
        vue.createVNode("td", {
          class: ["available", _ctx.getCellStyle(_ctx.startYear + 4)]
        }, [
          vue.createVNode("a", _hoisted_5, vue.toDisplayString(_ctx.startYear + 4), 1)
        ], 2),
        vue.createVNode("td", {
          class: ["available", _ctx.getCellStyle(_ctx.startYear + 5)]
        }, [
          vue.createVNode("a", _hoisted_6, vue.toDisplayString(_ctx.startYear + 5), 1)
        ], 2),
        vue.createVNode("td", {
          class: ["available", _ctx.getCellStyle(_ctx.startYear + 6)]
        }, [
          vue.createVNode("a", _hoisted_7, vue.toDisplayString(_ctx.startYear + 6), 1)
        ], 2),
        vue.createVNode("td", {
          class: ["available", _ctx.getCellStyle(_ctx.startYear + 7)]
        }, [
          vue.createVNode("a", _hoisted_8, vue.toDisplayString(_ctx.startYear + 7), 1)
        ], 2)
      ]),
      vue.createVNode("tr", null, [
        vue.createVNode("td", {
          class: ["available", _ctx.getCellStyle(_ctx.startYear + 8)]
        }, [
          vue.createVNode("a", _hoisted_9, vue.toDisplayString(_ctx.startYear + 8), 1)
        ], 2),
        vue.createVNode("td", {
          class: ["available", _ctx.getCellStyle(_ctx.startYear + 9)]
        }, [
          vue.createVNode("a", _hoisted_10, vue.toDisplayString(_ctx.startYear + 9), 1)
        ], 2),
        _hoisted_11,
        _hoisted_12
      ])
    ])
  ]);
}

script$2.render = render$2;
script$2.__file = "packages/date-picker/src/date-picker-com/basic-year-table.vue";

const timeWithinRange = () => true;
var script$3 = vue.defineComponent({
  components: {
    DateTable: script,
    ElInput: ElInput__default['default'],
    ElButton: ElButton__default['default'],
    TimePickPanel: timePicker.TimePickPanel,
    MonthTable: script$1,
    YearTable: script$2
  },
  directives: { clickoutside: directives.ClickOutside },
  props: {
    visible: {
      type: Boolean,
      default: false
    },
    parsedValue: {
      type: [Object, Array]
    },
    format: {
      type: String,
      default: ""
    },
    type: {
      type: String,
      required: true,
      validator: validators.isValidDatePickType
    }
  },
  emits: ["pick", "set-picker-option"],
  setup(props, ctx) {
    const { t, lang } = hooks.useLocaleInject();
    const innerDate = vue.ref(dayjs__default['default']().locale(lang.value));
    const month = vue.computed(() => {
      return innerDate.value.month();
    });
    const year = vue.computed(() => {
      return innerDate.value.year();
    });
    const selectableRange = vue.ref([]);
    const userInputDate = vue.ref(null);
    const userInputTime = vue.ref(null);
    const checkDateWithinRange = (date) => {
      return selectableRange.value.length > 0 ? timeWithinRange(date, selectableRange.value, props.format || "HH:mm:ss") : true;
    };
    const formatEmit = (emitDayjs) => {
      if (defaultTime) {
        const defaultTimeD = dayjs__default['default'](defaultTime).locale(lang.value);
        return defaultTimeD.year(emitDayjs.year()).month(emitDayjs.month()).date(emitDayjs.date());
      }
      if (showTime.value)
        return emitDayjs.millisecond(0);
      return emitDayjs.startOf("day");
    };
    const emit = (value, ...args) => {
      if (!value) {
        ctx.emit("pick", value, ...args);
      } else if (Array.isArray(value)) {
        const dates = value.map(formatEmit);
        ctx.emit("pick", dates, ...args);
      } else {
        ctx.emit("pick", formatEmit(value), ...args);
      }
      userInputDate.value = null;
      userInputTime.value = null;
    };
    const handleDatePick = (value) => {
      if (selectionMode.value === "day") {
        let newDate = props.parsedValue ? props.parsedValue.year(value.year()).month(value.month()).date(value.date()) : value;
        if (!checkDateWithinRange(newDate)) {
          newDate = selectableRange.value[0][0].year(value.year()).month(value.month()).date(value.date());
        }
        innerDate.value = newDate;
        emit(newDate, showTime.value);
      } else if (selectionMode.value === "week") {
        emit(value.date);
      } else if (selectionMode.value === "dates") {
        emit(value, true);
      }
    };
    const prevMonth_ = () => {
      innerDate.value = innerDate.value.subtract(1, "month");
    };
    const nextMonth_ = () => {
      innerDate.value = innerDate.value.add(1, "month");
    };
    const prevYear_ = () => {
      if (currentView.value === "year") {
        innerDate.value = innerDate.value.subtract(10, "year");
      } else {
        innerDate.value = innerDate.value.subtract(1, "year");
      }
    };
    const nextYear_ = () => {
      if (currentView.value === "year") {
        innerDate.value = innerDate.value.add(10, "year");
      } else {
        innerDate.value = innerDate.value.add(1, "year");
      }
    };
    const currentView = vue.ref("date");
    const yearLabel = vue.computed(() => {
      const yearTranslation = t("el.datepicker.year");
      if (currentView.value === "year") {
        const startYear = Math.floor(year.value / 10) * 10;
        if (yearTranslation) {
          return startYear + " " + yearTranslation + " - " + (startYear + 9) + " " + yearTranslation;
        }
        return startYear + " - " + (startYear + 9);
      }
      return year.value + " " + yearTranslation;
    });
    const handleShortcutClick = (shortcut) => {
      const shortcutValue = typeof shortcut.value === "function" ? shortcut.value() : shortcut.value;
      if (shortcutValue) {
        emit(dayjs__default['default'](shortcutValue).locale(lang.value));
        return;
      }
      if (shortcut.onClick) {
        shortcut.onClick(ctx);
      }
    };
    const selectionMode = vue.computed(() => {
      if (["week", "month", "year", "dates"].includes(props.type)) {
        return props.type;
      }
      return "day";
    });
    vue.watch(() => selectionMode.value, (val) => {
      if (["month", "year"].includes(val)) {
        currentView.value = val;
        return;
      }
      currentView.value = "date";
    }, { immediate: true });
    const hasShortcuts = vue.computed(() => !!shortcuts.length);
    const handleMonthPick = (month2) => {
      innerDate.value = innerDate.value.startOf("month").month(month2);
      if (selectionMode.value === "month") {
        emit(innerDate.value);
      } else {
        currentView.value = "date";
      }
    };
    const handleYearPick = (year2) => {
      if (selectionMode.value === "year") {
        innerDate.value = innerDate.value.startOf("year").year(year2);
        emit(innerDate.value);
      } else {
        innerDate.value = innerDate.value.year(year2);
        currentView.value = "month";
      }
    };
    const showMonthPicker = () => {
      currentView.value = "month";
    };
    const showYearPicker = () => {
      currentView.value = "year";
    };
    const showTime = vue.computed(() => props.type === "datetime" || props.type === "datetimerange");
    const footerVisible = vue.computed(() => {
      return showTime.value || selectionMode.value === "dates";
    });
    const onConfirm = () => {
      if (selectionMode.value === "dates") {
        emit(props.parsedValue);
      } else {
        let result = props.parsedValue;
        if (!result) {
          const defaultTimeD = dayjs__default['default'](defaultTime).locale(lang.value);
          const defaultValueD = getDefaultValue();
          result = defaultTimeD.year(defaultValueD.year()).month(defaultValueD.month()).date(defaultValueD.date());
        }
        innerDate.value = result;
        emit(result);
      }
    };
    const changeToNow = () => {
      const now = dayjs__default['default']().locale(lang.value);
      const nowDate = now.toDate();
      if ((!disabledDate || !disabledDate(nowDate)) && checkDateWithinRange(nowDate)) {
        innerDate.value = dayjs__default['default']().locale(lang.value);
        emit(innerDate.value);
      }
    };
    const timeFormat = vue.computed(() => {
      return timePicker.extractTimeFormat(props.format);
    });
    const dateFormat = vue.computed(() => {
      return timePicker.extractDateFormat(props.format);
    });
    const visibleTime = vue.computed(() => {
      if (userInputTime.value)
        return userInputTime.value;
      if (!props.parsedValue && !defaultValue)
        return;
      return (props.parsedValue || innerDate.value).format(timeFormat.value);
    });
    const visibleDate = vue.computed(() => {
      if (userInputDate.value)
        return userInputDate.value;
      if (!props.parsedValue && !defaultValue)
        return;
      return (props.parsedValue || innerDate.value).format(dateFormat.value);
    });
    const timePickerVisible = vue.ref(false);
    const onTimePickerInputFocus = () => {
      timePickerVisible.value = true;
    };
    const handleTimePickClose = () => {
      timePickerVisible.value = false;
    };
    const handleTimePick = (value, visible, first) => {
      const newDate = props.parsedValue ? props.parsedValue.hour(value.hour()).minute(value.minute()).second(value.second()) : value;
      innerDate.value = newDate;
      emit(innerDate.value, true);
      if (!first) {
        timePickerVisible.value = visible;
      }
    };
    const handleVisibleTimeChange = (value) => {
      const newDate = dayjs__default['default'](value, timeFormat.value).locale(lang.value);
      if (newDate.isValid() && checkDateWithinRange(newDate)) {
        innerDate.value = newDate.year(innerDate.value.year()).month(innerDate.value.month()).date(innerDate.value.date());
        userInputTime.value = null;
        timePickerVisible.value = false;
        emit(innerDate.value, true);
      }
    };
    const handleVisibleDateChange = (value) => {
      const newDate = dayjs__default['default'](value, dateFormat.value).locale(lang.value);
      if (newDate.isValid()) {
        if (disabledDate && disabledDate(newDate.toDate())) {
          return;
        }
        innerDate.value = newDate.hour(innerDate.value.hour()).minute(innerDate.value.minute()).second(innerDate.value.second());
        userInputDate.value = null;
        emit(innerDate.value, true);
      }
    };
    const isValidValue = (date_) => {
      return date_.isValid() && (disabledDate ? !disabledDate(date_.toDate()) : true);
    };
    const formatToString = (value) => {
      if (selectionMode.value === "dates") {
        return value.map((_) => _.format(props.format));
      }
      return value.format(props.format);
    };
    const parseUserInput = (value) => {
      return dayjs__default['default'](value, props.format).locale(lang.value);
    };
    const getDefaultValue = () => {
      return dayjs__default['default'](defaultValue).locale(lang.value);
    };
    const handleKeydown = (event) => {
      const { code, keyCode } = event;
      const list = [aria.EVENT_CODE.up, aria.EVENT_CODE.down, aria.EVENT_CODE.left, aria.EVENT_CODE.right];
      if (props.visible && !timePickerVisible.value) {
        if (list.includes(code)) {
          handleKeyControl(keyCode);
          event.stopPropagation();
          event.preventDefault();
        }
        if (code === aria.EVENT_CODE.enter && userInputDate.value === null && userInputTime.value === null) {
          emit(innerDate, false);
        }
      }
    };
    const handleKeyControl = (keyCode) => {
      const mapping = {
        "year": {
          38: -4,
          40: 4,
          37: -1,
          39: 1,
          offset: (date, step) => date.setFullYear(date.getFullYear() + step)
        },
        "month": {
          38: -4,
          40: 4,
          37: -1,
          39: 1,
          offset: (date, step) => date.setMonth(date.getMonth() + step)
        },
        "week": {
          38: -1,
          40: 1,
          37: -1,
          39: 1,
          offset: (date, step) => date.setDate(date.getDate() + step * 7)
        },
        "day": {
          38: -7,
          40: 7,
          37: -1,
          39: 1,
          offset: (date, step) => date.setDate(date.getDate() + step)
        }
      };
      const newDate = innerDate.value.toDate();
      while (Math.abs(innerDate.value.diff(newDate, "year", true)) < 1) {
        const map = mapping[selectionMode.value];
        map.offset(newDate, map[keyCode]);
        if (disabledDate && disabledDate(newDate)) {
          continue;
        }
        const result = dayjs__default['default'](newDate).locale(lang.value);
        innerDate.value = result;
        ctx.emit("pick", result, true);
        break;
      }
    };
    ctx.emit("set-picker-option", ["isValidValue", isValidValue]);
    ctx.emit("set-picker-option", ["formatToString", formatToString]);
    ctx.emit("set-picker-option", ["parseUserInput", parseUserInput]);
    ctx.emit("set-picker-option", ["handleKeydown", handleKeydown]);
    const pickerBase = vue.inject("EP_PICKER_BASE");
    const { shortcuts, disabledDate, cellClassName, defaultTime, defaultValue, arrowControl } = pickerBase.props;
    vue.watch(() => props.parsedValue, (val) => {
      if (val) {
        if (selectionMode.value === "dates")
          return;
        if (Array.isArray(val))
          return;
        innerDate.value = val;
      } else {
        innerDate.value = getDefaultValue();
      }
    }, { immediate: true });
    return {
      handleTimePick,
      handleTimePickClose,
      onTimePickerInputFocus,
      timePickerVisible,
      visibleTime,
      visibleDate,
      showTime,
      changeToNow,
      onConfirm,
      footerVisible,
      handleYearPick,
      showMonthPicker,
      showYearPicker,
      handleMonthPick,
      hasShortcuts,
      shortcuts,
      arrowControl,
      disabledDate,
      cellClassName,
      selectionMode,
      handleShortcutClick,
      prevYear_,
      nextYear_,
      prevMonth_,
      nextMonth_,
      innerDate,
      t,
      yearLabel,
      currentView,
      month,
      handleDatePick,
      handleVisibleTimeChange,
      handleVisibleDateChange,
      timeFormat,
      userInputTime,
      userInputDate
    };
  }
});

const _hoisted_1$3 = { class: "el-picker-panel__body-wrapper" };
const _hoisted_2$1 = {
  key: 0,
  class: "el-picker-panel__sidebar"
};
const _hoisted_3$1 = { class: "el-picker-panel__body" };
const _hoisted_4$1 = {
  key: 0,
  class: "el-date-picker__time-header"
};
const _hoisted_5$1 = { class: "el-date-picker__editor-wrap" };
const _hoisted_6$1 = { class: "el-date-picker__editor-wrap" };
const _hoisted_7$1 = { class: "el-picker-panel__content" };
const _hoisted_8$1 = { class: "el-picker-panel__footer" };
function render$3(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_input = vue.resolveComponent("el-input");
  const _component_time_pick_panel = vue.resolveComponent("time-pick-panel");
  const _component_date_table = vue.resolveComponent("date-table");
  const _component_year_table = vue.resolveComponent("year-table");
  const _component_month_table = vue.resolveComponent("month-table");
  const _component_el_button = vue.resolveComponent("el-button");
  const _directive_clickoutside = vue.resolveDirective("clickoutside");
  return vue.openBlock(), vue.createBlock("div", {
    class: ["el-picker-panel el-date-picker", [{
      "has-sidebar": _ctx.$slots.sidebar || _ctx.hasShortcuts,
      "has-time": _ctx.showTime
    }]]
  }, [
    vue.createVNode("div", _hoisted_1$3, [
      vue.renderSlot(_ctx.$slots, "sidebar", { class: "el-picker-panel__sidebar" }),
      _ctx.hasShortcuts ? (vue.openBlock(), vue.createBlock("div", _hoisted_2$1, [
        (vue.openBlock(true), vue.createBlock(vue.Fragment, null, vue.renderList(_ctx.shortcuts, (shortcut, key) => {
          return vue.openBlock(), vue.createBlock("button", {
            key,
            type: "button",
            class: "el-picker-panel__shortcut",
            onClick: ($event) => _ctx.handleShortcutClick(shortcut)
          }, vue.toDisplayString(shortcut.text), 9, ["onClick"]);
        }), 128))
      ])) : vue.createCommentVNode("v-if", true),
      vue.createVNode("div", _hoisted_3$1, [
        _ctx.showTime ? (vue.openBlock(), vue.createBlock("div", _hoisted_4$1, [
          vue.createVNode("span", _hoisted_5$1, [
            vue.createVNode(_component_el_input, {
              placeholder: _ctx.t("el.datepicker.selectDate"),
              "model-value": _ctx.visibleDate,
              size: "small",
              onInput: _cache[1] || (_cache[1] = (val) => _ctx.userInputDate = val),
              onChange: _ctx.handleVisibleDateChange
            }, null, 8, ["placeholder", "model-value", "onChange"])
          ]),
          vue.withDirectives(vue.createVNode("span", _hoisted_6$1, [
            vue.createVNode(_component_el_input, {
              placeholder: _ctx.t("el.datepicker.selectTime"),
              "model-value": _ctx.visibleTime,
              size: "small",
              onFocus: _ctx.onTimePickerInputFocus,
              onInput: _cache[2] || (_cache[2] = (val) => _ctx.userInputTime = val),
              onChange: _ctx.handleVisibleTimeChange
            }, null, 8, ["placeholder", "model-value", "onFocus", "onChange"]),
            vue.createVNode(_component_time_pick_panel, {
              visible: _ctx.timePickerVisible,
              format: _ctx.timeFormat,
              "time-arrow-control": _ctx.arrowControl,
              "parsed-value": _ctx.innerDate,
              onPick: _ctx.handleTimePick
            }, null, 8, ["visible", "format", "time-arrow-control", "parsed-value", "onPick"])
          ], 512), [
            [_directive_clickoutside, _ctx.handleTimePickClose]
          ])
        ])) : vue.createCommentVNode("v-if", true),
        vue.withDirectives(vue.createVNode("div", {
          class: ["el-date-picker__header", { "el-date-picker__header--bordered": _ctx.currentView === "year" || _ctx.currentView === "month" }]
        }, [
          vue.createVNode("button", {
            type: "button",
            "aria-label": _ctx.t(`el.datepicker.prevYear`),
            class: "el-picker-panel__icon-btn el-date-picker__prev-btn el-icon-d-arrow-left",
            onClick: _cache[3] || (_cache[3] = (...args) => _ctx.prevYear_ && _ctx.prevYear_(...args))
          }, null, 8, ["aria-label"]),
          vue.withDirectives(vue.createVNode("button", {
            type: "button",
            "aria-label": _ctx.t(`el.datepicker.prevMonth`),
            class: "el-picker-panel__icon-btn el-date-picker__prev-btn el-icon-arrow-left",
            onClick: _cache[4] || (_cache[4] = (...args) => _ctx.prevMonth_ && _ctx.prevMonth_(...args))
          }, null, 8, ["aria-label"]), [
            [vue.vShow, _ctx.currentView === "date"]
          ]),
          vue.createVNode("span", {
            role: "button",
            class: "el-date-picker__header-label",
            onClick: _cache[5] || (_cache[5] = (...args) => _ctx.showYearPicker && _ctx.showYearPicker(...args))
          }, vue.toDisplayString(_ctx.yearLabel), 1),
          vue.withDirectives(vue.createVNode("span", {
            role: "button",
            class: ["el-date-picker__header-label", { active: _ctx.currentView === "month" }],
            onClick: _cache[6] || (_cache[6] = (...args) => _ctx.showMonthPicker && _ctx.showMonthPicker(...args))
          }, vue.toDisplayString(_ctx.t(`el.datepicker.month${_ctx.month + 1}`)), 3), [
            [vue.vShow, _ctx.currentView === "date"]
          ]),
          vue.createVNode("button", {
            type: "button",
            "aria-label": _ctx.t(`el.datepicker.nextYear`),
            class: "el-picker-panel__icon-btn el-date-picker__next-btn el-icon-d-arrow-right",
            onClick: _cache[7] || (_cache[7] = (...args) => _ctx.nextYear_ && _ctx.nextYear_(...args))
          }, null, 8, ["aria-label"]),
          vue.withDirectives(vue.createVNode("button", {
            type: "button",
            "aria-label": _ctx.t(`el.datepicker.nextMonth`),
            class: "el-picker-panel__icon-btn el-date-picker__next-btn el-icon-arrow-right",
            onClick: _cache[8] || (_cache[8] = (...args) => _ctx.nextMonth_ && _ctx.nextMonth_(...args))
          }, null, 8, ["aria-label"]), [
            [vue.vShow, _ctx.currentView === "date"]
          ])
        ], 2), [
          [vue.vShow, _ctx.currentView !== "time"]
        ]),
        vue.createVNode("div", _hoisted_7$1, [
          _ctx.currentView === "date" ? (vue.openBlock(), vue.createBlock(_component_date_table, {
            key: 0,
            "selection-mode": _ctx.selectionMode,
            date: _ctx.innerDate,
            "parsed-value": _ctx.parsedValue,
            "disabled-date": _ctx.disabledDate,
            onPick: _ctx.handleDatePick
          }, null, 8, ["selection-mode", "date", "parsed-value", "disabled-date", "onPick"])) : vue.createCommentVNode("v-if", true),
          _ctx.currentView === "year" ? (vue.openBlock(), vue.createBlock(_component_year_table, {
            key: 1,
            date: _ctx.innerDate,
            "disabled-date": _ctx.disabledDate,
            "parsed-value": _ctx.parsedValue,
            onPick: _ctx.handleYearPick
          }, null, 8, ["date", "disabled-date", "parsed-value", "onPick"])) : vue.createCommentVNode("v-if", true),
          _ctx.currentView === "month" ? (vue.openBlock(), vue.createBlock(_component_month_table, {
            key: 2,
            date: _ctx.innerDate,
            "parsed-value": _ctx.parsedValue,
            "disabled-date": _ctx.disabledDate,
            onPick: _ctx.handleMonthPick
          }, null, 8, ["date", "parsed-value", "disabled-date", "onPick"])) : vue.createCommentVNode("v-if", true)
        ])
      ])
    ]),
    vue.withDirectives(vue.createVNode("div", _hoisted_8$1, [
      vue.withDirectives(vue.createVNode(_component_el_button, {
        size: "mini",
        type: "text",
        class: "el-picker-panel__link-btn",
        onClick: _ctx.changeToNow
      }, {
        default: vue.withCtx(() => [
          vue.createTextVNode(vue.toDisplayString(_ctx.t("el.datepicker.now")), 1)
        ]),
        _: 1
      }, 8, ["onClick"]), [
        [vue.vShow, _ctx.selectionMode !== "dates"]
      ]),
      vue.createVNode(_component_el_button, {
        plain: "",
        size: "mini",
        class: "el-picker-panel__link-btn",
        onClick: _ctx.onConfirm
      }, {
        default: vue.withCtx(() => [
          vue.createTextVNode(vue.toDisplayString(_ctx.t("el.datepicker.confirm")), 1)
        ]),
        _: 1
      }, 8, ["onClick"])
    ], 512), [
      [vue.vShow, _ctx.footerVisible && _ctx.currentView === "date"]
    ])
  ], 2);
}

script$3.render = render$3;
script$3.__file = "packages/date-picker/src/date-picker-com/panel-date-pick.vue";

var script$4 = vue.defineComponent({
  directives: { clickoutside: directives.ClickOutside },
  components: { TimePickPanel: timePicker.TimePickPanel, DateTable: script, ElInput: ElInput__default['default'], ElButton: ElButton__default['default'] },
  props: {
    unlinkPanels: Boolean,
    parsedValue: {
      type: Array
    },
    type: {
      type: String,
      required: true,
      validator: validators.isValidDatePickType
    }
  },
  emits: ["pick", "set-picker-option", "calendar-change"],
  setup(props, ctx) {
    const { t, lang } = hooks.useLocaleInject();
    const leftDate = vue.ref(dayjs__default['default']().locale(lang.value));
    const rightDate = vue.ref(dayjs__default['default']().locale(lang.value).add(1, "month"));
    const minDate = vue.ref(null);
    const maxDate = vue.ref(null);
    const dateUserInput = vue.ref({
      min: null,
      max: null
    });
    const timeUserInput = vue.ref({
      min: null,
      max: null
    });
    const leftLabel = vue.computed(() => {
      return leftDate.value.year() + " " + t("el.datepicker.year") + " " + t(`el.datepicker.month${leftDate.value.month() + 1}`);
    });
    const rightLabel = vue.computed(() => {
      return rightDate.value.year() + " " + t("el.datepicker.year") + " " + t(`el.datepicker.month${rightDate.value.month() + 1}`);
    });
    const leftYear = vue.computed(() => {
      return leftDate.value.year();
    });
    const leftMonth = vue.computed(() => {
      return leftDate.value.month();
    });
    const rightYear = vue.computed(() => {
      return rightDate.value.year();
    });
    const rightMonth = vue.computed(() => {
      return rightDate.value.month();
    });
    const hasShortcuts = vue.computed(() => !!shortcuts.length);
    const minVisibleDate = vue.computed(() => {
      if (dateUserInput.value.min !== null)
        return dateUserInput.value.min;
      if (minDate.value)
        return minDate.value.format(dateFormat.value);
      return "";
    });
    const maxVisibleDate = vue.computed(() => {
      if (dateUserInput.value.max !== null)
        return dateUserInput.value.max;
      if (maxDate.value || minDate.value)
        return (maxDate.value || minDate.value).format(dateFormat.value);
      return "";
    });
    const minVisibleTime = vue.computed(() => {
      if (timeUserInput.value.min !== null)
        return timeUserInput.value.min;
      if (minDate.value)
        return minDate.value.format(timeFormat.value);
      return "";
    });
    const maxVisibleTime = vue.computed(() => {
      if (timeUserInput.value.max !== null)
        return timeUserInput.value.max;
      if (maxDate.value || minDate.value)
        return (maxDate.value || minDate.value).format(timeFormat.value);
      return "";
    });
    const timeFormat = vue.computed(() => {
      return timePicker.extractTimeFormat(format);
    });
    const dateFormat = vue.computed(() => {
      return timePicker.extractDateFormat(format);
    });
    const leftPrevYear = () => {
      leftDate.value = leftDate.value.subtract(1, "year");
      if (!props.unlinkPanels) {
        rightDate.value = leftDate.value.add(1, "month");
      }
    };
    const leftPrevMonth = () => {
      leftDate.value = leftDate.value.subtract(1, "month");
      if (!props.unlinkPanels) {
        rightDate.value = leftDate.value.add(1, "month");
      }
    };
    const rightNextYear = () => {
      if (!props.unlinkPanels) {
        leftDate.value = leftDate.value.add(1, "year");
        rightDate.value = leftDate.value.add(1, "month");
      } else {
        rightDate.value = rightDate.value.add(1, "year");
      }
    };
    const rightNextMonth = () => {
      if (!props.unlinkPanels) {
        leftDate.value = leftDate.value.add(1, "month");
        rightDate.value = leftDate.value.add(1, "month");
      } else {
        rightDate.value = rightDate.value.add(1, "month");
      }
    };
    const leftNextYear = () => {
      leftDate.value = leftDate.value.add(1, "year");
    };
    const leftNextMonth = () => {
      leftDate.value = leftDate.value.add(1, "month");
    };
    const rightPrevYear = () => {
      rightDate.value = rightDate.value.subtract(1, "year");
    };
    const rightPrevMonth = () => {
      rightDate.value = rightDate.value.subtract(1, "month");
    };
    const enableMonthArrow = vue.computed(() => {
      const nextMonth = (leftMonth.value + 1) % 12;
      const yearOffset = leftMonth.value + 1 >= 12 ? 1 : 0;
      return props.unlinkPanels && new Date(leftYear.value + yearOffset, nextMonth) < new Date(rightYear.value, rightMonth.value);
    });
    const enableYearArrow = vue.computed(() => {
      return props.unlinkPanels && rightYear.value * 12 + rightMonth.value - (leftYear.value * 12 + leftMonth.value + 1) >= 12;
    });
    const isValidValue = (value) => {
      return Array.isArray(value) && value[0] && value[1] && value[0].valueOf() <= value[1].valueOf();
    };
    const rangeState = vue.ref({
      endDate: null,
      selecting: false
    });
    const btnDisabled = vue.computed(() => {
      return !(minDate.value && maxDate.value && !rangeState.value.selecting && isValidValue([minDate.value, maxDate.value]));
    });
    const handleChangeRange = (val) => {
      rangeState.value = val;
    };
    const onSelect = (selecting) => {
      rangeState.value.selecting = selecting;
      if (!selecting) {
        rangeState.value.endDate = null;
      }
    };
    const showTime = vue.computed(() => props.type === "datetime" || props.type === "datetimerange");
    const handleConfirm = (visible = false) => {
      if (isValidValue([minDate.value, maxDate.value])) {
        ctx.emit("pick", [minDate.value, maxDate.value], visible);
      }
    };
    const formatEmit = (emitDayjs, index) => {
      if (!emitDayjs)
        return;
      if (defaultTime) {
        const defaultTimeD = dayjs__default['default'](defaultTime[index] || defaultTime).locale(lang.value);
        return defaultTimeD.year(emitDayjs.year()).month(emitDayjs.month()).date(emitDayjs.date());
      }
      return emitDayjs;
    };
    const handleRangePick = (val, close = true) => {
      const min_ = val.minDate;
      const max_ = val.maxDate;
      const minDate_ = formatEmit(min_, 0);
      const maxDate_ = formatEmit(max_, 1);
      if (maxDate.value === maxDate_ && minDate.value === minDate_) {
        return;
      }
      ctx.emit("calendar-change", [min_.toDate(), max_ && max_.toDate()]);
      maxDate.value = maxDate_;
      minDate.value = minDate_;
      if (!close || showTime.value)
        return;
      handleConfirm();
    };
    const handleShortcutClick = (shortcut) => {
      const shortcutValues = typeof shortcut.value === "function" ? shortcut.value() : shortcut.value;
      if (shortcutValues) {
        ctx.emit("pick", [
          dayjs__default['default'](shortcutValues[0]).locale(lang.value),
          dayjs__default['default'](shortcutValues[1]).locale(lang.value)
        ]);
        return;
      }
      if (shortcut.onClick) {
        shortcut.onClick(ctx);
      }
    };
    const minTimePickerVisible = vue.ref(false);
    const maxTimePickerVisible = vue.ref(false);
    const handleMinTimeClose = () => {
      minTimePickerVisible.value = false;
    };
    const handleMaxTimeClose = () => {
      maxTimePickerVisible.value = false;
    };
    const handleDateInput = (value, type) => {
      dateUserInput.value[type] = value;
      const parsedValueD = dayjs__default['default'](value, dateFormat.value).locale(lang.value);
      if (parsedValueD.isValid()) {
        if (disabledDate && disabledDate(parsedValueD.toDate())) {
          return;
        }
        if (type === "min") {
          leftDate.value = parsedValueD;
          minDate.value = (minDate.value || leftDate.value).year(parsedValueD.year()).month(parsedValueD.month()).date(parsedValueD.date());
          if (!props.unlinkPanels) {
            rightDate.value = parsedValueD.add(1, "month");
            maxDate.value = minDate.value.add(1, "month");
          }
        } else {
          rightDate.value = parsedValueD;
          maxDate.value = (maxDate.value || rightDate.value).year(parsedValueD.year()).month(parsedValueD.month()).date(parsedValueD.date());
          if (!props.unlinkPanels) {
            leftDate.value = parsedValueD.subtract(1, "month");
            minDate.value = maxDate.value.subtract(1, "month");
          }
        }
      }
    };
    const handleDateChange = (_, type) => {
      dateUserInput.value[type] = null;
    };
    const handleTimeInput = (value, type) => {
      timeUserInput.value[type] = value;
      const parsedValueD = dayjs__default['default'](value, timeFormat.value).locale(lang.value);
      if (parsedValueD.isValid()) {
        if (type === "min") {
          minTimePickerVisible.value = true;
          minDate.value = (minDate.value || leftDate.value).hour(parsedValueD.hour()).minute(parsedValueD.minute()).second(parsedValueD.second());
          if (!maxDate.value || maxDate.value.isBefore(minDate.value)) {
            maxDate.value = minDate.value;
          }
        } else {
          maxTimePickerVisible.value = true;
          maxDate.value = (maxDate.value || rightDate.value).hour(parsedValueD.hour()).minute(parsedValueD.minute()).second(parsedValueD.second());
          rightDate.value = maxDate.value;
          if (maxDate.value && maxDate.value.isBefore(minDate.value)) {
            minDate.value = maxDate.value;
          }
        }
      }
    };
    const handleTimeChange = (value, type) => {
      timeUserInput.value[type] = null;
      if (type === "min") {
        leftDate.value = minDate.value;
        minTimePickerVisible.value = false;
      } else {
        rightDate.value = maxDate.value;
        maxTimePickerVisible.value = false;
      }
    };
    const handleMinTimePick = (value, visible, first) => {
      if (timeUserInput.value.min)
        return;
      if (value) {
        leftDate.value = value;
        minDate.value = (minDate.value || leftDate.value).hour(value.hour()).minute(value.minute()).second(value.second());
      }
      if (!first) {
        minTimePickerVisible.value = visible;
      }
      if (!maxDate.value || maxDate.value.isBefore(minDate.value)) {
        maxDate.value = minDate.value;
        rightDate.value = value;
      }
    };
    const handleMaxTimePick = (value, visible, first) => {
      if (timeUserInput.value.max)
        return;
      if (value) {
        rightDate.value = value;
        maxDate.value = (maxDate.value || rightDate.value).hour(value.hour()).minute(value.minute()).second(value.second());
      }
      if (!first) {
        maxTimePickerVisible.value = visible;
      }
      if (maxDate.value && maxDate.value.isBefore(minDate.value)) {
        minDate.value = maxDate.value;
      }
    };
    const handleClear = () => {
      leftDate.value = getDefaultValue()[0];
      rightDate.value = leftDate.value.add(1, "month");
      ctx.emit("pick", null);
    };
    const formatToString = (value) => {
      return Array.isArray(value) ? value.map((_) => _.format(format)) : value.format(format);
    };
    const parseUserInput = (value) => {
      return Array.isArray(value) ? value.map((_) => dayjs__default['default'](_, format).locale(lang.value)) : dayjs__default['default'](value, format).locale(lang.value);
    };
    const getDefaultValue = () => {
      let start;
      if (Array.isArray(defaultValue)) {
        const left = dayjs__default['default'](defaultValue[0]);
        let right = dayjs__default['default'](defaultValue[1]);
        if (!props.unlinkPanels) {
          right = left.add(1, "month");
        }
        return [left, right];
      } else if (defaultValue) {
        start = dayjs__default['default'](defaultValue);
      } else {
        start = dayjs__default['default']();
      }
      start = start.locale(lang.value);
      return [start, start.add(1, "month")];
    };
    ctx.emit("set-picker-option", ["isValidValue", isValidValue]);
    ctx.emit("set-picker-option", ["parseUserInput", parseUserInput]);
    ctx.emit("set-picker-option", ["formatToString", formatToString]);
    ctx.emit("set-picker-option", ["handleClear", handleClear]);
    const pickerBase = vue.inject("EP_PICKER_BASE");
    const {
      shortcuts,
      disabledDate,
      cellClassName,
      format,
      defaultTime,
      defaultValue,
      arrowControl,
      clearable
    } = pickerBase.props;
    vue.watch(() => props.parsedValue, (newVal) => {
      if (newVal && newVal.length === 2) {
        minDate.value = newVal[0];
        maxDate.value = newVal[1];
        leftDate.value = minDate.value;
        if (props.unlinkPanels && maxDate.value) {
          const minDateYear = minDate.value.year();
          const minDateMonth = minDate.value.month();
          const maxDateYear = maxDate.value.year();
          const maxDateMonth = maxDate.value.month();
          rightDate.value = minDateYear === maxDateYear && minDateMonth === maxDateMonth ? maxDate.value.add(1, "month") : maxDate.value;
        } else {
          rightDate.value = leftDate.value.add(1, "month");
          if (maxDate.value) {
            rightDate.value = rightDate.value.hour(maxDate.value.hour()).minute(maxDate.value.minute()).second(maxDate.value.second());
          }
        }
      } else {
        const defaultArr = getDefaultValue();
        minDate.value = null;
        maxDate.value = null;
        leftDate.value = defaultArr[0];
        rightDate.value = defaultArr[1];
      }
    }, { immediate: true });
    return {
      shortcuts,
      disabledDate,
      cellClassName,
      minTimePickerVisible,
      maxTimePickerVisible,
      handleMinTimeClose,
      handleMaxTimeClose,
      handleShortcutClick,
      rangeState,
      minDate,
      maxDate,
      handleRangePick,
      onSelect,
      handleChangeRange,
      btnDisabled,
      enableYearArrow,
      enableMonthArrow,
      rightPrevMonth,
      rightPrevYear,
      rightNextMonth,
      rightNextYear,
      leftPrevMonth,
      leftPrevYear,
      leftNextMonth,
      leftNextYear,
      hasShortcuts,
      leftLabel,
      rightLabel,
      leftDate,
      rightDate,
      showTime,
      t,
      minVisibleDate,
      maxVisibleDate,
      minVisibleTime,
      maxVisibleTime,
      arrowControl,
      handleDateInput,
      handleDateChange,
      handleTimeInput,
      handleTimeChange,
      handleMinTimePick,
      handleMaxTimePick,
      handleClear,
      handleConfirm,
      timeFormat,
      clearable
    };
  }
});

const _hoisted_1$4 = { class: "el-picker-panel__body-wrapper" };
const _hoisted_2$2 = {
  key: 0,
  class: "el-picker-panel__sidebar"
};
const _hoisted_3$2 = { class: "el-picker-panel__body" };
const _hoisted_4$2 = {
  key: 0,
  class: "el-date-range-picker__time-header"
};
const _hoisted_5$2 = { class: "el-date-range-picker__editors-wrap" };
const _hoisted_6$2 = { class: "el-date-range-picker__time-picker-wrap" };
const _hoisted_7$2 = { class: "el-date-range-picker__time-picker-wrap" };
const _hoisted_8$2 = /* @__PURE__ */ vue.createVNode("span", { class: "el-icon-arrow-right" }, null, -1);
const _hoisted_9$1 = { class: "el-date-range-picker__editors-wrap is-right" };
const _hoisted_10$1 = { class: "el-date-range-picker__time-picker-wrap" };
const _hoisted_11$1 = { class: "el-date-range-picker__time-picker-wrap" };
const _hoisted_12$1 = { class: "el-picker-panel__content el-date-range-picker__content is-left" };
const _hoisted_13 = { class: "el-date-range-picker__header" };
const _hoisted_14 = { class: "el-picker-panel__content el-date-range-picker__content is-right" };
const _hoisted_15 = { class: "el-date-range-picker__header" };
const _hoisted_16 = {
  key: 0,
  class: "el-picker-panel__footer"
};
function render$4(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_input = vue.resolveComponent("el-input");
  const _component_time_pick_panel = vue.resolveComponent("time-pick-panel");
  const _component_date_table = vue.resolveComponent("date-table");
  const _component_el_button = vue.resolveComponent("el-button");
  const _directive_clickoutside = vue.resolveDirective("clickoutside");
  return vue.openBlock(), vue.createBlock("div", {
    class: ["el-picker-panel el-date-range-picker", [{
      "has-sidebar": _ctx.$slots.sidebar || _ctx.hasShortcuts,
      "has-time": _ctx.showTime
    }]]
  }, [
    vue.createVNode("div", _hoisted_1$4, [
      vue.renderSlot(_ctx.$slots, "sidebar", { class: "el-picker-panel__sidebar" }),
      _ctx.hasShortcuts ? (vue.openBlock(), vue.createBlock("div", _hoisted_2$2, [
        (vue.openBlock(true), vue.createBlock(vue.Fragment, null, vue.renderList(_ctx.shortcuts, (shortcut, key) => {
          return vue.openBlock(), vue.createBlock("button", {
            key,
            type: "button",
            class: "el-picker-panel__shortcut",
            onClick: ($event) => _ctx.handleShortcutClick(shortcut)
          }, vue.toDisplayString(shortcut.text), 9, ["onClick"]);
        }), 128))
      ])) : vue.createCommentVNode("v-if", true),
      vue.createVNode("div", _hoisted_3$2, [
        _ctx.showTime ? (vue.openBlock(), vue.createBlock("div", _hoisted_4$2, [
          vue.createVNode("span", _hoisted_5$2, [
            vue.createVNode("span", _hoisted_6$2, [
              vue.createVNode(_component_el_input, {
                size: "small",
                disabled: _ctx.rangeState.selecting,
                placeholder: _ctx.t("el.datepicker.startDate"),
                class: "el-date-range-picker__editor",
                "model-value": _ctx.minVisibleDate,
                onInput: _cache[1] || (_cache[1] = (val) => _ctx.handleDateInput(val, "min")),
                onChange: _cache[2] || (_cache[2] = (val) => _ctx.handleDateChange(val, "min"))
              }, null, 8, ["disabled", "placeholder", "model-value"])
            ]),
            vue.withDirectives(vue.createVNode("span", _hoisted_7$2, [
              vue.createVNode(_component_el_input, {
                size: "small",
                class: "el-date-range-picker__editor",
                disabled: _ctx.rangeState.selecting,
                placeholder: _ctx.t("el.datepicker.startTime"),
                "model-value": _ctx.minVisibleTime,
                onFocus: _cache[3] || (_cache[3] = ($event) => _ctx.minTimePickerVisible = true),
                onInput: _cache[4] || (_cache[4] = (val) => _ctx.handleTimeInput(val, "min")),
                onChange: _cache[5] || (_cache[5] = (val) => _ctx.handleTimeChange(val, "min"))
              }, null, 8, ["disabled", "placeholder", "model-value"]),
              vue.createVNode(_component_time_pick_panel, {
                visible: _ctx.minTimePickerVisible,
                format: _ctx.timeFormat,
                "datetime-role": "start",
                "time-arrow-control": _ctx.arrowControl,
                "parsed-value": _ctx.leftDate,
                onPick: _ctx.handleMinTimePick
              }, null, 8, ["visible", "format", "time-arrow-control", "parsed-value", "onPick"])
            ], 512), [
              [_directive_clickoutside, _ctx.handleMinTimeClose]
            ])
          ]),
          _hoisted_8$2,
          vue.createVNode("span", _hoisted_9$1, [
            vue.createVNode("span", _hoisted_10$1, [
              vue.createVNode(_component_el_input, {
                size: "small",
                class: "el-date-range-picker__editor",
                disabled: _ctx.rangeState.selecting,
                placeholder: _ctx.t("el.datepicker.endDate"),
                "model-value": _ctx.maxVisibleDate,
                readonly: !_ctx.minDate,
                onInput: _cache[6] || (_cache[6] = (val) => _ctx.handleDateInput(val, "max")),
                onChange: _cache[7] || (_cache[7] = (val) => _ctx.handleDateChange(val, "max"))
              }, null, 8, ["disabled", "placeholder", "model-value", "readonly"])
            ]),
            vue.withDirectives(vue.createVNode("span", _hoisted_11$1, [
              vue.createVNode(_component_el_input, {
                size: "small",
                class: "el-date-range-picker__editor",
                disabled: _ctx.rangeState.selecting,
                placeholder: _ctx.t("el.datepicker.endTime"),
                "model-value": _ctx.maxVisibleTime,
                readonly: !_ctx.minDate,
                onFocus: _cache[8] || (_cache[8] = ($event) => _ctx.minDate && (_ctx.maxTimePickerVisible = true)),
                onInput: _cache[9] || (_cache[9] = (val) => _ctx.handleTimeInput(val, "max")),
                onChange: _cache[10] || (_cache[10] = (val) => _ctx.handleTimeChange(val, "max"))
              }, null, 8, ["disabled", "placeholder", "model-value", "readonly"]),
              vue.createVNode(_component_time_pick_panel, {
                "datetime-role": "end",
                visible: _ctx.maxTimePickerVisible,
                format: _ctx.timeFormat,
                "time-arrow-control": _ctx.arrowControl,
                "parsed-value": _ctx.rightDate,
                onPick: _ctx.handleMaxTimePick
              }, null, 8, ["visible", "format", "time-arrow-control", "parsed-value", "onPick"])
            ], 512), [
              [_directive_clickoutside, _ctx.handleMaxTimeClose]
            ])
          ])
        ])) : vue.createCommentVNode("v-if", true),
        vue.createVNode("div", _hoisted_12$1, [
          vue.createVNode("div", _hoisted_13, [
            vue.createVNode("button", {
              type: "button",
              class: "el-picker-panel__icon-btn el-icon-d-arrow-left",
              onClick: _cache[11] || (_cache[11] = (...args) => _ctx.leftPrevYear && _ctx.leftPrevYear(...args))
            }),
            vue.createVNode("button", {
              type: "button",
              class: "el-picker-panel__icon-btn el-icon-arrow-left",
              onClick: _cache[12] || (_cache[12] = (...args) => _ctx.leftPrevMonth && _ctx.leftPrevMonth(...args))
            }),
            _ctx.unlinkPanels ? (vue.openBlock(), vue.createBlock("button", {
              key: 0,
              type: "button",
              disabled: !_ctx.enableYearArrow,
              class: [{ "is-disabled": !_ctx.enableYearArrow }, "el-picker-panel__icon-btn el-icon-d-arrow-right"],
              onClick: _cache[13] || (_cache[13] = (...args) => _ctx.leftNextYear && _ctx.leftNextYear(...args))
            }, null, 10, ["disabled"])) : vue.createCommentVNode("v-if", true),
            _ctx.unlinkPanels ? (vue.openBlock(), vue.createBlock("button", {
              key: 1,
              type: "button",
              disabled: !_ctx.enableMonthArrow,
              class: [{ "is-disabled": !_ctx.enableMonthArrow }, "el-picker-panel__icon-btn el-icon-arrow-right"],
              onClick: _cache[14] || (_cache[14] = (...args) => _ctx.leftNextMonth && _ctx.leftNextMonth(...args))
            }, null, 10, ["disabled"])) : vue.createCommentVNode("v-if", true),
            vue.createVNode("div", null, vue.toDisplayString(_ctx.leftLabel), 1)
          ]),
          vue.createVNode(_component_date_table, {
            "selection-mode": "range",
            date: _ctx.leftDate,
            "min-date": _ctx.minDate,
            "max-date": _ctx.maxDate,
            "range-state": _ctx.rangeState,
            "disabled-date": _ctx.disabledDate,
            "cell-class-name": _ctx.cellClassName,
            onChangerange: _ctx.handleChangeRange,
            onPick: _ctx.handleRangePick,
            onSelect: _ctx.onSelect
          }, null, 8, ["date", "min-date", "max-date", "range-state", "disabled-date", "cell-class-name", "onChangerange", "onPick", "onSelect"])
        ]),
        vue.createVNode("div", _hoisted_14, [
          vue.createVNode("div", _hoisted_15, [
            _ctx.unlinkPanels ? (vue.openBlock(), vue.createBlock("button", {
              key: 0,
              type: "button",
              disabled: !_ctx.enableYearArrow,
              class: [{ "is-disabled": !_ctx.enableYearArrow }, "el-picker-panel__icon-btn el-icon-d-arrow-left"],
              onClick: _cache[15] || (_cache[15] = (...args) => _ctx.rightPrevYear && _ctx.rightPrevYear(...args))
            }, null, 10, ["disabled"])) : vue.createCommentVNode("v-if", true),
            _ctx.unlinkPanels ? (vue.openBlock(), vue.createBlock("button", {
              key: 1,
              type: "button",
              disabled: !_ctx.enableMonthArrow,
              class: [{ "is-disabled": !_ctx.enableMonthArrow }, "el-picker-panel__icon-btn el-icon-arrow-left"],
              onClick: _cache[16] || (_cache[16] = (...args) => _ctx.rightPrevMonth && _ctx.rightPrevMonth(...args))
            }, null, 10, ["disabled"])) : vue.createCommentVNode("v-if", true),
            vue.createVNode("button", {
              type: "button",
              class: "el-picker-panel__icon-btn el-icon-d-arrow-right",
              onClick: _cache[17] || (_cache[17] = (...args) => _ctx.rightNextYear && _ctx.rightNextYear(...args))
            }),
            vue.createVNode("button", {
              type: "button",
              class: "el-picker-panel__icon-btn el-icon-arrow-right",
              onClick: _cache[18] || (_cache[18] = (...args) => _ctx.rightNextMonth && _ctx.rightNextMonth(...args))
            }),
            vue.createVNode("div", null, vue.toDisplayString(_ctx.rightLabel), 1)
          ]),
          vue.createVNode(_component_date_table, {
            "selection-mode": "range",
            date: _ctx.rightDate,
            "min-date": _ctx.minDate,
            "max-date": _ctx.maxDate,
            "range-state": _ctx.rangeState,
            "disabled-date": _ctx.disabledDate,
            "cell-class-name": _ctx.cellClassName,
            onChangerange: _ctx.handleChangeRange,
            onPick: _ctx.handleRangePick,
            onSelect: _ctx.onSelect
          }, null, 8, ["date", "min-date", "max-date", "range-state", "disabled-date", "cell-class-name", "onChangerange", "onPick", "onSelect"])
        ])
      ])
    ]),
    _ctx.showTime ? (vue.openBlock(), vue.createBlock("div", _hoisted_16, [
      _ctx.clearable ? (vue.openBlock(), vue.createBlock(_component_el_button, {
        key: 0,
        size: "mini",
        type: "text",
        class: "el-picker-panel__link-btn",
        onClick: _ctx.handleClear
      }, {
        default: vue.withCtx(() => [
          vue.createTextVNode(vue.toDisplayString(_ctx.t("el.datepicker.clear")), 1)
        ]),
        _: 1
      }, 8, ["onClick"])) : vue.createCommentVNode("v-if", true),
      vue.createVNode(_component_el_button, {
        plain: "",
        size: "mini",
        class: "el-picker-panel__link-btn",
        disabled: _ctx.btnDisabled,
        onClick: _cache[19] || (_cache[19] = ($event) => _ctx.handleConfirm(false))
      }, {
        default: vue.withCtx(() => [
          vue.createTextVNode(vue.toDisplayString(_ctx.t("el.datepicker.confirm")), 1)
        ]),
        _: 1
      }, 8, ["disabled"])
    ])) : vue.createCommentVNode("v-if", true)
  ], 2);
}

script$4.render = render$4;
script$4.__file = "packages/date-picker/src/date-picker-com/panel-date-range.vue";

var script$5 = vue.defineComponent({
  components: { MonthTable: script$1 },
  props: {
    unlinkPanels: Boolean,
    parsedValue: {
      type: Array
    }
  },
  emits: ["pick", "set-picker-option"],
  setup(props, ctx) {
    const { t, lang } = hooks.useLocaleInject();
    const leftDate = vue.ref(dayjs__default['default']().locale(lang.value));
    const rightDate = vue.ref(dayjs__default['default']().locale(lang.value).add(1, "year"));
    const hasShortcuts = vue.computed(() => !!shortcuts.length);
    const handleShortcutClick = (shortcut) => {
      const shortcutValues = typeof shortcut.value === "function" ? shortcut.value() : shortcut.value;
      if (shortcutValues) {
        ctx.emit("pick", [
          dayjs__default['default'](shortcutValues[0]).locale(lang.value),
          dayjs__default['default'](shortcutValues[1]).locale(lang.value)
        ]);
        return;
      }
      if (shortcut.onClick) {
        shortcut.onClick(ctx);
      }
    };
    const leftPrevYear = () => {
      leftDate.value = leftDate.value.subtract(1, "year");
      if (!props.unlinkPanels) {
        rightDate.value = rightDate.value.subtract(1, "year");
      }
    };
    const rightNextYear = () => {
      if (!props.unlinkPanels) {
        leftDate.value = leftDate.value.add(1, "year");
      }
      rightDate.value = rightDate.value.add(1, "year");
    };
    const leftNextYear = () => {
      leftDate.value = leftDate.value.add(1, "year");
    };
    const rightPrevYear = () => {
      rightDate.value = rightDate.value.subtract(1, "year");
    };
    const leftLabel = vue.computed(() => {
      return `${leftDate.value.year()} ${t("el.datepicker.year")}`;
    });
    const rightLabel = vue.computed(() => {
      return `${rightDate.value.year()} ${t("el.datepicker.year")}`;
    });
    const leftYear = vue.computed(() => {
      return leftDate.value.year();
    });
    const rightYear = vue.computed(() => {
      return rightDate.value.year() === leftDate.value.year() ? leftDate.value.year() + 1 : rightDate.value.year();
    });
    const enableYearArrow = vue.computed(() => {
      return props.unlinkPanels && rightYear.value > leftYear.value + 1;
    });
    const minDate = vue.ref(null);
    const maxDate = vue.ref(null);
    const rangeState = vue.ref({
      endDate: null,
      selecting: false
    });
    const handleChangeRange = (val) => {
      rangeState.value = val;
    };
    const handleRangePick = (val, close = true) => {
      const minDate_ = val.minDate;
      const maxDate_ = val.maxDate;
      if (maxDate.value === maxDate_ && minDate.value === minDate_) {
        return;
      }
      maxDate.value = maxDate_;
      minDate.value = minDate_;
      if (!close)
        return;
      handleConfirm();
    };
    const isValidValue = (value) => {
      return Array.isArray(value) && value && value[0] && value[1] && value[0].valueOf() <= value[1].valueOf();
    };
    const handleConfirm = (visible = false) => {
      if (isValidValue([minDate.value, maxDate.value])) {
        ctx.emit("pick", [minDate.value, maxDate.value], visible);
      }
    };
    const onSelect = (selecting) => {
      rangeState.value.selecting = selecting;
      if (!selecting) {
        rangeState.value.endDate = null;
      }
    };
    const formatToString = (value) => {
      return value.map((_) => _.format(format));
    };
    const getDefaultValue = () => {
      let start;
      if (Array.isArray(defaultValue)) {
        const left = dayjs__default['default'](defaultValue[0]);
        let right = dayjs__default['default'](defaultValue[1]);
        if (!props.unlinkPanels) {
          right = left.add(1, "year");
        }
        return [left, right];
      } else if (defaultValue) {
        start = dayjs__default['default'](defaultValue);
      } else {
        start = dayjs__default['default']();
      }
      start = start.locale(lang.value);
      return [start, start.add(1, "year")];
    };
    ctx.emit("set-picker-option", ["formatToString", formatToString]);
    const pickerBase = vue.inject("EP_PICKER_BASE");
    const { shortcuts, disabledDate, format, defaultValue } = pickerBase.props;
    vue.watch(() => props.parsedValue, (newVal) => {
      if (newVal && newVal.length === 2) {
        minDate.value = newVal[0];
        maxDate.value = newVal[1];
        leftDate.value = minDate.value;
        if (props.unlinkPanels && maxDate.value) {
          const minDateYear = minDate.value.year();
          const maxDateYear = maxDate.value.year();
          rightDate.value = minDateYear === maxDateYear ? maxDate.value.add(1, "year") : maxDate.value;
        } else {
          rightDate.value = leftDate.value.add(1, "year");
        }
      } else {
        const defaultArr = getDefaultValue();
        leftDate.value = defaultArr[0];
        rightDate.value = defaultArr[1];
      }
    }, { immediate: true });
    return {
      shortcuts,
      disabledDate,
      onSelect,
      handleRangePick,
      rangeState,
      handleChangeRange,
      minDate,
      maxDate,
      enableYearArrow,
      leftLabel,
      rightLabel,
      leftNextYear,
      leftPrevYear,
      rightNextYear,
      rightPrevYear,
      t,
      leftDate,
      rightDate,
      hasShortcuts,
      handleShortcutClick
    };
  }
});

const _hoisted_1$5 = { class: "el-picker-panel__body-wrapper" };
const _hoisted_2$3 = {
  key: 0,
  class: "el-picker-panel__sidebar"
};
const _hoisted_3$3 = { class: "el-picker-panel__body" };
const _hoisted_4$3 = { class: "el-picker-panel__content el-date-range-picker__content is-left" };
const _hoisted_5$3 = { class: "el-date-range-picker__header" };
const _hoisted_6$3 = { class: "el-picker-panel__content el-date-range-picker__content is-right" };
const _hoisted_7$3 = { class: "el-date-range-picker__header" };
function render$5(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_month_table = vue.resolveComponent("month-table");
  return vue.openBlock(), vue.createBlock("div", {
    class: ["el-picker-panel el-date-range-picker", [{
      "has-sidebar": _ctx.$slots.sidebar || _ctx.hasShortcuts
    }]]
  }, [
    vue.createVNode("div", _hoisted_1$5, [
      vue.renderSlot(_ctx.$slots, "sidebar", { class: "el-picker-panel__sidebar" }),
      _ctx.hasShortcuts ? (vue.openBlock(), vue.createBlock("div", _hoisted_2$3, [
        (vue.openBlock(true), vue.createBlock(vue.Fragment, null, vue.renderList(_ctx.shortcuts, (shortcut, key) => {
          return vue.openBlock(), vue.createBlock("button", {
            key,
            type: "button",
            class: "el-picker-panel__shortcut",
            onClick: ($event) => _ctx.handleShortcutClick(shortcut)
          }, vue.toDisplayString(shortcut.text), 9, ["onClick"]);
        }), 128))
      ])) : vue.createCommentVNode("v-if", true),
      vue.createVNode("div", _hoisted_3$3, [
        vue.createVNode("div", _hoisted_4$3, [
          vue.createVNode("div", _hoisted_5$3, [
            vue.createVNode("button", {
              type: "button",
              class: "el-picker-panel__icon-btn el-icon-d-arrow-left",
              onClick: _cache[1] || (_cache[1] = (...args) => _ctx.leftPrevYear && _ctx.leftPrevYear(...args))
            }),
            _ctx.unlinkPanels ? (vue.openBlock(), vue.createBlock("button", {
              key: 0,
              type: "button",
              disabled: !_ctx.enableYearArrow,
              class: [{ "is-disabled": !_ctx.enableYearArrow }, "el-picker-panel__icon-btn el-icon-d-arrow-right"],
              onClick: _cache[2] || (_cache[2] = (...args) => _ctx.leftNextYear && _ctx.leftNextYear(...args))
            }, null, 10, ["disabled"])) : vue.createCommentVNode("v-if", true),
            vue.createVNode("div", null, vue.toDisplayString(_ctx.leftLabel), 1)
          ]),
          vue.createVNode(_component_month_table, {
            "selection-mode": "range",
            date: _ctx.leftDate,
            "min-date": _ctx.minDate,
            "max-date": _ctx.maxDate,
            "range-state": _ctx.rangeState,
            "disabled-date": _ctx.disabledDate,
            onChangerange: _ctx.handleChangeRange,
            onPick: _ctx.handleRangePick,
            onSelect: _ctx.onSelect
          }, null, 8, ["date", "min-date", "max-date", "range-state", "disabled-date", "onChangerange", "onPick", "onSelect"])
        ]),
        vue.createVNode("div", _hoisted_6$3, [
          vue.createVNode("div", _hoisted_7$3, [
            _ctx.unlinkPanels ? (vue.openBlock(), vue.createBlock("button", {
              key: 0,
              type: "button",
              disabled: !_ctx.enableYearArrow,
              class: [{ "is-disabled": !_ctx.enableYearArrow }, "el-picker-panel__icon-btn el-icon-d-arrow-left"],
              onClick: _cache[3] || (_cache[3] = (...args) => _ctx.rightPrevYear && _ctx.rightPrevYear(...args))
            }, null, 10, ["disabled"])) : vue.createCommentVNode("v-if", true),
            vue.createVNode("button", {
              type: "button",
              class: "el-picker-panel__icon-btn el-icon-d-arrow-right",
              onClick: _cache[4] || (_cache[4] = (...args) => _ctx.rightNextYear && _ctx.rightNextYear(...args))
            }),
            vue.createVNode("div", null, vue.toDisplayString(_ctx.rightLabel), 1)
          ]),
          vue.createVNode(_component_month_table, {
            "selection-mode": "range",
            date: _ctx.rightDate,
            "min-date": _ctx.minDate,
            "max-date": _ctx.maxDate,
            "range-state": _ctx.rangeState,
            "disabled-date": _ctx.disabledDate,
            onChangerange: _ctx.handleChangeRange,
            onPick: _ctx.handleRangePick,
            onSelect: _ctx.onSelect
          }, null, 8, ["date", "min-date", "max-date", "range-state", "disabled-date", "onChangerange", "onPick", "onSelect"])
        ])
      ])
    ])
  ], 2);
}

script$5.render = render$5;
script$5.__file = "packages/date-picker/src/date-picker-com/panel-month-range.vue";

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
dayjs__default['default'].extend(localeData__default['default']);
dayjs__default['default'].extend(advancedFormat__default['default']);
dayjs__default['default'].extend(customParseFormat__default['default']);
dayjs__default['default'].extend(weekOfYear__default['default']);
dayjs__default['default'].extend(weekYear__default['default']);
dayjs__default['default'].extend(dayOfYear__default['default']);
dayjs__default['default'].extend(isSameOrAfter__default['default']);
dayjs__default['default'].extend(isSameOrBefore__default['default']);
const getPanel = function(type) {
  if (type === "daterange" || type === "datetimerange") {
    return script$4;
  } else if (type === "monthrange") {
    return script$5;
  }
  return script$3;
};
var DatePicker = vue.defineComponent({
  name: "ElDatePicker",
  install: null,
  props: __spreadProps(__spreadValues({}, timePicker.defaultProps), {
    type: {
      type: String,
      default: "date"
    }
  }),
  emits: ["update:modelValue"],
  setup(props, ctx) {
    vue.provide("ElPopperOptions", props.popperOptions);
    const commonPicker = vue.ref(null);
    const refProps = __spreadProps(__spreadValues({}, props), {
      focus: () => {
        var _a;
        (_a = commonPicker.value) == null ? void 0 : _a.handleFocus();
      }
    });
    ctx.expose(refProps);
    return () => {
      var _a;
      const format = (_a = props.format) != null ? _a : timePicker.DEFAULT_FORMATS_DATEPICKER[props.type] || timePicker.DEFAULT_FORMATS_DATE;
      return vue.h(timePicker.CommonPicker, __spreadProps(__spreadValues({}, props), {
        format,
        type: props.type,
        ref: commonPicker,
        "onUpdate:modelValue": (value) => ctx.emit("update:modelValue", value)
      }), {
        default: (scopedProps) => vue.h(getPanel(props.type), scopedProps)
      });
    };
  }
});

const _DatePicker = DatePicker;
_DatePicker.install = (app) => {
  app.component(_DatePicker.name, _DatePicker);
};

exports.default = _DatePicker;
