import { defineComponent, openBlock, createBlock, createVNode, computed, renderSlot, resolveDynamicComponent, toDisplayString, createCommentVNode } from 'vue';

var script = defineComponent({
  name: "IconSuccess"
});

const _hoisted_1 = {
  viewBox: "0 0 48 48",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2 = /* @__PURE__ */ createVNode("path", { d: "M24,4 C35.045695,4 44,12.954305 44,24 C44,35.045695 35.045695,44 24,44 C12.954305,44 4,35.045695 4,24 C4,12.954305 12.954305,4 24,4 Z M34.5548098,16.4485711 C33.9612228,15.8504763 32.9988282,15.8504763 32.4052412,16.4485711 L32.4052412,16.4485711 L21.413757,27.5805811 L21.413757,27.5805811 L21.4034642,27.590855 C21.0097542,27.9781674 20.3766105,27.9729811 19.9892981,27.5792711 L19.9892981,27.5792711 L15.5947588,23.1121428 C15.0011718,22.514048 14.0387772,22.514048 13.4451902,23.1121428 C12.8516033,23.7102376 12.8516033,24.6799409 13.4451902,25.2780357 L13.4451902,25.2780357 L19.6260786,31.5514289 C20.2196656,32.1495237 21.1820602,32.1495237 21.7756472,31.5514289 L21.7756472,31.5514289 L34.5548098,18.614464 C35.1483967,18.0163692 35.1483967,17.0466659 34.5548098,16.4485711 Z" }, null, -1);
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock("svg", _hoisted_1, [
    _hoisted_2
  ]);
}

script.render = render;
script.__file = "packages/result/src/icon-success.vue";

var script$1 = defineComponent({
  name: "IconError"
});

const _hoisted_1$1 = {
  viewBox: "0 0 48 48",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$1 = /* @__PURE__ */ createVNode("path", { d: "M24,4 C35.045695,4 44,12.954305 44,24 C44,35.045695 35.045695,44 24,44 C12.954305,44 4,35.045695 4,24 C4,12.954305 12.954305,4 24,4 Z M32.57818,15.42182 C32.0157534,14.8593933 31.1038797,14.8593933 30.541453,15.42182 L30.541453,15.42182 L24.0006789,21.9625941 L17.458547,15.42182 C16.8961203,14.8593933 15.9842466,14.8593933 15.42182,15.42182 C14.8593933,15.9842466 14.8593933,16.8961203 15.42182,17.458547 L15.42182,17.458547 L21.9639519,23.9993211 L15.42182,30.541453 C14.8593933,31.1038797 14.8593933,32.0157534 15.42182,32.57818 C15.9842466,33.1406067 16.8961203,33.1406067 17.458547,32.57818 L17.458547,32.57818 L24.0006789,26.0360481 L30.541453,32.57818 C31.1038797,33.1406067 32.0157534,33.1406067 32.57818,32.57818 C33.1406067,32.0157534 33.1406067,31.1038797 32.57818,30.541453 L32.57818,30.541453 L26.0374059,23.9993211 L32.57818,17.458547 C33.1406067,16.8961203 33.1406067,15.9842466 32.57818,15.42182 Z" }, null, -1);
function render$1(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock("svg", _hoisted_1$1, [
    _hoisted_2$1
  ]);
}

script$1.render = render$1;
script$1.__file = "packages/result/src/icon-error.vue";

var script$2 = defineComponent({
  name: "IconWarning"
});

const _hoisted_1$2 = {
  viewBox: "0 0 48 48",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$2 = /* @__PURE__ */ createVNode("path", { d: "M24,4 C35.045695,4 44,12.954305 44,24 C44,35.045695 35.045695,44 24,44 C12.954305,44 4,35.045695 4,24 C4,12.954305 12.954305,4 24,4 Z M24,31 C22.8954305,31 22,31.8954305 22,33 C22,34.1045695 22.8954305,35 24,35 C25.1045695,35 26,34.1045695 26,33 C26,31.8954305 25.1045695,31 24,31 Z M24,14 C23.1715729,14 22.5,14.6715729 22.5,15.5 L22.5,15.5 L22.5,27.5 C22.5,28.3284271 23.1715729,29 24,29 C24.8284271,29 25.5,28.3284271 25.5,27.5 L25.5,27.5 L25.5,15.5 C25.5,14.6715729 24.8284271,14 24,14 Z" }, null, -1);
function render$2(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock("svg", _hoisted_1$2, [
    _hoisted_2$2
  ]);
}

script$2.render = render$2;
script$2.__file = "packages/result/src/icon-warning.vue";

var script$3 = defineComponent({
  name: "IconInfo"
});

const _hoisted_1$3 = {
  viewBox: "0 0 48 48",
  xmlns: "http://www.w3.org/2000/svg"
};
const _hoisted_2$3 = /* @__PURE__ */ createVNode("path", { d: "M24,4 C35.045695,4 44,12.954305 44,24 C44,35.045695 35.045695,44 24,44 C12.954305,44 4,35.045695 4,24 C4,12.954305 12.954305,4 24,4 Z M24,19 L21,19 C20.1715729,19 19.5,19.6715729 19.5,20.5 C19.5,21.3284271 20.1715729,22 21,22 L21,22 L22.5,22 L22.5,31 L21,31 C20.1715729,31 19.5,31.6715729 19.5,32.5 C19.5,33.3284271 20.1715729,34 21,34 L21,34 L27,34 C27.8284271,34 28.5,33.3284271 28.5,32.5 C28.5,31.6715729 27.8284271,31 27,31 L27,31 L25.5,31 L25.5,20.5 C25.5,19.6715729 24.8284271,19 24,19 L24,19 Z M24,13 C22.8954305,13 22,13.8954305 22,15 C22,16.1045695 22.8954305,17 24,17 C25.1045695,17 26,16.1045695 26,15 C26,13.8954305 25.1045695,13 24,13 Z" }, null, -1);
function render$3(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock("svg", _hoisted_1$3, [
    _hoisted_2$3
  ]);
}

script$3.render = render$3;
script$3.__file = "packages/result/src/icon-info.vue";

const IconMap = {
  success: "icon-success",
  warning: "icon-warning",
  error: "icon-error",
  info: "icon-info"
};
var script$4 = defineComponent({
  name: "ElResult",
  components: {
    [script.name]: script,
    [script$1.name]: script$1,
    [script$2.name]: script$2,
    [script$3.name]: script$3
  },
  props: {
    title: {
      type: String,
      default: ""
    },
    subTitle: {
      type: String,
      default: ""
    },
    icon: {
      type: String,
      default: "info"
    }
  },
  setup(props) {
    const iconElement = computed(() => {
      const icon = props.icon;
      return icon && IconMap[icon] ? IconMap[icon] : "icon-info";
    });
    return {
      iconElement
    };
  }
});

const _hoisted_1$4 = { class: "el-result" };
const _hoisted_2$4 = { class: "el-result__icon" };
const _hoisted_3 = {
  key: 0,
  class: "el-result__title"
};
const _hoisted_4 = {
  key: 1,
  class: "el-result__subtitle"
};
const _hoisted_5 = {
  key: 2,
  class: "el-result__extra"
};
function render$4(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createBlock("div", _hoisted_1$4, [
    createVNode("div", _hoisted_2$4, [
      renderSlot(_ctx.$slots, "icon", {}, () => [
        (openBlock(), createBlock(resolveDynamicComponent(_ctx.iconElement), { class: _ctx.iconElement }, null, 8, ["class"]))
      ])
    ]),
    _ctx.title || _ctx.$slots.title ? (openBlock(), createBlock("div", _hoisted_3, [
      renderSlot(_ctx.$slots, "title", {}, () => [
        createVNode("p", null, toDisplayString(_ctx.title), 1)
      ])
    ])) : createCommentVNode("v-if", true),
    _ctx.subTitle || _ctx.$slots.subTitle ? (openBlock(), createBlock("div", _hoisted_4, [
      renderSlot(_ctx.$slots, "subTitle", {}, () => [
        createVNode("p", null, toDisplayString(_ctx.subTitle), 1)
      ])
    ])) : createCommentVNode("v-if", true),
    _ctx.$slots.extra ? (openBlock(), createBlock("div", _hoisted_5, [
      renderSlot(_ctx.$slots, "extra")
    ])) : createCommentVNode("v-if", true)
  ]);
}

script$4.render = render$4;
script$4.__file = "packages/result/src/index.vue";

script$4.install = (app) => {
  app.component(script$4.name, script$4);
};
const _Result = script$4;

export default _Result;
