import { defineComponent, ref, computed, resolveComponent, openBlock, createBlock, withCtx, renderSlot, createVNode, createCommentVNode, createTextVNode, toDisplayString } from 'vue';
import ElButton from '../el-button';
import ElPopper from '../el-popper';
import { useLocaleInject } from '../hooks';

var script = defineComponent({
  name: "ElPopconfirm",
  components: {
    ElButton,
    ElPopper
  },
  props: {
    title: {
      type: String
    },
    confirmButtonText: {
      type: String
    },
    cancelButtonText: {
      type: String
    },
    confirmButtonType: {
      type: String,
      default: "primary"
    },
    cancelButtonType: {
      type: String,
      default: "text"
    },
    icon: {
      type: String,
      default: "el-icon-question"
    },
    iconColor: {
      type: String,
      default: "#f90"
    },
    hideIcon: {
      type: Boolean,
      default: false
    }
  },
  emits: ["confirm", "cancel"],
  setup(props, { emit }) {
    const { t } = useLocaleInject();
    const visible = ref(false);
    const confirm = () => {
      visible.value = false;
      emit("confirm");
    };
    const cancel = () => {
      visible.value = false;
      emit("cancel");
    };
    const confirmButtonText_ = computed(() => {
      return props.confirmButtonText || t("el.popconfirm.confirmButtonText");
    });
    const cancelButtonText_ = computed(() => {
      return props.cancelButtonText || t("el.popconfirm.cancelButtonText");
    });
    return {
      visible,
      confirm,
      cancel,
      confirmButtonText_,
      cancelButtonText_
    };
  }
});

const _hoisted_1 = { class: "el-popconfirm" };
const _hoisted_2 = { class: "el-popconfirm__main" };
const _hoisted_3 = { class: "el-popconfirm__action" };
function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_button = resolveComponent("el-button");
  const _component_el_popper = resolveComponent("el-popper");
  return openBlock(), createBlock(_component_el_popper, {
    visible: _ctx.visible,
    "onUpdate:visible": _cache[1] || (_cache[1] = ($event) => _ctx.visible = $event),
    trigger: "click",
    effect: "light",
    "popper-class": "el-popover",
    "append-to-body": "",
    "fallback-placements": ["bottom", "top", "right", "left"]
  }, {
    trigger: withCtx(() => [
      renderSlot(_ctx.$slots, "reference")
    ]),
    default: withCtx(() => [
      createVNode("div", _hoisted_1, [
        createVNode("p", _hoisted_2, [
          !_ctx.hideIcon ? (openBlock(), createBlock("i", {
            key: 0,
            class: [_ctx.icon, "el-popconfirm__icon"],
            style: { color: _ctx.iconColor }
          }, null, 6)) : createCommentVNode("v-if", true),
          createTextVNode(" " + toDisplayString(_ctx.title), 1)
        ]),
        createVNode("div", _hoisted_3, [
          createVNode(_component_el_button, {
            size: "mini",
            type: _ctx.cancelButtonType,
            onClick: _ctx.cancel
          }, {
            default: withCtx(() => [
              createTextVNode(toDisplayString(_ctx.cancelButtonText_), 1)
            ]),
            _: 1
          }, 8, ["type", "onClick"]),
          createVNode(_component_el_button, {
            size: "mini",
            type: _ctx.confirmButtonType,
            onClick: _ctx.confirm
          }, {
            default: withCtx(() => [
              createTextVNode(toDisplayString(_ctx.confirmButtonText_), 1)
            ]),
            _: 1
          }, 8, ["type", "onClick"])
        ])
      ])
    ]),
    _: 1
  }, 8, ["visible"]);
}

script.render = render;
script.__file = "packages/popconfirm/src/index.vue";

script.install = (app) => {
  app.component(script.name, script);
};
const _Popconfirm = script;

export default _Popconfirm;
