import req from "@/request.js";
const portal = window.context.portal;
const headersUrlencoded = {
    'Content-type': 'application/x-www-form-urlencoded',
}
export default {
    //天气查询
    queryWeather() {
        return new Promise((resolve, reject) => {
            req.get(`/weatherAPI/v3/weather/weatherInfo?key=7a6aed8691c887482beeee3f53911685&city=500116&extensions=base`)
                .then(
                    res => {
                        resolve(res)
                    },
                    error => {
                        reject(error)
                    })
                .catch(err => {
                    reject(err)
                });
        })
    },
    //  首页------------------------------------
    // 车道数据
    queryLaneData(data) {
        return new Promise((resolve, reject) => {
            req.request({
                data: data,
                method: 'post',
                headers: headersUrlencoded,
                url: portal + "/bizCharge/v1/query4",
            }).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                })
                .catch(err => {
                    reject(err)
                });
        })
    },

    // 通行费车流量
    getChargeAndCarFlow(data) {
        return new Promise((resolve, reject) => {
            req.request({
                data: data,
                method: 'post',
                headers: headersUrlencoded,
                url: portal + "/bizCharge/v1/query1",
            }).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                })
                .catch(err => {
                    reject(err)
                });
        })
    },
    // 车道数量
    getLaneData(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + "/bizLane/v1/queryAmonut", data)
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    })
                .catch(err => {
                    reject(err)
                });
        })
    },
    //交易成功率
    getSuccessRate(data) {
        return new Promise((resolve, reject) => {
            req.request({
                data: data,
                method: 'post',
                headers: headersUrlencoded,
                url: portal + "/bizCharge/v1/query2",
            }).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                })
                .catch(err => {
                    reject(err)
                });
        })
    },
    // 车辆类型
    getCarTypeData(data) {
        return new Promise((resolve, reject) => {
            req.request({
                data: data,
                method: 'post',
                headers: headersUrlencoded,
                url: portal + "/bizCharge/v1/query3",
            }).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                })
                .catch(err => {
                    reject(err)
                });
        })
    },
    // 设备状态
    getDeviceStatus(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + "/bizDevice/v1/queryAmonut", data)
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    })
                .catch(err => {
                    reject(err)
                });
        })
    },
    // 设备列表
    getDeviceList(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + "/bizDevice/v1/page", data)
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    })
                .catch(err => {
                    reject(err)
                });
        })
    },
    // 设备统计
    getDeviceData(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + "/bizDevice/v1/queryDeviceAmonut", data)
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    })
                .catch(err => {
                    reject(err)
                });
        })
    },
    // 车道运行情况
    getLaneState(data) {
        return new Promise((resolve, reject) => {
            req.request({
                data: data,
                method: 'post',
                headers: headersUrlencoded,
                url: portal + "/bizLane/v1/queryStatus",
            }).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                })
                .catch(err => {
                    reject(err)
                });
        })
    },
    // 设备运行情况
    getDeviceFaultData(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + "/bizHitchLog/v1/page", data)
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    })
                .catch(err => {
                    reject(err)
                });
        })
    },
    //  首页------------------------------------
    //  运营收费--------------------------------
    // 收费数据 通行数据
    getChargeTotal(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + "/bizCharge/v1/queryChargeTotal", data)
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    })
                .catch(err => {
                    reject(err)
                });
        })
    },
    // 通行费同比
    getToll(data) {
        return new Promise((resolve, reject) => {
            req.request({
                data: data,
                method: 'post',
                headers: headersUrlencoded,
                url: portal + "/bizCharge/v1/queryToll",
            }).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                })
                .catch(err => {
                    reject(err)
                });
        })
    },
    // 车流量同比
    getCarFlow(data) {
        return new Promise((resolve, reject) => {
            req.request({
                data: data,
                method: 'post',
                headers: headersUrlencoded,
                url: portal + "/bizCharge/v1/queryCarFlow",
            }).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                })
                .catch(err => {
                    reject(err)
                });
        })
    },
    // 减免通行费
    getReduction(data) {
        return new Promise((resolve, reject) => {
            req.request({
                data: data,
                method: 'post',
                headers: headersUrlencoded,
                url: portal + "/bizCharge/v1/queryReduction",
            }).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                })
                .catch(err => {
                    reject(err)
                });
        })
    },
    // 今年通行费
    getAmonutCurrent() {
        return new Promise((resolve, reject) => {
            req.post(portal + "/bizCharge/v1/queryAmonutCurrent")
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    })
                .catch(err => {
                    reject(err)
                });
        })
    },
    // 去年通行费
    getAmonutLast() {
        return new Promise((resolve, reject) => {
            req.post(portal + "/bizCharge/v1/queryAmonutLast")
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    })
                .catch(err => {
                    reject(err)
                });
        })
    },
    //车辆记录
    getCarList(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + "/bizCharge/v1/page", data)
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    })
                .catch(err => {
                    reject(err)
                });
        })
    },

    // 车辆通行统计
    getCarTypeList(data) {
        return new Promise((resolve, reject) => {
            req.request({
                data: data,
                method: 'post',
                headers: headersUrlencoded,
                url: portal + "/bizCharge/v1/queryCar",
            }).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                })
                .catch(err => {
                    reject(err)
                });
        })
    },
    // 收费方式
    getPayType(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + "/bizCharge/v1/queryPay", data)
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    })
                .catch(err => {
                    reject(err)
                });
        })
    },


    // 门架识别率
    getRecognitionRate(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + "/bizGantryRecognitionRate/v1/queryRate", data)
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    })
                .catch(err => {
                    reject(err)
                });
        })
    },
    //  运营收费--------------------------------


    //  设备监控------------------------------------

    // 设备统计
    getDeviceAmonut(data) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + '/bizDevice/v1/queryDeviceAmonut', data)
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 设备系统分布
    getDeviceBySystem(stationId, data) {
        return new Promise((resolve, reject) => {
            req
                .post(
                    portal + '/bizDevice/v1/queryDeviceBySystem?stationId=' + stationId,
                    data
                )
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 设备类型
    getDeviceByType(stationId, data) {
        return new Promise((resolve, reject) => {
            req
                .post(
                    portal + '/bizDevice/v1/queryDeviceByType?stationId=' + stationId,
                    data
                )
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 设备率
    getDeviceRate(stationId, data) {
        return new Promise((resolve, reject) => {
            req
                .post(
                    portal + '/bizDevice/v1/queryDeviceRate?stationId=' + stationId,
                    data
                )
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 故障统计
    gethitchStatistics(stationId, data) {
        return new Promise((resolve, reject) => {
            req
                .post(
                    portal + '/bizHitchLog/v1/hitchStatistics?stationId=' + stationId,
                    data
                )
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 故障分析
    gethitchRepair(stationId, data) {
        return new Promise((resolve, reject) => {
            req
                .post(
                    portal + '/bizHitchLog/v1/hitchRepair?stationId=' + stationId,
                    data
                )
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 故障维修情况
    gethitchAnalysis(stationId, data) {
        return new Promise((resolve, reject) => {
            req
                .post(
                    portal + '/bizHitchLog/v1/hitchAnalysis?stationId=' + stationId,
                    data
                )
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 预警信息
    getWarnInfo(data) {
        return new Promise((resolve, reject) => {
            req
                .post(
                    portal + '/bizDeviceWarnInfo/v1/pageAll',
                    data
                )
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 巡检动态追踪
    getInspectLog(stationId, data) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + '/bizInspectLog/v1/page?stationId=' + stationId, data)
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 设备状态
    getDeviceStatus() {
        return new Promise((resolve, reject) => {
            req
                .post(portal + '/bizDevice/v1/page', {
                    pageBean: {
                        page: 1,
                        pageSize: -1
                    },
                })
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 设备故障排名
    getHitchLog(tollStationId) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + '/bizHitchLog/v1/queryHitchLogRank', {
                    pageBean: {
                        page: 1,
                        pageSize: -1
                    }, querys: [
                        {
                            group: 'main',
                            operation: 'EQUAL',
                            parentGroup: '',
                            property: 'toll_station_id_',
                            relation: 'AND',
                            value: tollStationId
                        }
                    ]
                })
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 故障平均处理时间
    getHandleTime(tollStationId) {
        return new Promise((resolve, reject) => {
            req
                .post(portal + '/bizHitchLog/v1/queryHitchLogHandleTime', {
                    page: -1, querys: [
                        {
                            group: 'main',
                            operation: 'EQUAL',
                            parentGroup: '',
                            property: 'toll_station_id_',
                            relation: 'AND',
                            value: tollStationId
                        }
                    ]
                })
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    //  it资源--------------------------------
    // 获取TOPcpu使用率
    getCpu(data) {
        return new Promise((resolve, reject) => {
            req
                .request({
                    data: data,
                    method: 'post',
                    headers: headersUrlencoded,
                    url: portal + '/bizItsourceData/v1/getCpuUseTop'
                })
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // it资源数量表统计
    getItSoutceCount(stationId, data) {
        return new Promise((resolve, reject) => {
            req
                .post(
                    portal +
                    '/bizItsourceData/v1/getItSoutceCount?stationId=' +
                    stationId,
                    data
                )
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 总物理机CPU使用率
    getPmCPURate(data) {
        return new Promise((resolve, reject) => {
            req
                .request({
                    data: data,
                    method: 'post',
                    headers: headersUrlencoded,
                    url: portal + '/bizItsourceData/v1/getPmCPURate'
                })
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 总物理机负载内存
    getPmRamRate(data) {
        return new Promise((resolve, reject) => {
            req
                .request({
                    data: data,
                    method: 'post',
                    headers: headersUrlencoded,
                    url: portal + '/bizItsourceData/v1/getPmRamRate'
                })
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 总物理机磁盘io
    getPhysicalMdIo(data) {
        return new Promise((resolve, reject) => {
            req
                .request({
                    data: data,
                    method: 'post',
                    headers: headersUrlencoded,
                    url: portal + '/bizItsourceData/v1/getPhysicalMdIo'
                })
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 主云机cpu使用率
    getVmCPURate(data) {
        return new Promise((resolve, reject) => {
            req
                .request({
                    data: data,
                    method: 'post',
                    headers: headersUrlencoded,
                    url: portal + '/bizItsourceData/v1/getVmCPURate'
                })
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 云主机cpu内存负载
    getVmRamRate(data) {
        return new Promise((resolve, reject) => {
            req
                .request({
                    data: data,
                    method: 'post',
                    headers: headersUrlencoded,
                    url: portal + '/bizItsourceData/v1/getVmRamRate'
                })
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    },
    // 网络吞吐量
    getNetworkThroughput(data) {
        return new Promise((resolve, reject) => {
            req
                .request({
                    data: data,
                    method: 'post',
                    headers: headersUrlencoded,
                    url: portal + '/bizItsourceData/v1/getNetworkThroughput'
                })
                .then(
                    res => {
                        resolve(res.data)
                    },
                    error => {
                        reject(error)
                    }
                )
                .catch(err => {
                    reject(err)
                })
        })
    }
}