package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

@Getter
public enum WarnLevelEnum {
    JJ("1", "警戒"),

    WX("2", "危险"),
    ;

    WarnLevelEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        WarnLevelEnum[] values = values();
        for (WarnLevelEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }

}
