package com.artfess.base.enums;

import lombok.Getter;

/**
 * 河道水位预警等级
 */
@Getter
public enum HdWarnGradeEnum {
    /**
     *
     */
    JZ(1, "警戒"),

    BZ(2, "保证"),

    FH(3, "防洪"),

    ZG(4, "历史最高洪水"),
    ;

    HdWarnGradeEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private Integer type;

    private String desc;

    public static String getDesc(Integer type){
        if(null == type){
            return null;
        }
        HdWarnGradeEnum[] values = values();
        for (HdWarnGradeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }

}
