package com.artfess.base.feign;

import com.artfess.base.conf.FeignConfig;
import com.artfess.base.feign.impl.ApplicationFeignServiceFactory;
import com.artfess.base.jms.Notice;
import com.artfess.base.model.CommonResult;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.http.client.ClientProtocolException;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @author css
 */
@FeignClient(name = "bpm-application", fallbackFactory = ApplicationFeignServiceFactory.class, configuration = FeignConfig.class, primary = false)
public interface ApplicationFeignService {

    /**
     * 发送消息
     *
     * @param notice
     * @return
     * @throws ClientProtocolException
     * @throws IOException
     */
    @RequestMapping(value = "/jms/v1/sendNoticeToQueue", method = RequestMethod.POST)
    public CommonResult<String> sendNoticeToQueue(@RequestBody(required = true) Notice notice);

    /**
     * 发送消息到队列中
     *
     * @param model
     * @return
     * @throws ClientProtocolException
     * @throws IOException
     */
    @RequestMapping(value = "/jms/v1/sendToQueue", method = RequestMethod.POST)
    public CommonResult<String> sendToQueue(@RequestBody(required = true) ObjectNode model);

    /**
     * 获取用户已读未读消息
     *
     * @param account
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/msg/messageReceiver/v1/getMessBoxInfo", method = RequestMethod.GET)
    public ObjectNode getMessBoxInfo(@RequestParam(value = "account", required = true) String account);

    @RequestMapping(value = "/logs/sysLogsSettings/v1/getSysLogsSettingStatusMap", method = RequestMethod.GET)
    public Map<String, String> getSysLogsSettingStatusMap();

    @RequestMapping(value = "/integrate/sysExternalUnite/v1/getToken", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    public String getToken(@RequestParam(value = "type", required = true) String type);

    @RequestMapping(value = "/integrate/sysExternalUnite/v1/getUserInfoUrl", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    public String getUserInfoUrl(@RequestParam(value = "type", required = true) String type, @RequestParam(value = "code", required = true) String code);

    @RequestMapping(value = "/integrate/sysExternalUnite/v1/getUserInfoForYkz", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    public String getUserInfoForYkz(@RequestParam(value = "authCode", required = true) String authCode);

}
