import req from '@/request.js'
const portal = window.context.portal
export default {
	// 添加
	addData(data, cb) {
		req.post(portal + `/qf/invest/parent/`, data).then(res => {
			cb(res.data)
		})
	},
	//修改
	editData(data, cb) {
		req.put(portal + `/qf/invest/parent/detail/batchUpdate`, data).then(res => {
			cb(res.data)
		})
	},
	//删除
	delDate(ids, cb) {
		req.remove(portal + `/qf/invest/parent/?ids=` + ids).then(res => {
			cb(res.data)
		})
	},
	//查询
	pageQuery(data, cb) {
		req.post(portal + `/qf/invest/parent/query`, data).then(res => {
			cb(res.data)
		})
	},

	// id查询
	detailId(id, cb) {
		req.get(portal + `/qf/invest/parent/` + id).then(rep => {
			cb(rep.data)
		})
	},
	//修改状态
	editStatus(data, cb) {
		req.put(portal + `/qf/invest/parent/updateStatus`, data).then(res => {
			cb(res.data)
		})
	},
	//导入
	importExcel(data, cb) {
		req.post(portal + `/qf/invest/parent/importExcel`, data).then(res => {
			cb(res.data)
		})
	},
	//导出
	export (data, cb) {
		req.post(portal + `/qf/invest/parent/export`, data,'blob').then(res => {
			cb(res.data)
		})
	},
	/*二级页面*/
	//批量添加
	saveData(data, cb) {
		req.post(portal + `/qf/invest/parent/detail/batchSave`, data).then(res => {
			cb(res.data)
		})
	},
	//表格查询
	detailQuery(data, cb) {
		req.post(portal + `/qf/invest/parent/detail/query`, data).then(res => {
			cb(res.data)
		})
	},
	//批量删除
	dleDetail(ids, cb) {
		req.remove(portal + `/qf/invest/parent/detail/?ids=` + ids).then(res => {
			cb(res.data)
		})
	},

}
