import req from "@/request.js";

const portal = window.context.portal;
export default {
    //分页
    getGroupList(data, cb) {
        req.post(portal + `/fill/bizSpecialGroup/v1/queryPageList`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 新增
    addGroup(data, cb) {
        req.post(portal + `/fill/bizSpecialGroup/v1/saveOrUpdateEntity`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 根据id查询详情
    getInfoById(id, cb) {
        req.post(portal + `/fill/bizSpecialGroup/v1/findById/${id}`).then(rep => {
            cb(rep.data);
        });
    },
    // 根据id删除数据
    deleteById(id, cb) {
        req.post(portal + `/fill/bizSpecialGroup/v1/deleteEntity/${id}`).then(rep => {
            cb(rep.data);
        });
    },
    getRoleList(data) {
        return new Promise((resolve) => {
            req.post(portal + `/api/role/v1/roles/getRolePage`, data).then(rep => {
                resolve(rep.data);
            });
        })

    }
}
