import req from '@/request.js'
import { data } from 'jquery'
const portal = window.context.portal
export default {
    // 加快实施项目查询
    queryDataImplement(data, isAffirm) {
        return new Promise((resolve) => {
            req.post(portal + `/majorProjects/municipalMajorProjectManagement/v1/queryProgress?isAffirm=${isAffirm}`, data).then(res => {
                resolve(res.data)
            })
        })
    },
    // 附件删除
    removeFile(id) {
        return new Promise((resolve) => {
            req.request(
                {
                    url: portal + `/file/v1/remove`,
                    method: 'post',
                    data: id,
                    headers: {
                        "Content-Type": 'application/json'
                    }
                }).then(res => {
                    resolve(res.data)
                })
        })
    },
    // 保存更新报告
    saveReport(data) {
        return new Promise((resolve) => {
            req.post(portal + `/majorProjects/bizMunicipalMajorProjectReport/v1/`, data).then(res => {
                resolve(res.data)
            })
        })
    },
    // 根据项目id 查询项目报告
    queryReportByProjectId(data) {
        return new Promise((resolve) => {
            req.post(portal + `/majorProjects/bizMunicipalMajorProjectReport/v1/findByProjectId`, data).then(res => {
                resolve(res.data)
            })
        })
    },
    // 根据报告id查询详情
    queryReportById(id) {
        return new Promise((resolve) => {
            req.get(portal + `/majorProjects/bizMunicipalMajorProjectReport/v1/` + id).then(res => {
                resolve(res.data)
            })
        })
    },
    // 根据id修改审核状态
    updateStatus(data) {
        return new Promise((resolve) => {
            req.post(portal + `/majorProjects/bizMunicipalMajorProjectReport/v1/updateById`, data).then(res => {
                resolve(res.data)
            })
        })
    },
    // 根据id批量删除
    deleteByIds(ids) {
        return new Promise((resolve) => {
            req.post(portal + `/majorProjects/bizMunicipalMajorProjectReport/v1/removeByIds?ids=${ids}`, data).then(res => {
                resolve(res.data)
            })
        })
    },
    // 两个一批项目查询
    twoBatchProject(data, isAffirm) {
        return new Promise((resolve) => {
            req.post(portal + `/bizMunicipalNotSatrtProjectManagement/v1/queryProgress?isAffirm=${isAffirm}`, data).then(res => {
                resolve(res.data)
            })
        })
    },

    // 加快实施一批附件批量导出
    exportImplementFiles(data) {
        return new Promise((resolve) => {
            req.downloadPostCopy(portal + `/majorProjects/bizMunicipalMajorProjectReport/v1/speedProjectReport`, data).then(res => {
                resolve(res.data)
            })
        })
    },
    // 两个一批附件批量导出
    twoBatchExport(data) {
        return new Promise((resolve) => {
            req.downloadPostCopy(portal + `/majorProjects/bizMunicipalMajorProjectReport/v1/notStartProjectReport`, data).then(res => {
                resolve(res.data)
            })
        })
    }
}