package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.sysConfig.persistence.dao.SysActuatorDao;
import com.artfess.sysConfig.persistence.manager.SysActuatorManager;
import com.artfess.sysConfig.persistence.model.SysActuator;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/**
 * @Program: edp
 * @Date: 2021/3/2
 * @Author: ZQF
 * @Description: 任务执行器信息
 */
@Service
public class SysActuatorManagerImpl extends BaseManagerImpl<SysActuatorDao, SysActuator> implements SysActuatorManager {

    @Resource
    private SysActuatorDao sysActuatorDao;

    @Override
    @Transactional
    public String saveSysActuator(SysActuator sysActuator) {
        Assert.notNull(sysActuator, "任务执行器信息不能为空！");
        String msg = "";
        // 验证数据的合法性
        this.checkValidity(sysActuator);
        if (StringUtils.isNotBlank(sysActuator.getId())) { // 更新
            this.update(sysActuator);
            msg = "更新成功";
        } else { // 新增
            sysActuator.setSn(this.getNextSequence(null));
            sysActuator.setFlag(1);
            this.create(sysActuator);
            msg = "新增成功";
        }
        return msg;
    }

    @Override
    @Transactional
    public String updateSequence(HashMap<String, Object> params) {
        Assert.notNull(params, "参数不能为空！");
        for (String key : params.keySet()) {
            UpdateWrapper<SysActuator> updateWrapper = new UpdateWrapper<>();
            updateWrapper.set("SN_",params.get(key)).eq("ID_",key);
            this.update(updateWrapper);
        }
        return "排序完成";
    }

    @Override
    @Transactional
    public void updateFlag(String ids, Integer flag) {
        List<String> idsList = Arrays.asList(ids.split(","));
        UpdateWrapper<SysActuator> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("FLAG_", flag).in("ID_", idsList);
        this.sysActuatorDao.update(null, updateWrapper);
    }

    @Override
    @Transactional
    public void deleteBatch(String ids) {
        Assert.hasText(ids, "参数ids不能为空！");
        List<String> idsList = Arrays.asList(ids.split(","));
//        this.sysActuatorDao.deleteBatchIds(idsList);
        UpdateWrapper<SysActuator> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("IS_DELE_", "1").in("ID_", idsList);
        this.sysActuatorDao.update(null, updateWrapper);
    }

    @Override
    public List<SysActuator> queryActuator(SysActuator sysActuator) {
        QueryWrapper<SysActuator> queryWrapper = new QueryWrapper<>();
        queryWrapper.like(StringUtils.isNotBlank(sysActuator.getActuatorName()), "ACTUATOR_NAME_", sysActuator.getActuatorName());
        queryWrapper.like(StringUtils.isNotBlank(sysActuator.getActuatorIp()), "ACTUATOR_IP_", sysActuator.getActuatorIp());
        queryWrapper.eq("FLAG_", 1);
        queryWrapper.eq("IS_DELE_", 1);
        queryWrapper.orderByAsc("SN_");
        return this.sysActuatorDao.selectList(queryWrapper);
    }


    /**
    * @Description: 验证数据的合法性
    * @Param: sysActuator  
    * @Return: void
    * @Author: ZQF 
    * @Date: 2021/3/2 
    */
    private void checkValidity(SysActuator sysActuator) {
        QueryWrapper<SysActuator> queryWrapper = new QueryWrapper<>();
        queryWrapper.ne(StringUtils.isNotBlank(sysActuator.getId()), "ID_", sysActuator.getId());
        queryWrapper.nested(qw->qw.eq("ACTUATOR_NAME_", sysActuator.getActuatorName())
                .or()
                .eq("EXECUTION_PATH_", sysActuator.getExecutionPath())
                ).eq("IS_DELE_", "0");
        Integer count = this.sysActuatorDao.selectCount(queryWrapper);
        if (count > 0) {
            throw new ApplicationException("名称或执行路径已存在，请检查后尝试！");
        }
    }
}
