package com.artfess.ljzc.stock.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.ljzc.stock.manager.AssetStockInfoManager;
import com.artfess.ljzc.stock.model.AssetStockInfo;
import com.artfess.ljzc.stock.vo.AssetStockInfoVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import org.springframework.web.multipart.MultipartFile;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 股权资产信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2023-11-27
 */
@Api(tags = "股权资产信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RestController
@RequestMapping("/biz/stock/stockInfo/v1/")
public class AssetStockInfoController extends BaseController<AssetStockInfoManager, AssetStockInfo> {

    @PostMapping(value="/queryPageStockInfoAuthority", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询股权资产")
    public PageList<AssetStockInfo> queryPageCompanyAuthority(@RequestBody QueryFilter<AssetStockInfo> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            queryFilter.addFilter("belongs_org_full_id_",ContextUtil.getCurrentOrgFullId(), QueryOP.RIGHT_LIKE);
        }
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("belongs_org_id_", Direction.ASC));
        queryFilter.setSorter(sorter);
        return baseService.query(queryFilter);
    }

    @PostMapping("/insertStockInfo")
    @ApiOperation("保存股权资产")
    public CommonResult<String> insertStockInfo(@ApiParam(name = "model", value = "实体信息")  @RequestBody AssetStockInfoVo assetStockInfoVo) throws Exception {
        String id = this.baseService.insertStockInfo(assetStockInfoVo);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<String>(true,"保存成功！",id);
    }

    @PostMapping("/updateStockInfo")
    @ApiOperation("修改股权资产")
    public CommonResult<String> updateStockInfo(@ApiParam(name = "model", value = "实体信息")  @RequestBody AssetStockInfoVo assetStockInfoVo) throws Exception {
        boolean result = baseService.updateStockInfo(assetStockInfoVo);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/deleteStockInfo")
    @ApiOperation("删除股权资产")
    public CommonResult<String> deleteStockInfo(@ApiParam(name="id", value="id") @RequestParam String id) {
        boolean result = baseService.deleteStockInfo(id);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/deleteBachStockInfo")
    @ApiOperation("批量删除股权资产")
    public CommonResult<String> deleteBachStockInfo(@ApiParam(name="ids", value="ids") @RequestParam String... ids) {
        boolean result = baseService.deleteBachStockInfo(Arrays.asList(ids));
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/findById")
    @ApiOperation(value = "根据id查询股权资产")
    public AssetStockInfoVo findById(@RequestParam(name = "id",required = true) String id) {
        AssetStockInfoVo stockInfoVo =baseService.findStockInfoVo(id);
        return stockInfoVo;
    }

    @PostMapping("/auditStock")
    @ApiOperation(value = "审核股权资产入库")
    public CommonResult<String> auditStock(@ApiParam(name = "status", value = "入库审核状态（0：未审核，1：已审核）")@RequestParam String status,
                                           @ApiParam(name = "msg", value = "审核意见")@RequestParam String msg,
                                           @ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = baseService.auditStock(status,msg,Arrays.asList(ids));
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "审核失败");
        }
        return new CommonResult<>();
    }

    @PostMapping(value="/queryStockStructures", produces={"application/json; charset=utf-8" })
    @ApiOperation("查询股权关系图谱")
    public Map<String,Object> queryStockStructures(@ApiParam(name = "orgId", value = "企业ID")@RequestParam String orgId,@ApiParam(name = "orgName", value = "企业名称")@RequestParam String orgName) {
        Map<String,Object> map = baseService.queryStockStructures(orgId,orgName);
        return map;
    }
}
