package com.artfess.ljzc.welfare.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 公益资产权属信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@TableName("biz_asset_public_warrents")
@ApiModel(value="BizAssetPublicWarrents对象", description="公益资产权属信息")
public class AssetPublicWarrents extends AutoFillFullModel<AssetPublicWarrents> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "公益资产ID")
    @TableField("public_id_")
    private String publicId;

    @ApiModelProperty(value = "是否获取权属信息(0：未获取1：已获取)")
    @TableField("is_get_warrents_")
    private String isGetWarrents;

    @ApiModelProperty(value = "未获取原因")
    @TableField("warrents_reason_")
    private String warrentsReason;

    @ApiModelProperty(value = "权证号")
    @TableField("warrents_no_")
    private String warrentsNo;

    @ApiModelProperty(value = "权属单位ID")
    @TableField("warrents_org_id_")
    private String warrentsOrgId;

    @ApiModelProperty(value = "权属单位")
    @TableField("warrents_org_name_")
    private String warrentsOrgName;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("is_dele_")
    @TableLogic
    private String isDele = "0";

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPublicId() {
        return publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public String getIsGetWarrents() {
        return isGetWarrents;
    }

    public void setIsGetWarrents(String isGetWarrents) {
        this.isGetWarrents = isGetWarrents;
    }

    public String getWarrentsReason() {
        return warrentsReason;
    }

    public void setWarrentsReason(String warrentsReason) {
        this.warrentsReason = warrentsReason;
    }

    public String getWarrentsNo() {
        return warrentsNo;
    }

    public void setWarrentsNo(String warrentsNo) {
        this.warrentsNo = warrentsNo;
    }



    public String getWarrentsOrgId() {
        return warrentsOrgId;
    }

    public void setWarrentsOrgId(String warrentsOrgId) {
        this.warrentsOrgId = warrentsOrgId;
    }

    public String getWarrentsOrgName() {
        return warrentsOrgName;
    }

    public void setWarrentsOrgName(String warrentsOrgName) {
        this.warrentsOrgName = warrentsOrgName;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAssetPublicWarrents{" +
            "id=" + id +
            ", publicId=" + publicId +
            ", isGetWarrents=" + isGetWarrents +
            ", warrentsReason=" + warrentsReason +
            ", warrentsNo=" + warrentsNo +
            ", warrentsOrgId=" + warrentsOrgId +
            ", warrentsOrgName=" + warrentsOrgName +
            ", isDele=" + isDele +
            ", tenantId=" + tenantId +
        "}";
    }
}
