package com.artfess.ljzc.welfare.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 公益资产信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
@TableName("Biz_Asset_Pubilc_Info")
@ApiModel(value="BizAssetPubilcInfo对象", description="公益资产信息")
public class AssetPubilcInfo extends AutoFillFullModel<AssetPubilcInfo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "资产名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "资产编号")
    @TableField("code_")
    private String code;

    @ApiModelProperty(value = "资产详细地址")
    @TableField("address_")
    private String address;

    @ApiModelProperty(value = "项目所在行政区划代码")
    @TableField("addvcd_")
    private String addvcd;

    @ApiModelProperty(value = "项目所在行政区划名称")
    @TableField("addvcd_name_")
    private String addvcdName;

    @ApiModelProperty(value = "资产经度")
    @TableField("longitude_")
    private String longitude;

    @ApiModelProperty(value = "资产经度")
    @TableField("latitude_")
    private String latitude;

    @ApiModelProperty(value = "资产地图范围")
    @TableField("map_")
    private String map;

    @ApiModelProperty(value = "资产类型（字典：具备经营价值，不具备经营价值）")
    @TableField("asset_type_")
    private String assetType;

    @ApiModelProperty(value = "资产业态（字典：公园，公共文体设施（场馆、展览馆等），安置房，停车场，划线车位，交通基础设施，市政基础设施，教育设施，行政设施，医疗设施，水利基础设施）")
    @TableField("asset_business_")
    private String assetBusiness;

    @ApiModelProperty(value = "资产来源（字典：自建，购买，划拨，置换，出让）")
    @TableField("asset_src_")
    private String assetSrc;

    @ApiModelProperty(value = "所属单位ID")
    @TableField("belongs_org_id_")
    private String belongsOrgId;

    @ApiModelProperty(value = "所属单位")
    @TableField("belongs_org_name_")
    private String belongsOrgName;

    @ApiModelProperty(value = "所属单位fullid")
    @TableField("belongs_org_full_id_")
    private String belongsOrgFullId;

    @ApiModelProperty(value = "是否移交(0：未移交1：已移交)")
    @TableField("is_move_")
    private String isMove;

    @ApiModelProperty(value = "未移交原因")
    @TableField("move_reason_")
    private String moveReason;

    @ApiModelProperty(value = "资产管理单位名称")
    @TableField("management_unit_")
    private String managementUnit;

    @ApiModelProperty(value = "资产规模（已确定的数量）")
    @TableField("confirm_size_")
    private BigDecimal confirmSize;

    @ApiModelProperty(value = "未确权规模")
    @TableField("unconfirm_size_")
    private BigDecimal unconfirmSize;

    @ApiModelProperty(value = "规模数量单位（字典：）")
    @TableField("unit_")
    private BigDecimal unit;

    @ApiModelProperty(value = "规划总投资（万元）")
    @TableField("invest_plan_")
    private BigDecimal investPlan;

    @ApiModelProperty(value = "完成投资（万元）")
    @TableField("invest_over_")
    private BigDecimal investOver;

    @ApiModelProperty(value = "是否代建（字典：0：否，1：是）")
    @TableField("is_deputy_")
    private String isDeputy;

    @ApiModelProperty(value = "套数（针对：安置房）")
    @TableField("house_num_")
    private Integer houseNum;

    @ApiModelProperty(value = "账面价值（元）")
    @TableField("book_value_")
    private BigDecimal bookValue;

    @ApiModelProperty(value = "资产审核状态（0：未审核，1：已审核）")
    @TableField("asset_audit_")
    private String assetAudit;

    @ApiModelProperty(value = "备注")
    @TableField("remark_")
    private String remark;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("is_dele_")
    @TableLogic
    private String isDele = "0";

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;


    @ApiModelProperty(value = " 公益资产使用信息")
    @TableField(exist = false)
    private List<AssetPublicUse>  assetPublicUse;

    @ApiModelProperty(value = " 公益资产产权信息")
    @TableField(exist = false)
    private List<AssetPublicWarrents>  assetPublicWarrents;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddvcd() {
        return addvcd;
    }

    public void setAddvcd(String addvcd) {
        this.addvcd = addvcd;
    }

    public String getAddvcdName() {
        return addvcdName;
    }

    public void setAddvcdName(String addvcdName) {
        this.addvcdName = addvcdName;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getMap() {
        return map;
    }

    public void setMap(String map) {
        this.map = map;
    }

    public String getAssetType() {
        return assetType;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    public String getAssetBusiness() {
        return assetBusiness;
    }

    public void setAssetBusiness(String assetBusiness) {
        this.assetBusiness = assetBusiness;
    }

    public String getAssetSrc() {
        return assetSrc;
    }

    public void setAssetSrc(String assetSrc) {
        this.assetSrc = assetSrc;
    }

    public String getBelongsOrgId() {
        return belongsOrgId;
    }

    public void setBelongsOrgId(String belongsOrgId) {
        this.belongsOrgId = belongsOrgId;
    }

    public String getBelongsOrgName() {
        return belongsOrgName;
    }

    public void setBelongsOrgName(String belongsOrgName) {
        this.belongsOrgName = belongsOrgName;
    }

    public String getBelongsOrgFullId() {
        return belongsOrgFullId;
    }

    public void setBelongsOrgFullId(String belongsOrgFullId) {
        this.belongsOrgFullId = belongsOrgFullId;
    }

    public String getIsMove() {
        return isMove;
    }

    public void setIsMove(String isMove) {
        this.isMove = isMove;
    }

    public String getMoveReason() {
        return moveReason;
    }

    public void setMoveReason(String moveReason) {
        this.moveReason = moveReason;
    }

    public String getManagementUnit() {
        return managementUnit;
    }

    public void setManagementUnit(String managementUnit) {
        this.managementUnit = managementUnit;
    }

    public BigDecimal getConfirmSize() {
        return confirmSize;
    }

    public void setConfirmSize(BigDecimal confirmSize) {
        this.confirmSize = confirmSize;
    }

    public BigDecimal getUnconfirmSize() {
        return unconfirmSize;
    }

    public void setUnconfirmSize(BigDecimal unconfirmSize) {
        this.unconfirmSize = unconfirmSize;
    }

    public BigDecimal getUnit() {
        return unit;
    }

    public void setUnit(BigDecimal unit) {
        this.unit = unit;
    }

    public BigDecimal getInvestPlan() {
        return investPlan;
    }

    public void setInvestPlan(BigDecimal investPlan) {
        this.investPlan = investPlan;
    }

    public BigDecimal getInvestOver() {
        return investOver;
    }

    public void setInvestOver(BigDecimal investOver) {
        this.investOver = investOver;
    }

    public String getIsDeputy() {
        return isDeputy;
    }

    public void setIsDeputy(String isDeputy) {
        this.isDeputy = isDeputy;
    }

    public Integer getHouseNum() {
        return houseNum;
    }

    public void setHouseNum(Integer houseNum) {
        this.houseNum = houseNum;
    }

    public BigDecimal getBookValue() {
        return bookValue;
    }

    public void setBookValue(BigDecimal bookValue) {
        this.bookValue = bookValue;
    }

    public String getAssetAudit() {
        return assetAudit;
    }

    public void setAssetAudit(String assetAudit) {
        this.assetAudit = assetAudit;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }


    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public List<AssetPublicUse> getAssetPublicUse() {
        return assetPublicUse;
    }

    public void setAssetPublicUse(List<AssetPublicUse> assetPublicUse) {
        this.assetPublicUse = assetPublicUse;
    }

    public List<AssetPublicWarrents> getAssetPublicWarrents() {
        return assetPublicWarrents;
    }

    public void setAssetPublicWarrents(List<AssetPublicWarrents> assetPublicWarrents) {
        this.assetPublicWarrents = assetPublicWarrents;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAssetPubilcInfo{" +
            "id=" + id +
            ", name=" + name +
            ", code=" + code +
            ", address=" + address +
            ", addvcd=" + addvcd +
            ", addvcdName=" + addvcdName +
            ", longitude=" + longitude +
            ", latitude=" + latitude +
            ", map=" + map +
            ", assetType=" + assetType +
            ", assetBusiness=" + assetBusiness +
            ", assetSrc=" + assetSrc +
            ", belongsOrgId=" + belongsOrgId +
            ", belongsOrgName=" + belongsOrgName +
            ", belongsOrgFullId=" + belongsOrgFullId +
            ", isMove=" + isMove +
            ", moveReason=" + moveReason +
            ", managementUnit=" + managementUnit +
            ", confirmSize=" + confirmSize +
            ", unconfirmSize=" + unconfirmSize +
            ", unit=" + unit +
            ", investPlan=" + investPlan +
            ", investOver=" + investOver +
            ", isDeputy=" + isDeputy +
            ", houseNum=" + houseNum +
            ", bookValue=" + bookValue +
            ", assetAudit=" + assetAudit +
            ", remark=" + remark +
            ", isDele=" + isDele +
            ", tenantId=" + tenantId +
        "}";
    }
}
