package com.artfess.ljzc.business.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.vo.TreeVo;
import com.artfess.ljzc.business.dao.BizAssetBusinessBuildingDao;
import com.artfess.ljzc.business.manager.BizAssetBusinessBuildingManager;
import com.artfess.ljzc.business.model.BizAssetBusinessBuilding;
import com.artfess.ljzc.business.vo.ProjectTreeVo;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 经营性资产的楼栋信息 服务实现类
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-11-27
 */
@Service
public class BizAssetBusinessBuildingManagerImpl extends BaseManagerImpl<BizAssetBusinessBuildingDao, BizAssetBusinessBuilding> implements BizAssetBusinessBuildingManager {

    @Override
    public PageList<BizAssetBusinessBuilding> findByPage(QueryFilter<BizAssetBusinessBuilding> queryFilter) {
        queryFilter.addFilter("b.is_dele_", DelStatusEnum.N.getType(), QueryOP.EQUAL);
        PageBean pageBean = queryFilter.getPageBean();
        Class<BizAssetBusinessBuilding> currentModelClass = currentModelClass();
        IPage<BizAssetBusinessBuilding> result = baseMapper.findByPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass));
        return new PageList<BizAssetBusinessBuilding>(result);
    }

    @Override
    public List<ProjectTreeVo> projectAndBuildingTree() {
        String fullId = ContextUtil.getCurrentOrgFullId() + "%";
        return BeanUtils.listToTree(this.baseMapper.projectAndBuildingTree(fullId));
    }
}
