package com.artfess.ljzc.business.dao;

import com.alibaba.fastjson.JSONObject;
import com.artfess.ljzc.business.model.BizAssetBusinessInfo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 经营性资产的基础信息 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-11-27
 */
public interface BizAssetBusinessInfoDao extends BaseMapper<BizAssetBusinessInfo> {

    IPage<BizAssetBusinessInfo> findByPage(IPage<BizAssetBusinessInfo> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizAssetBusinessInfo> convert2Wrapper);

    BigDecimal bookValue(@Param("fullId") String fullId);

    List<JSONObject> businessStatistics(@Param("fullId") String fullId);

    List<JSONObject> assetStatusList(@Param("fullId") String fullId);

    JSONObject gatherStatistics(@Param("fullId") String fullId);

    List<JSONObject> sourceStatistics(@Param("fullId") String fullId);

    List<JSONObject> statusStatistics(@Param("fullId") String fullId);

    List<JSONObject> operationStatistics(@Param("fullId") String fullId);

    List<JSONObject> typeStatistics(@Param("fullId") String fullId);

    List<JSONObject> belongStatistics(@Param("fullId") String fullId);

    List<JSONObject> natureStatistics(@Param("fullId") String fullId);
}
