/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.kh.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.portal.kh.manager.KhSchemeManager;
import com.artfess.portal.kh.model.KhScheme;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7ee9\u6548\u8003\u6838-\u8003\u6838\u65b9\u6848\u4fe1\u606f"})
@RequestMapping(value={"/kh/scheme/"})
@ApiGroup(group={"group_system"})
public class KhSchemeController
extends BaseController<KhSchemeManager, KhScheme> {
    private static final Logger log = LoggerFactory.getLogger(KhSchemeController.class);

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) KhScheme t) {
        boolean result = ((KhSchemeManager)this.baseService).createInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) KhScheme t) {
        boolean result = ((KhSchemeManager)this.baseService).updateInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public KhScheme getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((KhSchemeManager)this.baseService).findById(id);
    }

    @GetMapping(value={"/discard"})
    @ApiOperation(value="\u5e9f\u5f03")
    public CommonResult<String> discard(String ... ids) {
        boolean result = ((KhSchemeManager)this.baseService).updateStatus(Arrays.asList(ids), "-1");
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5e9f\u5f03\u5931\u8d25");
        }
        return new CommonResult();
    }

    @GetMapping(value={"/startUse"})
    @ApiOperation(value="\u542f\u7528")
    public CommonResult<String> startUse(String ... ids) {
        boolean result = ((KhSchemeManager)this.baseService).updateStatus(Arrays.asList(ids), "1");
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u542f\u7528\u5931\u8d25");
        }
        return new CommonResult();
    }
}

