import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '企业名称',
            prop: 'supplierName',
            type: 'input',
            span: 4,
            value: ''
        },
    ]
    const columnsList: COption[] = [
        {
            title: '企业名称',
            prop: 'enterpriseName',
            minWidth: 200,
            sortable: true
        },
        {
            title: '统一社会信用代码',
            prop: 'creditCode',
            minWidth: 180,
            sortable: true
        },
        {
            title: '法定代表人',
            prop: 'legalRepresentative',
            minWidth: 120,
            sortable: true
        },
        {
            title: '注册日期',
            prop: 'establishmentTime',
            minWidth: 120,
            sortable: true
        },
        {
            title: '有效期至',
            prop: 'endBusinessTerm',
            minWidth: 120,
            render:true,
            sortable: true
        },
        {
            title: '注册资金(万元)',
            prop: 'registeredAmount',
            minWidth: 120,
            sortable: true
        },
        {
            title: '注册地址',
            prop: 'address',
            minWidth: 160,
            sortable: true
        },
        {
            title: '经营范围',
            prop: 'businessScope',
            minWidth: 200,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
