import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        {
            title: '联系人',
            prop: 'companyContact',
            type: 'input',
            value: ''
        },
        {
            title: '联系电话',
            prop: 'contactTel',
            type: 'input',
            value: ''
        },
        {
            title: '注册日期',
            prop: 'companyRegdate',
            type: 'date',
            dateOption: {
                type: 'daterange',
                format: 'YYYY-MM-DD',
                valueFormat: 'YYYY-MM-DD'
            },
            span: 6,
            value: []
        },
        {
            title: '签署状态',
            prop: 'auditStatus',
            type: 'select',
            multiple: true,
            options: getDictionaryByCode('qyxyqszt'),
            value: []
        }
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '供应的企业名称',
            prop: 'gyqyName',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '供应商等级',
            prop: 'gydj',
            type: 'select',
            multiple: true,
            options: [
                { name: '企业', value: '0' },
                { name: '个人', value: '1' }
            ],
            value: [],
            span: 4
        },
        {
            title: '供应商类型',
            prop: 'gylx',
            type: 'select',
            multiple: true,
            options: [
                { name: 'B类', value: '1' },
                { name: 'C类', value: '2' }
            ],
            value: [],
            span: 4
        },
        {
            title: '申请时间',
            prop: 'createTime',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 6,
            value: []
        }
    ]
    const columnsList: COption[] = [
        {
            title: '供应的企业',
            prop: 'gyqy',
            minWidth: 160,
            sortable: true
        },
        {
            title: '供应商等级',
            prop: 'gydj',
            minWidth: 120,
            sortable: true
        },
        {
            title: '供应商类型',
            prop: 'gylx',
            minWidth: 120,
            sortable: true
        },
        {
            title: '综合评分',
            prop: 'zhpj',
            minWidth: 160,
            sortable: true,
            render: true
        },
        {
            title: '申请时间',
            prop: 'sqsj',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
