package com.artfess.bpm.engine.inst;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.constant.TaskType;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeManager;
import com.artfess.bpm.persistence.model.*;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.service.IUserService;
import org.springframework.stereotype.Service;

import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.api.constant.CopyToType;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.service.BpmCopyToService;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.manager.CopyToManager;
import com.artfess.uc.api.model.IUser;

@Service
public class DefaultBpmCopyToService implements BpmCopyToService{

	
	@Resource
	CopyToManager copyToManager;
	
	@Resource
	BpmTaskManager bpmTaskManager;
	
	/**
	 * 抄送给指定的用户。
	 */
	public void copyTo(List<IUser> receiverUsers,BpmProcessInstance bpmProcessInstance ,String nodeId){
		//调用接口做抄送处理
		copyTo(bpmProcessInstance, nodeId, 
							 CopyToType.COPYTO,
							receiverUsers);
	}


    private void copyTo(BpmProcessInstance instance, String nodeId,
                        CopyToType copyToType,List<IUser> iUsers) {
        if (BeanUtils.isNotEmpty(iUsers)) {
            List<String> copyUsers = new ArrayList<>();
            for (IUser entity : iUsers) {
                copyUsers.add(entity.getFullname());
                transToMore(instance, entity.getUserId(), "inner","");
            }
            //审批记录
            DefaultBpmCheckOpinion defaultBpmCheckOpinion = new DefaultBpmCheckOpinion();
            defaultBpmCheckOpinion.setId(UniqueIdUtil.getSuid());
            defaultBpmCheckOpinion.setProcDefId(instance.getBpmnDefId());
            defaultBpmCheckOpinion.setProcInstId(instance.getId());
            defaultBpmCheckOpinion.setTaskId("");
            defaultBpmCheckOpinion.setTaskKey(null);
            defaultBpmCheckOpinion.setTaskName("传阅任务");
            defaultBpmCheckOpinion.setStatus(OpinionStatus.COPYTO.getKey());
            defaultBpmCheckOpinion.setCreateTime(LocalDateTime.now());
            defaultBpmCheckOpinion.setOpinion("流程办结传阅");
            defaultBpmCheckOpinion.setQualfiedNames(ContextUtil.getCurrentUser().getFullname());
            defaultBpmCheckOpinion.setAuditorName(StringUtil.join(copyUsers, ","));
            defaultBpmCheckOpinion.setCompleteTime(LocalDateTime.now());
            defaultBpmCheckOpinion.setDurMs(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis(defaultBpmCheckOpinion.getCreateTime()));
            defaultBpmCheckOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
            defaultBpmCheckOpinion.setFiles("");
            defaultBpmCheckOpinion.setIsRead(1);
            BpmCheckOpinionManager bpmCheckOpinionManager = AppUtil.getBean(BpmCheckOpinionManager.class);
            bpmCheckOpinionManager.create(defaultBpmCheckOpinion);
        }
    }

    private static void transToMore(BpmProcessInstance instance,String userId,String messageType,String taskId){
        IUserService userServiceImpl = AppUtil.getBean(IUserService.class);
        IUser user = userServiceImpl.getUserById(userId);
        IUser currentUser = userServiceImpl.getUserById(ContextUtil.getCurrentUserId());
        //添加知会任务
        BpmTaskNoticeManager noticeManager = AppUtil.getBean(BpmTaskNoticeManager.class);
        BpmTaskNotice taskNotice = new BpmTaskNotice("传阅任务", instance.getSubject(), instance.getId(), instance.getProcDefId(), instance.getProcDefName(), userId, user.getFullname(), TaskType.COPYTO.getKey(),((DefaultBpmProcessInstance) instance).getSupportMobile(),currentUser.getFullname(),currentUser.getUserId(),0, BeanUtils.isEmpty(taskId)?null:taskId,null);
        noticeManager.create(taskNotice);
    }
}
