package com.artfess.base.vo;

import com.artfess.base.model.Tree;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * 树形vo
 */
@Data
@ApiModel(description = "树形vo ")
public class TreeVo implements Tree {


    /**
     * 主键
     */
    @ApiModelProperty(name = "id", notes = "id")
    protected String id;

    /**
     * name_
     */
    @ApiModelProperty(name = "name", notes = "名称")
    protected String name;

    /**
     * prent_id_
     */
    @ApiModelProperty(name = "parentId", notes = "父节点id")
    protected String parentId;

    /**
     * prent_id_
     */
    @ApiModelProperty(name = "parentCode", notes = "父节点id")
    protected String parentCode;

    /**
     * code_
     */
    @ApiModelProperty(name = "code", notes = "编码")
    protected String code;

    /**
     * 数据类型（project:项目,building：楼栋）
     */
    @ApiModelProperty(name = "type", notes = "数据类型（project:项目,building：楼栋）")
    protected String type;

    /**
     * 组织类型（ogn,dept）
     */
    @ApiModelProperty(name = "orgKind", notes = "组织类型（单位：ogn,项目：project）")
    protected String orgKind;

    /**
     * 是否有子节点   否0  是1
     */
    @ApiModelProperty(name = "isIsParent", notes = "是否有子节点   否0  是1")
    protected boolean isIsParent;

    @ApiModelProperty(name = "level")
    protected String level;

    @ApiModelProperty(name = "扩展信息")
    protected String expandInfo;


    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    protected List<TreeVo> children = new ArrayList<TreeVo>();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public void setIsParent(String isParent) {

    }

    @Override
    public void setChildren(List list) {
        this.children = list;
    }

}
