package com.artfess.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

/**
 * 带逻辑删除实体基类
 * @param <T>
 */
@Data
public abstract class BizDelModel<T extends BizDelModel<?>> extends AutoFillModel<T> {

//    @JsonIgnore
    @ApiModelProperty(value = "创建人组织名称")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="CREATE_ORG_NAME_", fill= FieldFill.INSERT, select=true)
    private String createOrgName;

    @ApiModelProperty(value = "创建人组织Id")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="CREATE_ORG_ID_", fill= FieldFill.INSERT, select=true)
    private String createOrgId;

//    @JsonIgnore
    @ApiModelProperty(value = "创建人单位ID")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="CREATE_DEPT_ID_", fill= FieldFill.INSERT, select=false)
    private String createDeptId;

//    @JsonIgnore
    @ApiModelProperty(value = "创建人单位名称")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="CREATE_DEPT_NAME_", fill= FieldFill.INSERT, select=false)
    private String createDeptName;

//    @JsonIgnore
    @ApiModelProperty(value = "创建人姓名")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="CREATE_NAME_", fill= FieldFill.INSERT, select=true)
    private String createName;

//    @JsonIgnore
    @ApiModelProperty(value = "更新人姓名")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="UPDATE_NAME_", fill= FieldFill.UPDATE, select=false)
    private String updateName;

//    @JsonIgnore
    @ApiModelProperty(value = "更新人组织ID")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="UPDATE_ORG_ID_", fill= FieldFill.UPDATE, select=false)
    private String updateOrgId;

//    @JsonIgnore
    @ApiModelProperty(value = "更新人组织名称")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="UPDATE_ORG_NAME_", fill= FieldFill.UPDATE, select=false)
    private String updateOrgName;

//    @JsonIgnore
    @ApiModelProperty(value = "更新人单位ID")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="UPDATE_DEPT_ID_", fill= FieldFill.UPDATE, select=false)
    private String updateDeptId;

//    @JsonIgnore
    @ApiModelProperty(value = "更新人单位名称")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="UPDATE_DEPT_NAME_", fill= FieldFill.UPDATE, select=false)
    private String updateDeptName;

//    @JsonIgnore
    @ApiModelProperty(value = "最后更新时间戳")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="LAST_TIME_", fill= FieldFill.INSERT_UPDATE, select=false)
    private Long lastTime;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    @TableLogic
    private String isDele="0";

    @ApiModelProperty(value = "版本号")
    @TableField(value ="VERSION_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private Long version=1L;

    @ApiModelProperty(value = "租户ID")
    @TableField(value ="TENANT_ID_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String tenantId="-1";

}
