const path = require('path')
const webpack = require('webpack')
const CleanWebpackPlugin = require('clean-webpack-plugin')
const VueLoaderPlugin = require('vue-loader/lib/plugin')

// dll文件存放的目录
const dllPath = 'public/js'

module.exports = {
  entry: {
    // 需要提取的库文件
    vendor: ['vue/dist/vue.esm.js','vue', 'vue-router', 'vuex', 'axios','echarts','vue-amap','bpm_el_ui','vue-ueditor-wrap','handsontable','video.js','jquery','babel-polyfill','vue-codemirror','lodash','element-ui', 'xlsx/dist/xlsx.core.min.js','mockjs','vue-count-to','vue-sketch-ruler','crypto-js','vuedraggable','@jiaminghi/data-view','@amap/amap-vue']
  },
  output: {
    path: path.join(__dirname, dllPath),
    filename: '[name].dll.js',
    // vendor.dll.js中暴露出的全局变量名
    // 保持与 webpack.DllPlugin 中名称一致
    library: '[name]_[hash]'
  },
  resolve: { extensions: ['.js', '.vue', '.json'], alias: { 'vue$': 'vue/dist/vue.esm.js'}},
  module: {
    rules: [{
      test: /\.css$/,
      loader: "style-loader!css-loader"
    }, {
      test: /\.vue$/,
      loader: "vue-loader"
    },{
      test: /\.(woff2?|eot|ttf|otf)(\?.*)?$/i,
      use: 'url-loader'
    }]
  },
  plugins: [
    new VueLoaderPlugin(),
    // 清除之前的dll文件
    new CleanWebpackPlugin(['*.*'], {
      root: path.join(__dirname, dllPath)
    }),
    // 设置环境变量
    new webpack.DefinePlugin({
      'process.env': {
        NODE_ENV: 'production'
      }
    }),
    // manifest.json 描述动态链接库包含了哪些内容
    new webpack.DllPlugin({
      path: path.join(__dirname, dllPath, '[name]-manifest.json'),
      // 保持与 output.library 中名称一致
      name: '[name]_[hash]',
      context: process.cwd()
    }),
    new webpack.ProvidePlugin({
      $: 'jquery',
      jQuery: 'jquery',
      'windows.jQuery': 'jquery'
    })
  ]
}
