/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.manager.impl;

import com.artfess.base.enums.PaperStatusEnum;
import com.artfess.base.enums.PaperTypeEnum;
import com.artfess.base.enums.PaperWayTypeEnum;
import com.artfess.base.enums.QuestionStateEnum;
import com.artfess.base.enums.QuestionTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.time.DateUtil;
import com.artfess.examine.dao.ExamPaperBaseDao;
import com.artfess.examine.dao.ExamPaperQuestionSettingDao;
import com.artfess.examine.dao.ExamPaperSettingDao;
import com.artfess.examine.dao.ExamQuestionsOptionDao;
import com.artfess.examine.dao.ExamSubjectInfoDao;
import com.artfess.examine.manager.ExamImitateRecordManager;
import com.artfess.examine.manager.ExamPaperBaseManager;
import com.artfess.examine.manager.ExamQuestionsInfoManager;
import com.artfess.examine.manager.ExamUserRecordDetailManager;
import com.artfess.examine.manager.ExamUserRecordManager;
import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.model.ExamPaperQuestionSetting;
import com.artfess.examine.model.ExamPaperSetting;
import com.artfess.examine.model.ExamQuestionsInfo;
import com.artfess.examine.model.ExamQuestionsOption;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.model.ExamUserRecord;
import com.artfess.examine.model.ExamUserRecordDetail;
import com.artfess.examine.vo.UserInfoVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ExamPaperBaseManagerImpl
extends BaseManagerImpl<ExamPaperBaseDao, ExamPaperBase>
implements ExamPaperBaseManager {
    @Resource
    private ExamPaperSettingDao paperSettingDao;
    @Resource
    private ExamPaperQuestionSettingDao paperQuestionSettingDao;
    @Autowired
    private ExamQuestionsInfoManager questionsInfoManager;
    @Resource
    private ExamQuestionsOptionDao questionsOptionDao;
    @Autowired
    private ExamUserRecordManager userRecordManager;
    @Autowired
    private ExamUserRecordDetailManager userRecordDetailManager;
    @Resource
    private ExamSubjectInfoDao subjectInfoDao;
    @Resource
    private ExamImitateRecordManager imitateRecordManager;
    @Resource(name="bmpExecutorService")
    private ExecutorService executorService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createInfo(ExamPaperBase t) {
        if (PaperTypeEnum.formal.getType().equals(t.getType())) {
            Assert.notNull((Object)t.getPaperType(), (String)"\u8bf7\u9009\u62e9\u8003\u6838\u7c7b\u578b");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        List<String> subIds = Arrays.asList(t.getSubjectId().split(","));
        queryWrapper.in((Object)"id_", subIds);
        List examSubjectInfos = this.subjectInfoDao.selectList((Wrapper)queryWrapper);
        String subjectName = examSubjectInfos.stream().map(ExamSubjectInfo::getName).collect(Collectors.joining(",", "", ""));
        t.setSubjectName(subjectName);
        int insert = ((ExamPaperBaseDao)this.baseMapper).insert((Object)t);
        if (insert < 0) {
            return null;
        }
        this.processScoreSetting(t);
        this.processSetting(t);
        if (PaperTypeEnum.simulation.getType().equals(t.getType())) {
            this.imitateRecordManager.createImitate(t);
        } else {
            this.executorService.execute(() -> {
                try {
                    this.processUserRecord(t);
                }
                catch (Exception e) {
                    this.log.error("\u521b\u5efa\u8003\u751f\u8bb0\u5f55\u5931\u8d25:{}", (Throwable)e);
                }
            });
        }
        ((ExamPaperBaseDao)this.baseMapper).updateById((Object)t);
        return t.getId();
    }

    private void processUserRecord(ExamPaperBase examPaperBase) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"paper_id_", (Object)examPaperBase.getId());
        this.userRecordManager.getBaseMapper().delete((Wrapper)queryWrapper);
        examPaperBase.setTestUserType(examPaperBase.getPaperSetting().getTestUserType());
        List<Object> userInfoVos = Lists.newArrayList();
        userInfoVos = "1".equals(examPaperBase.getTestUserType()) ? ((ExamPaperBaseDao)this.baseMapper).getAllUser() : examPaperBase.getUserInfoVos();
        if (CollectionUtils.isEmpty((Collection)userInfoVos)) {
            return;
        }
        ArrayList records = Lists.newArrayList();
        userInfoVos.forEach(vo -> {
            ExamUserRecord examUserRecord = new ExamUserRecord();
            examUserRecord.setUserId(vo.getUserId());
            examUserRecord.setUserName(vo.getUserName());
            examUserRecord.setAccount(vo.getAccount());
            examUserRecord.setPositionId(vo.getPositionId());
            examUserRecord.setPaperId(examPaperBase.getId());
            examUserRecord.setStatus(QuestionStateEnum.notTo.getType());
            records.add(examUserRecord);
        });
        this.userRecordManager.saveBatch(records);
    }

    private void processSetting(ExamPaperBase t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"paper_id_", (Object)t.getId());
        this.paperSettingDao.delete((Wrapper)queryWrapper);
        if (PaperTypeEnum.formal.getType().equals(t.getType())) {
            Assert.notNull((Object)t.getPaperSetting().getPlanStartTime(), (String)"\u8bf7\u9009\u62e9\u8003\u8bd5\u5f00\u59cb\u65f6\u95f4");
            Assert.notNull((Object)t.getPaperSetting().getPlanEndTime(), (String)"\u8bf7\u9009\u62e9\u8003\u8bd5\u7ed3\u675f\u65f6\u95f4");
        }
        ExamPaperSetting paperSetting = t.getPaperSetting();
        Assert.notNull((Object)t.getPaperSetting().getTimeLength(), (String)"\u8bf7\u586b\u5199\u8003\u8bd5\u65f6\u957f");
        Assert.notNull((Object)t.getTotalScore(), (String)"\u8bf7\u586b\u5199\u603b\u5206\u6570");
        paperSetting.setPaperId(t.getId());
        paperSetting.setStatus(PaperStatusEnum.notRelease.getType());
        paperSetting.setPaperId(t.getId());
        paperSetting.setTrainModel(t.getTrainModel());
        this.paperSettingDao.insert((Object)paperSetting);
    }

    private void processScoreSetting(ExamPaperBase t) {
        QueryWrapper questionSettingQueryWrapper = new QueryWrapper();
        questionSettingQueryWrapper.eq((Object)"paper_base_id_", (Object)t.getId());
        this.paperQuestionSettingDao.delete((Wrapper)questionSettingQueryWrapper);
        Assert.notEmpty(t.getPaperQuestionSettings(), (String)"\u8bf7\u914d\u7f6e\u9898\u76ee\u4fe1\u606f");
        AtomicReference<Double> totalScore = new AtomicReference<Double>(0.0);
        AtomicReference<Integer> totalNumber = new AtomicReference<Integer>(0);
        AtomicReference<Integer> trainModel = new AtomicReference<Integer>(1);
        t.getPaperQuestionSettings().forEach(question -> {
            if ("2".equals(t.getWayType())) {
                Assert.hasText((String)question.getQuestionId(), (String)"\u8bf7\u9009\u62e9\u95ee\u9898");
                question.setNumuber(1);
            }
            Assert.notNull((Object)question.getScore(), (String)"\u8bf7\u586b\u5199\u5206\u6570");
            Assert.hasText((String)question.getQuestionType(), (String)"\u8bf7\u586b\u5199\u9898\u76ee\u7c7b\u578b");
            question.setPaperBaseId(t.getId());
            question.setSubjectId(question.getSubjectId());
            totalNumber.updateAndGet(v -> v + question.getNumuber());
            totalScore.set((Double)totalScore.get() + question.getScore().doubleValue() * (double)question.getNumuber().intValue());
            this.paperQuestionSettingDao.insert(question);
            if (QuestionTypeEnum.radio.getType().equals(question.getQuestionType()) || QuestionTypeEnum.multi.getType().equals(question.getQuestionType()) || QuestionTypeEnum.judge.getType().equals(question.getQuestionType())) {
                trainModel.set(2);
            }
        });
        t.setTotalScore(new BigDecimal(totalScore.get()));
        t.setTotalNumber(totalNumber.get());
        t.setTrainModel(trainModel.get());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String updateInfo(ExamPaperBase t) {
        if (PaperTypeEnum.formal.getType().equals(t.getType())) {
            Assert.notNull((Object)t.getPaperType(), (String)"\u8bf7\u9009\u62e9\u8003\u6838\u7c7b\u578b");
        }
        ExamPaperBase examPaperBase = (ExamPaperBase)((Object)((ExamPaperBaseDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        Assert.notNull((Object)((Object)examPaperBase), (String)"\u8bd5\u5377\u4e0d\u5b58\u5728");
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"paper_id_", (Object)t.getId());
        ExamPaperSetting examPaperSetting = (ExamPaperSetting)((Object)this.paperSettingDao.selectOne((Wrapper)query));
        Assert.notNull((Object)((Object)examPaperSetting), (String)"\u5173\u8054\u7684\u8bd5\u5377\u4e0d\u5b58\u5728");
        if (!"0".equals(examPaperSetting.getStatus())) {
            throw new RuntimeException("\u4efb\u52a1\u5df2\u53d1\u5e03\uff0c\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id_", Arrays.asList(t.getSubjectId().split(",")));
        List examSubjectInfos = this.subjectInfoDao.selectList((Wrapper)queryWrapper);
        String subjectName = examSubjectInfos.stream().map(ExamSubjectInfo::getName).collect(Collectors.joining(",", "", ""));
        t.setSubjectName(subjectName);
        int count = ((ExamPaperBaseDao)this.baseMapper).updateById((Object)t);
        if (count < 0) {
            return null;
        }
        this.processScoreSetting(t);
        this.processSetting(t);
        if (PaperTypeEnum.simulation.getType().equals(t.getType())) {
            this.imitateRecordManager.createImitate(t);
        } else {
            this.executorService.execute(() -> {
                try {
                    this.processUserRecord(t);
                }
                catch (Exception e) {
                    this.log.error("\u521b\u5efa\u8003\u751f\u8bb0\u5f55\u5931\u8d25:{}", (Throwable)e);
                }
            });
        }
        ((ExamPaperBaseDao)this.baseMapper).updateById((Object)t);
        return t.getId();
    }

    @Override
    public ExamPaperBase findById(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u67e5\u770b\u7684\u8bd5\u5377");
        ExamPaperBase examPaperBase = (ExamPaperBase)((Object)((ExamPaperBaseDao)this.baseMapper).selectById((Serializable)((Object)id)));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"paper_id_", (Object)id);
        ExamPaperSetting examPaperSetting = (ExamPaperSetting)((Object)this.paperSettingDao.selectOne((Wrapper)queryWrapper));
        examPaperBase.setPaperSetting(examPaperSetting);
        QueryWrapper questionSettingQueryWrapper = new QueryWrapper();
        questionSettingQueryWrapper.eq((Object)"paper_base_id_", (Object)id);
        List examPaperQuestionSettings = this.paperQuestionSettingDao.selectList((Wrapper)questionSettingQueryWrapper);
        examPaperBase.setPaperQuestionSettings(examPaperQuestionSettings);
        if (PaperWayTypeEnum.pzcj.getType().equals(examPaperBase.getWayType())) {
            QueryWrapper questionQuery = new QueryWrapper();
            List questionIds = examPaperQuestionSettings.stream().map(ExamPaperQuestionSetting::getQuestionId).collect(Collectors.toList());
            questionQuery.in((Object)"id_", questionIds);
            List questionsInfos = this.questionsInfoManager.getBaseMapper().selectList((Wrapper)questionQuery);
            Map<String, ExamQuestionsInfo> questionsInfoMap = questionsInfos.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            QueryWrapper optionQueryWrapper = new QueryWrapper();
            optionQueryWrapper.in((Object)"question_id_", questionIds);
            optionQueryWrapper.orderByAsc((Object)"option_key_");
            List examQuestionsOptions = this.questionsOptionDao.selectList((Wrapper)optionQueryWrapper);
            Map<String, List<ExamQuestionsOption>> map = examQuestionsOptions.stream().collect(Collectors.groupingBy(ExamQuestionsOption::getQuestionId));
            examPaperQuestionSettings.forEach(examPaperQuestionSetting -> {
                ExamQuestionsInfo examQuestionsInfo = (ExamQuestionsInfo)((Object)((Object)questionsInfoMap.get(examPaperQuestionSetting.getQuestionId())));
                examQuestionsInfo.setOptions((List)map.get(examPaperQuestionSetting.getQuestionId()));
                examPaperQuestionSetting.setQuestionsInfo(examQuestionsInfo);
            });
        }
        List<UserInfoVo> userInfoVoList = this.userRecordManager.findByPaperId(id);
        examPaperBase.setUserInfoVos(userInfoVoList);
        QueryWrapper subjectInfoQueryWrapper = new QueryWrapper();
        subjectInfoQueryWrapper.in((Object)"id_", Arrays.asList(examPaperBase.getSubjectId().split(",")));
        List examSubjectInfos = this.subjectInfoDao.selectList((Wrapper)subjectInfoQueryWrapper);
        examPaperBase.setSubjectInfos(examSubjectInfos);
        return examPaperBase;
    }

    @Override
    public ExamPaperBase viewPaper(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u9884\u89c8\u7684\u8bd5\u5377");
        ExamPaperBase examPaperBase = (ExamPaperBase)((Object)((ExamPaperBaseDao)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)examPaperBase), (String)"\u8bd5\u5377\u4fe1\u606f\u4e0d\u5b58\u5728");
        List<ExamQuestionsInfo> questionList = this.processQuestionList(examPaperBase);
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"paper_id_", (Object)id);
        ExamPaperSetting examPaperSetting = (ExamPaperSetting)((Object)this.paperSettingDao.selectOne((Wrapper)query));
        Assert.notNull((Object)((Object)examPaperSetting), (String)"\u5173\u8054\u7684\u8bd5\u5377\u4e0d\u5b58\u5728");
        examPaperBase.setTimeLength(examPaperSetting.getTimeLength());
        examPaperBase.setExamQuestionsInfos(questionList);
        return examPaperBase;
    }

    @Override
    public List<ExamQuestionsInfo> processQuestionList(ExamPaperBase examPaperBase) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"paper_base_id_", (Object)examPaperBase.getId());
        queryWrapper.orderByAsc((Object)"sn_");
        List settingList = this.paperQuestionSettingDao.selectList((Wrapper)queryWrapper);
        ArrayList questionList = Lists.newArrayList();
        List<Object> questionIds = Lists.newArrayList();
        if (PaperWayTypeEnum.pzcj.getType().equals(examPaperBase.getWayType())) {
            questionIds = settingList.stream().map(ExamPaperQuestionSetting::getQuestionId).collect(Collectors.toList());
            Map<String, ExamPaperQuestionSetting> settingMap = settingList.stream().collect(Collectors.toMap(item -> item.getQuestionId(), item -> item));
            QueryWrapper questionQuery = new QueryWrapper();
            questionQuery.in((Object)"id_", (Collection)questionIds);
            List examQuestionsInfos = this.questionsInfoManager.getBaseMapper().selectList((Wrapper)questionQuery);
            examQuestionsInfos.forEach(question -> question.setScore(((ExamPaperQuestionSetting)((Object)((Object)settingMap.get(question.getId())))).getScore()));
            questionList.addAll(examQuestionsInfos);
        } else {
            settingList.forEach(setting -> {
                List<ExamQuestionsInfo> examQuestionsInfos = this.questionsInfoManager.randomQuestion(setting.getSubjectId(), setting.getQuestionType(), setting.getNumuber());
                examQuestionsInfos.forEach(question -> question.setScore(setting.getScore()));
                questionList.addAll(examQuestionsInfos);
            });
            questionIds = questionList.stream().map(ExamQuestionsInfo::getId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)questionIds)) {
            return Lists.newArrayList();
        }
        QueryWrapper optionQueryWrapper = new QueryWrapper();
        optionQueryWrapper.in((Object)"question_id_", (Collection)questionIds);
        optionQueryWrapper.orderByAsc((Object)"option_key_");
        List examQuestionsOptions = this.questionsOptionDao.selectList((Wrapper)optionQueryWrapper);
        Map<String, List<ExamQuestionsOption>> map = examQuestionsOptions.stream().collect(Collectors.groupingBy(ExamQuestionsOption::getQuestionId));
        questionList.forEach(question -> {
            if (!map.containsKey(question.getId())) {
                return;
            }
            question.setOptions((List)map.get(question.getId()));
        });
        questionList.sort((o1, o2) -> o1.getType().compareTo(o2.getType()));
        return questionList;
    }

    @Override
    public void startPaper(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8981\u53d1\u5e03\u7684\u8003\u8bd5");
        ExamPaperBase examPaperBase = (ExamPaperBase)((Object)((ExamPaperBaseDao)this.baseMapper).selectById((Serializable)((Object)id)));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"paper_id_", (Object)id);
        ExamPaperSetting examPaperSetting = (ExamPaperSetting)((Object)this.paperSettingDao.selectOne((Wrapper)query));
        Assert.notNull((Object)((Object)examPaperSetting), (String)"\u5173\u8054\u7684\u8bd5\u5377\u4e0d\u5b58\u5728");
        if (!"0".equals(examPaperSetting.getStatus())) {
            throw new RuntimeException("\u8bd5\u5377\u5df2\u53d1\u5e03\uff0c\u4e0d\u80fd\u518d\u6b21\u53d1\u5e03");
        }
        boolean dateLittle = DateUtil.isDateLittle((LocalDateTime)LocalDateTime.now(), (LocalDateTime)examPaperSetting.getPlanStartTime());
        if (dateLittle) {
            throw new RuntimeException("\u672a\u5230\u8bd5\u5377\u5f00\u59cb\u65f6\u95f4\uff0c\u4e0d\u80fd\u8fdb\u884c\u53d1\u5e03\uff01");
        }
        boolean dateEquals = DateUtil.isDateLittle((LocalDateTime)LocalDateTime.now(), (LocalDateTime)examPaperSetting.getPlanEndTime());
        if (!dateEquals) {
            throw new RuntimeException("\u8bd5\u5377\u7ed3\u675f\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u80fd\u8fdb\u884c\u53d1\u5e03\uff01");
        }
        examPaperSetting.setStatus("1");
        this.paperSettingDao.updateById((Object)examPaperSetting);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"paper_id_", (Object)id);
        List records = this.userRecordManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        this.executorService.execute(() -> {
            try {
                this.processUserRecordDetail(records, examPaperBase);
            }
            catch (Exception e) {
                this.log.error("\u521b\u5efa\u8bd5\u5377\u5931\u8d25:{}", (Throwable)e);
            }
        });
    }

    @Override
    public void addUser(ExamPaperBase examPaperBase) {
        if (CollectionUtils.isEmpty(examPaperBase.getUserInfoVos())) {
            return;
        }
        ArrayList records = Lists.newArrayList();
        examPaperBase.getUserInfoVos().forEach(vo -> {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"user_id_", (Object)vo.getUserId());
            queryWrapper.eq((Object)"paper_id_", (Object)examPaperBase.getId());
            List list = this.userRecordManager.getBaseMapper().selectList((Wrapper)queryWrapper);
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)"");
            if (!CollectionUtils.isEmpty((Collection)list)) {
                throw new RuntimeException(vo.getUserName() + "\u5df2\u52a0\u5165\u8bd5\u5377\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
            }
            ExamUserRecord examUserRecord = new ExamUserRecord();
            examUserRecord.setUserId(vo.getUserId());
            examUserRecord.setPositionId(vo.getPositionId());
            examUserRecord.setAccount(vo.getAccount());
            examUserRecord.setUserName(vo.getUserName());
            examUserRecord.setPaperId(examPaperBase.getId());
            examUserRecord.setStatus(QuestionStateEnum.toBeAnswer.getType());
            records.add(examUserRecord);
        });
        this.userRecordManager.saveBatch(records);
        this.processUserRecordDetail(records, examPaperBase);
    }

    @Override
    public PageList<ExamPaperBase> findByPage(QueryFilter<ExamPaperBase> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ExamPaperBase> result = ((ExamPaperBaseDao)this.baseMapper).findByPage((IPage<ExamPaperBase>)this.convert2IPage(pageBean), (Wrapper<ExamPaperBase>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        result.getRecords().forEach(paperBase -> {
            boolean dateEquals = DateUtil.isDateLittle((LocalDateTime)LocalDateTime.now(), (LocalDateTime)paperBase.getPlanEndTime());
            if (dateEquals && !PaperStatusEnum.notRelease.getType().equals(paperBase.getStatus())) {
                paperBase.setStatus(PaperStatusEnum.inTets.getType());
            } else if (!dateEquals && !PaperStatusEnum.notRelease.getType().equals(paperBase.getStatus())) {
                paperBase.setStatus(PaperStatusEnum.finish.getType());
            }
        });
        return new PageList(result);
    }

    @Override
    public Long getEndStatus(String subjectId) {
        ExamPaperBase examPaperBase = new ExamPaperBase();
        examPaperBase.setSubjectId(subjectId);
        Long count = ((ExamPaperBaseDao)this.baseMapper).getYearPaperCount(examPaperBase);
        return count;
    }

    private void processUserRecordDetail(List<ExamUserRecord> records, ExamPaperBase examPaperBase) {
        if (PaperWayTypeEnum.sjcj.getType().equals(examPaperBase.getWayType())) {
            records.forEach(record -> {
                record.setStatus(QuestionStateEnum.toBeAnswer.getType());
                List<ExamQuestionsInfo> examQuestionsInfos = this.processQuestionList(examPaperBase);
                this.createUserRecordDetail((ExamUserRecord)((Object)record), examQuestionsInfos, examPaperBase);
            });
        } else {
            List<ExamQuestionsInfo> examQuestionsInfos = this.processQuestionList(examPaperBase);
            records.forEach(record -> {
                record.setStatus(QuestionStateEnum.toBeAnswer.getType());
                this.createUserRecordDetail((ExamUserRecord)((Object)record), examQuestionsInfos, examPaperBase);
            });
        }
        this.userRecordManager.updateBatchById(records);
    }

    private void createUserRecordDetail(ExamUserRecord record, List<ExamQuestionsInfo> examQuestionsInfos, ExamPaperBase examPaperBase) {
        ArrayList details = Lists.newArrayList();
        examQuestionsInfos.forEach(question -> {
            ExamUserRecordDetail userRecordDetail = new ExamUserRecordDetail();
            userRecordDetail.setRecordId(record.getId());
            userRecordDetail.setQuestionId(question.getId());
            userRecordDetail.setQuestionType(question.getType());
            userRecordDetail.setRightKey(question.getRightOption());
            userRecordDetail.setScore(question.getScore());
            details.add(userRecordDetail);
        });
        if (!CollectionUtils.isEmpty((Collection)details)) {
            this.userRecordDetailManager.saveBatch(details);
        }
    }
}

