package com.artfess.dataAccess.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.model.CommonResult;
import com.artfess.dataAccess.dao.DataAccessDefinedDao;
import com.artfess.dataAccess.manager.DataAccessControlManager;
import com.artfess.dataAccess.model.DataAccessControl;
import com.artfess.dataAccess.params.DataAccessControlVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 数据权限——授权 前端控制器
 *
 * @author llj
 * @since 2021-04-01
 */
@RestController
@Api(tags="数据权限授权")
@ApiGroup(group= {ApiGroupConsts.GROUP_UC})
@RequestMapping(value="/uc/DataAccessControl/v1/")
public class DataAccessControlController extends BaseController<com.artfess.dataAccess.manager.DataAccessControlManager, DataAccessControl> {

    @Resource
    DataAccessControlManager DataAccessControlManager;
    @Resource
    DataAccessDefinedDao dao;


    @GetMapping("queryListDataAccessDefined")
    @ApiOperation(value="根据数据权限id查询权限列表", httpMethod = "GET", notes = "根据数据权限id查询权限列表")
    @PowerLogInfo(logType = LogType.AUDIT, operaionType = OperationType.QUERY, description = "根据数据权限id查询权限列表")
    public DataAccessControlVo queryListDataAccessDefined(@ApiParam(name="accessControlId",value="数据权限id",required = true)@RequestParam String accessControlId )throws Exception{
        List<DataAccessControl> list = DataAccessControlManager.queryListDataAccessDefined(accessControlId);
        if (list.size()<0){
            return null;
        }
        DataAccessControlVo vo = new DataAccessControlVo();
        String orgList="";
        String persoinList="";
        String roleList = "";
        for (int i = 0; i <list.size() ; i++) {
            Integer type = list.get(i).getAccessControlType();
            if (type==2){
                if (i<list.size()-1){
                    orgList=orgList+list.get(i).getAccessControlId()+",";
                }else {
                    orgList=orgList+list.get(i).getAccessControlId();
                }
            }else if (type==3){
                if (i<list.size()-1){
                    persoinList=persoinList+list.get(i).getAccessControlId()+",";
                }else {
                    persoinList=persoinList+list.get(i).getAccessControlId();
                }
            }else if (type==4){
                if (i<list.size()-1){
                    roleList=roleList+list.get(i).getAccessControlId()+",";
                }else {
                    roleList=roleList+list.get(i).getAccessControlId();
                }
            }
        }
        if (orgList.length()>0){
            String[] split = orgList.split(",");
            List<String> orgNameList = dao.queryRangNameByOrg(Arrays.asList(split));
            vo.setOrgNameList(StringUtils.strip(orgNameList.toString(),"[]"));
        }
        if (persoinList.length()>0){
            String[] split2 = persoinList.split(",");
            List<String> persoinNameList = dao.queryRangNameByUser(Arrays.asList(split2));
            vo.setPersonNameList(StringUtils.strip(persoinNameList.toString(),"[]"));
        }
        if (roleList.length()>0){
            String[] split3 = roleList.split(",");
            List<String> roleNameList = dao.queryRangNameByRole(Arrays.asList(split3));
            vo.setRoleNameList(StringUtils.strip(roleNameList.toString(),"[]"));
        }
        if (list.get(0).getAccessControlType()==2){
            vo.setAccessControlType(2);
        }else {
            vo.setAccessControlType(1);
        }
        vo.setAccessDefinedId(accessControlId);
        vo.setOrgList(orgList);
        vo.setPersonList(persoinList);
        vo.setRoleList(roleList);
        return vo;
    }

    @PostMapping(value="saveDataAccessDefined")
    @ApiOperation(value = "新增、更新数据授权", httpMethod = "POST", notes = "新增、更新数据授权")
    @PowerLogInfo(logType = LogType.PERMISSION, operaionType = OperationType.UPDATE, description = "新增、更新数据授权")
    public CommonResult<String> saveDataAccessDefined(@ApiParam(name="DataAccessControlVo",value="授权对象", required = true)@RequestBody DataAccessControlVo DataAccessControlVo) throws Exception{
        Integer accessControlType = DataAccessControlVo.getAccessControlType();
        List<DataAccessControl> list = new ArrayList<>();
        String definedId = DataAccessControlVo.getAccessDefinedId();
        if (1==accessControlType){
            DataAccessControl DataAccessControl = new DataAccessControl();
            DataAccessControl.setAccessControlType(1);
            DataAccessControl.setAccessDefinedId(definedId);
            list.add(DataAccessControl);
        }else {
            if (StringUtils.isNotEmpty(DataAccessControlVo.getOrgList())){
                String orgList = DataAccessControlVo.getOrgList();
                String[] split = orgList.split(",");
                for (String orgId : split) {
                    DataAccessControl DataAccessControl = new DataAccessControl();
                    DataAccessControl.setAccessControlType(2);
                    DataAccessControl.setAccessControlId(orgId);
                    DataAccessControl.setAccessDefinedId(definedId);
                    list.add(DataAccessControl);
                }

            }
            if(StringUtils.isNotEmpty(DataAccessControlVo.getPersonList())){
                String personList = DataAccessControlVo.getPersonList();
                String[] split = personList.split(",");
                for (String personId : split) {
                    DataAccessControl DataAccessControl = new DataAccessControl();
                    DataAccessControl.setAccessControlType(3);
                    DataAccessControl.setAccessControlId(personId);
                    DataAccessControl.setAccessDefinedId(definedId);
                    list.add(DataAccessControl);
                }

            }
            if (StringUtils.isNotEmpty(DataAccessControlVo.getRoleList())){
                String roleList = DataAccessControlVo.getRoleList();
                String[] split = roleList.split(",");
                for (String roleId : split) {
                    DataAccessControl DataAccessControl = new DataAccessControl();
                    DataAccessControl.setAccessControlType(4);
                    DataAccessControl.setAccessControlId(roleId);
                    DataAccessControl.setAccessDefinedId(definedId);
                    list.add(DataAccessControl);
                }
            }
        }
        String msg = DataAccessControlManager.saveDataAccessDefined(list);
        return new CommonResult<String>(msg);
    }
}
