package com.artfess.application.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.jaxb.LocalDateTimeAdapter;
import com.artfess.sysConfig.persistence.model.SysAuthUser;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 移动端应用
 * <pre> 
 * 描述：移动端应用 实体对象
 * 构建组：x7
 * 作者:pangq
 * 邮箱:pangq@jee-soft.cn
 * 日期:2020-07-06 15:23:30
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
 @XmlRootElement(name = "appModel")
 @XmlAccessorType(XmlAccessType.FIELD)
 @TableName("PORTAL_APP")
 @ApiModel(value = "AppModel",description = "移动端应用")
public class AppModel extends BaseModel<AppModel> {

	private static final long serialVersionUID = 1L;
	@XmlTransient
	@TableId("ID_")
	@ApiModelProperty(value="主键")
	protected String id; 
	
	@XmlAttribute(name = "name")
	@TableField("NAME_")
	@ApiModelProperty(value="应用名称")
	protected String name; 
	
	@XmlAttribute(name = "content")
	@TableField("CONTENT_")
	@ApiModelProperty(value="内容")
	protected String content; 
	
	@XmlAttribute(name = "icon")
	@TableField("ICON_")
	@ApiModelProperty(value="图标")
	protected String icon; 
	
	@XmlAttribute(name = "iconColor")
	@TableField("ICON_COLOR_")
	@ApiModelProperty(value="图标颜色")
	protected String iconColor;

	@XmlTransient
	@TableField("TYPE_ID_")
	@ApiModelProperty(value="分类id")
	protected String typeId;

	@XmlTransient
	@TableField("TYPE_NAME_")
	@ApiModelProperty(value="分类名称")
	protected String typeName; 
	
	@XmlAttribute(name = "enable")
	@TableField("ENABLE_")
	@ApiModelProperty(value="是否启用：0未启用，1已启用")
	protected Integer enable=1; 
	
	@XmlAttribute(name = "mode")
	@TableField("MODE_")
	@ApiModelProperty(value="类型：1站内地址，2站外地址，3数据报表")
	protected Integer mode; 
	
	@XmlAttribute(name = "sn")
	@TableField("SN_")
	@ApiModelProperty(value="排序")
	protected Integer sn; 
	
	@XmlAttribute(name = "createBy")
	@TableField("CREATE_BY_")
	@ApiModelProperty(value="创建人")
	protected String createBy;

	@XmlAttribute(name = "createTime")
	@XmlJavaTypeAdapter(LocalDateTimeAdapter.class)
	@TableField("CREATE_TIME_")
	@ApiModelProperty(value="创建时间")
	protected LocalDateTime createTime; 
	
	@XmlAttribute(name = "updateBy")
	@TableField("UPDATE_BY_")
	@ApiModelProperty(value="更新人")
	protected String updateBy;

	@XmlAttribute(name = "updateTime")
	@XmlJavaTypeAdapter(LocalDateTimeAdapter.class)
	@TableField("UPDATE_TIME_")
	@ApiModelProperty(value="更新时间")
	protected LocalDateTime updateTime;

	 @XmlAttribute(name = "typeKey")
	 @TableField(exist=false)
	 @ApiModelProperty(value="分类Key")
	 protected String typeKey;

	 @XmlElement(name = "sysAuthUser", type = SysAuthUser.class)
	 @TableField(exist=false)
	 @ApiModelProperty(value="app权限")
	 protected List<SysAuthUser> sysAuthUserList;
	
	public void setId(String id) {
		this.id = id;
	}
	
	/**
	 * 返回 主键
	 * @return
	 */
	public String getId() {
		return this.id;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * 返回 应用名称
	 * @return
	 */
	public String getName() {
		return this.name;
	}
	public void setContent(String content) {
		this.content = content;
	}
	
	/**
	 * 返回 内容
	 * @return
	 */
	public String getContent() {
		return this.content;
	}
	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	/**
	 * 返回 图标
	 * @return
	 */
	public String getIcon() {
		return this.icon;
	}
	public void setIconColor(String iconColor) {
		this.iconColor = iconColor;
	}
	
	/**
	 * 返回 图标颜色
	 * @return
	 */
	public String getIconColor() {
		return this.iconColor;
	}
	public void setTypeId(String typeId) {
		this.typeId = typeId;
	}
	
	/**
	 * 返回 分类id
	 * @return
	 */
	public String getTypeId() {
		return this.typeId;
	}
	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public void setEnable(Integer enable) {
		this.enable = enable;
	}
	
	/**
	 * 返回 是否启用：0未启用，1已启用
	 * @return
	 */
	public Integer getEnable() {
		return this.enable;
	}
	public void setMode(Integer mode) {
		this.mode = mode;
	}
	
	/**
	 * 返回 类型：1站内地址，2站外地址，3数据报表
	 * @return
	 */
	public Integer getMode() {
		return this.mode;
	}
	public void setSn(Integer sn) {
		this.sn = sn;
	}
	
	/**
	 * 返回 排序
	 * @return
	 */
	public Integer getSn() {
		return this.sn;
	}
	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}
	
	/**
	 * 返回 创建人
	 * @return
	 */
	public String getCreateBy() {
		return this.createBy;
	}
	public void setCreateTime(LocalDateTime createTime) {
		this.createTime = createTime;
	}
	
	/**
	 * 返回 创建时间
	 * @return
	 */
	public LocalDateTime getCreateTime() {
		return this.createTime;
	}
	public void setUpdateBy(String updateBy) {
		this.updateBy = updateBy;
	}
	
	/**
	 * 返回 更新人
	 * @return
	 */
	public String getUpdateBy() {
		return this.updateBy;
	}
	public void setUpdateTime(LocalDateTime updateTime) {
		this.updateTime = updateTime;
	}
	
	/**
	 * 返回 更新时间
	 * @return
	 */
	public LocalDateTime getUpdateTime() {
		return this.updateTime;
	}

	public String getTypeKey() {
		 return typeKey;
	 }

	public void setTypeKey(String typeKey) {
		 this.typeKey = typeKey;
	 }

	public List<SysAuthUser> getSysAuthUserList() {
		return sysAuthUserList;
	}

	public void setSysAuthUserList(List<SysAuthUser> sysAuthUserList) {
		this.sysAuthUserList = sysAuthUserList;
	}

	 /**
	 * @see Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this)
		.append("id", this.id) 
		.append("name", this.name) 
		.append("content", this.content) 
		.append("icon", this.icon) 
		.append("iconColor", this.iconColor) 
		.append("typeId", this.typeId) 
		.append("enable", this.enable) 
		.append("mode", this.mode) 
		.append("sn", this.sn) 
		.append("createBy", this.createBy) 
		.append("createTime", this.createTime) 
		.append("updateBy", this.updateBy) 
		.append("updateTime", this.updateTime) 
		.toString();
	}
}