/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.DictionaryUtils;
import com.artfess.base.util.DmpBeanUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.data.dao.BizExamGeneralPlanDao;
import com.artfess.data.manager.BizExamGeneralPlanManager;
import com.artfess.data.manager.BizExamPlanManager;
import com.artfess.data.manager.BizExamPlanSubjectManager;
import com.artfess.data.manager.BizExamSpaceDataManager;
import com.artfess.data.model.BizExamGeneralPlan;
import com.artfess.data.model.BizExamPlan;
import com.artfess.data.model.BizExamPlanSubject;
import com.artfess.data.model.BizExamSpaceData;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.dao.ExamUserEvaluationDetailDao;
import com.artfess.examine.manager.ExamEquipmentSysManager;
import com.artfess.examine.manager.ExamSubjectInfoManager;
import com.artfess.examine.model.ExamEquipmentSys;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.vo.OrgVo;
import com.artfess.examine.vo.PositionVo;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BizExamGeneralPlanManagerImpl
extends BaseManagerImpl<BizExamGeneralPlanDao, BizExamGeneralPlan>
implements BizExamGeneralPlanManager {
    @Autowired
    private BizExamPlanManager planManager;
    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;
    @Autowired
    private ExamSubjectInfoManager subjectInfoManager;
    @Autowired
    private BizExamSpaceDataManager spaceDataManager;
    @Autowired
    private ExamEquipmentSysManager equipmentSysManager;
    @Resource
    private ExamUserEvaluationDetailDao userEvaluationDetailDao;
    @Resource
    IUserService userServiceImpl;
    @Autowired
    private BizExamPlanSubjectManager planSubjectManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(BizExamGeneralPlan t) {
        if ("1".equals(t.getPlanType())) {
            if (StringUtil.isEmpty((String)t.getYear())) {
                t.setYear(String.valueOf(LocalDate.now().getYear()));
            }
        } else if ("2".equals(t.getPlanType())) {
            Assert.hasText((String)t.getQuarter(), (String)"\u8bf7\u586b\u5199\u9636\u6bb5\u540d\u79f0");
        } else if ("3".equals(t.getPlanType())) {
            Assert.notNull((Object)t.getMonth(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u6708\u4efd");
        } else if ("4".equals(t.getPlanType())) {
            Assert.notNull((Object)t.getWeek(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u5468");
        } else {
            Assert.notNull((Object)t.getStartTime(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u5f00\u59cb\u65f6\u95f4");
            Assert.notNull((Object)t.getEndTime(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u7ed3\u675f\u65f6\u95f4");
        }
        t.setPlanStatus("0");
        boolean save = this.save((Object)t);
        if (save) {
            this.processPlans(t);
            return save;
        }
        return false;
    }

    private void processPlans(BizExamGeneralPlan t) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BizExamPlanSubject::getGeneralPlanId, (Object)t.getId());
        this.planSubjectManager.remove((Wrapper)lambdaQueryWrapper);
        LambdaQueryWrapper bizExamPlanLambdaQueryWrapper = new LambdaQueryWrapper();
        bizExamPlanLambdaQueryWrapper.eq(BizExamPlan::getGeneralPlanId, (Object)t.getId());
        this.planManager.remove((Wrapper)bizExamPlanLambdaQueryWrapper);
        ArrayList list = Lists.newArrayList();
        t.getPlanList().forEach(plan -> {
            plan.setGeneralPlanId(t.getId());
            Assert.hasText((String)plan.getOrgId(), (String)"\u8bf7\u9009\u62e9\u8981\u53c2\u4e0e\u57f9\u8bad\u7684\u5355\u4f4d");
            String[] split = plan.getOrgId().split(",");
            for (int i = 0; i < split.length; ++i) {
                BizExamPlan examPlan = new BizExamPlan();
                examPlan.setGeneralPlanId(t.getId());
                examPlan.setYear(t.getYear());
                examPlan.setQuarter(t.getQuarter());
                examPlan.setWeek(t.getWeek());
                examPlan.setPlanType(t.getPlanType());
                examPlan.setStartTime(t.getStartTime());
                examPlan.setEndTime(t.getEndTime());
                examPlan.setSubjectId(plan.getSubjectId());
                examPlan.setSubjectName(plan.getSubjectName());
                examPlan.setHour(plan.getHour());
                examPlan.setMonth(t.getMonth());
                examPlan.setMemo(t.getMemo());
                examPlan.setCoachId(plan.getCoachId());
                examPlan.setCoachName(plan.getCoachName());
                examPlan.setMajorId(plan.getMajorId());
                examPlan.setMajorName(plan.getMajorName());
                examPlan.setTrainType(plan.getTrainType());
                examPlan.setTrainLevel(plan.getTrainLevel());
                examPlan.setOrgId(split[i]);
                if (StringUtils.isNotEmpty((String)plan.getOrgName())) {
                    examPlan.setOrgName(plan.getOrgName().split(",")[i]);
                }
                examPlan.setPlanStatus("0");
                list.add(examPlan);
            }
        });
        this.planManager.saveBatch(list);
        this.planSubjectManager.saveOrUpdateBatch(t.getPlanList());
    }

    @Override
    public BizExamGeneralPlan findById(String id) {
        BizExamGeneralPlan generalPlan = (BizExamGeneralPlan)this.get((Serializable)((Object)id));
        Assert.notNull((Object)((Object)generalPlan), (String)"\u8bad\u7ec3\u8ba1\u5212\u4e0d\u5b58\u5728");
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BizExamPlanSubject::getGeneralPlanId, (Object)id);
        List planList = this.planSubjectManager.list((Wrapper)lambdaQueryWrapper);
        generalPlan.setPlanList(planList);
        return generalPlan;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(BizExamGeneralPlan t) {
        boolean save;
        BizExamGeneralPlan generalPlan = (BizExamGeneralPlan)this.get((Serializable)((Object)t.getId()));
        if (!"0".equals(generalPlan.getPlanStatus())) {
            throw new BaseException("\u5df2\u4e0b\u53d1\u7684\u8ba1\u5212\u4e0d\u80fd\u8fdb\u884c\u4fee\u6539");
        }
        if ("1".equals(t.getPlanType())) {
            if (StringUtil.isEmpty((String)t.getYear())) {
                t.setYear(String.valueOf(LocalDate.now().getYear()));
            }
        } else if ("2".equals(t.getPlanType())) {
            Assert.hasText((String)t.getQuarter(), (String)"\u8bf7\u586b\u5199\u9636\u6bb5\u540d\u79f0");
        } else if ("3".equals(t.getPlanType())) {
            Assert.notNull((Object)t.getMonth(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u6708\u4efd");
        } else if ("4".equals(t.getPlanType())) {
            Assert.notNull((Object)t.getWeek(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u5468");
        } else {
            Assert.notNull((Object)t.getStartTime(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u5f00\u59cb\u65f6\u95f4");
            Assert.notNull((Object)t.getEndTime(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u7ed3\u675f\u65f6\u95f4");
        }
        if (save = this.updateById((Object)t)) {
            this.processPlans(t);
            return save;
        }
        return false;
    }

    @Override
    public void saveList(List<BizExamGeneralPlan> list, String planType) {
        Assert.hasText((String)planType, (String)"\u8bf7\u9009\u62e9\u8ba1\u5212\u7c7b\u578b");
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BizExamGeneralPlan bizExamGeneralPlan = list.get(0);
        boolean save = this.save((Object)bizExamGeneralPlan);
        if (!save) {
            return;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        List subjectInfos = this.subjectInfoManager.list((Wrapper)queryWrapper);
        Map<String, ExamSubjectInfo> subjectInfoMap = subjectInfos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        List<OrgVo> orgVos = this.orgEvaluationDao.orgList();
        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        QueryWrapper sysQueryWrapper = new QueryWrapper();
        sysQueryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        List sysList = this.equipmentSysManager.list((Wrapper)sysQueryWrapper);
        Map<String, ExamEquipmentSys> sysMap = sysList.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        QueryWrapper spaceDataQueryWrapper = new QueryWrapper();
        spaceDataQueryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        List spaceDataList = this.spaceDataManager.list((Wrapper)spaceDataQueryWrapper);
        Map<String, BizExamSpaceData> spaceDateMap = spaceDataList.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        List<PositionVo> positionVoList = this.userEvaluationDetailDao.getPositionList();
        Map<String, PositionVo> positionMap = positionVoList.stream().collect(Collectors.toMap(item -> item.getPositionName(), item -> item));
        List userList = this.userServiceImpl.getUserListByGroup("role", "jly");
        Map<String, IUser> userMap = userList.stream().collect(Collectors.toMap(item -> item.getFullname(), item -> item));
        List planList = DmpBeanUtil.copyList(list, BizExamPlan.class);
        planList.forEach(t -> {
            t.setGeneralPlanId(bizExamGeneralPlan.getId());
            t.setPlanType(planType);
            if (null != DictionaryUtils.getDictInfo((String)"xllb", (String)t.getTrainType())) {
                String trainType = DictionaryUtils.getDictInfo((String)"xllb", (String)t.getTrainType()).getValue();
                t.setTrainType(trainType);
            }
            if (null != DictionaryUtils.getDictInfo((String)"xljb", (String)t.getTrainLevel())) {
                String trainLevel = DictionaryUtils.getDictInfo((String)"xljb", (String)t.getTrainLevel()).getValue();
                t.setTrainLevel(trainLevel);
            }
            if (null != DictionaryUtils.getDictInfo((String)"jdmc", (String)t.getQuarter())) {
                String type = DictionaryUtils.getDictInfo((String)"jdmc", (String)t.getQuarter()).getValue();
                t.setQuarter(type);
            }
            if (null != DictionaryUtils.getDictInfo((String)"xlfs", (String)t.getWay())) {
                String way = DictionaryUtils.getDictInfo((String)"xlfs", (String)t.getWay()).getValue();
                t.setWay(way);
            }
            Assert.notNull((Object)t.getStartTime(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u5f00\u59cb\u65f6\u95f4");
            Assert.notNull((Object)t.getEndTime(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u7ed3\u675f\u65f6\u95f4");
            if ("1".equals(planType)) {
                Assert.hasText((String)t.getYear(), (String)"\u8bf7\u586b\u5199\u5e74\u4efd");
            } else if ("2".equals(planType)) {
                Assert.hasText((String)t.getQuarter(), (String)"\u8bf7\u586b\u5199\u9636\u6bb5\u540d\u79f0");
            } else if ("3".equals(planType)) {
                Assert.notNull((Object)t.getMonth(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u6708\u4efd");
            } else if ("4".equals(planType)) {
                Assert.notNull((Object)t.getWeek(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u5468");
            }
            if (StringUtils.isNotEmpty((String)t.getMajorName()) && !CollectionUtils.isEmpty((Map)sysMap) && null != sysMap.get(t.getMajorName().split(",")[0])) {
                t.setMajorId(((ExamEquipmentSys)((Object)((Object)sysMap.get(t.getMajorName())))).getId());
            }
            if (StringUtils.isNotEmpty((String)t.getMajorName()) && !CollectionUtils.isEmpty((Map)subjectInfoMap) && null != subjectInfoMap.get(t.getSubjectName().split(",")[0])) {
                t.setSubjectId(((ExamSubjectInfo)((Object)((Object)subjectInfoMap.get(t.getSubjectName())))).getId());
            }
            if (StringUtils.isNotEmpty((String)t.getOrgName()) && !CollectionUtils.isEmpty((Map)orgMap) && null != orgMap.get(t.getOrgName().split(",")[0])) {
                t.setOrgId(((OrgVo)((Object)((Object)orgMap.get(t.getOrgName())))).getId());
            }
            if (StringUtils.isNotEmpty((String)t.getSpaceName()) && !CollectionUtils.isEmpty((Map)spaceDateMap) && null != spaceDateMap.get(t.getSpaceName().split(",")[0])) {
                t.setSpaceId(((BizExamSpaceData)((Object)((Object)spaceDateMap.get(t.getSpaceName())))).getId());
            }
            if (StringUtils.isNotEmpty((String)t.getPost()) && !CollectionUtils.isEmpty((Map)positionMap) && null != positionMap.get(t.getPost().split(",")[0])) {
                t.setPostId(((PositionVo)positionMap.get(t.getPost())).getPositionId());
            }
            if (StringUtils.isNotEmpty((String)t.getCoachName()) && !CollectionUtils.isEmpty((Map)userMap) && null != positionMap.get(t.getCoachName().split(",")[0])) {
                t.setCoachId(((IUser)userMap.get(t.getCoachName())).getUserId());
            }
        });
        this.planManager.saveBatch(planList);
    }

    @Override
    public void updateStatus(String id) {
        BizExamGeneralPlan bizExamPlan = (BizExamGeneralPlan)this.get((Serializable)((Object)id));
        Assert.notNull((Object)((Object)bizExamPlan), (String)"\u8bad\u7ec3\u8ba1\u5212\u4e0d\u5b58\u5728");
        if (!"0".equals(bizExamPlan.getPlanStatus())) {
            throw new BaseException("\u5df2\u4e0b\u53d1\u7684\u8ba1\u5212\u4e0d\u80fd\u518d\u6b21\u4e0b\u53d1");
        }
        bizExamPlan.setPlanStatus("1");
        boolean update = this.updateById((Object)bizExamPlan);
    }

    @Override
    public PageList<BizExamGeneralPlan> findByPage(QueryFilter<BizExamGeneralPlan> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BizExamGeneralPlan> result = ((BizExamGeneralPlanDao)this.baseMapper).findByPage((IPage<BizExamGeneralPlan>)this.convert2IPage(pageBean), (Wrapper<BizExamGeneralPlan>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Scheduled(cron="0 0 23 * * ? ")
    public void updatePlanStatus() {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        String[] plans = new String[]{"0", "2"};
        lambdaQueryWrapper.notIn(BizExamGeneralPlan::getPlanStatus, Arrays.asList(plans));
        lambdaQueryWrapper.ge(BizExamGeneralPlan::getEndTime, (Object)LocalDate.now());
        lambdaQueryWrapper.eq(BizExamGeneralPlan::getIsDele, (Object)DelStatusEnum.N.getType());
        List list = this.list((Wrapper)lambdaQueryWrapper);
        list.forEach(plan -> plan.setPlanStatus("3"));
        boolean b = this.updateBatchById(list);
    }
}

